/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.SnapshotMapSerializer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

public class DefaultHistoricalFileCollectionFingerprint
implements HistoricalFileCollectionFingerprint {
    private final Map<String, NormalizedFileSnapshot> fingerprints;
    private final FingerprintCompareStrategy compareStrategy;
    private final ImmutableMultimap<String, HashCode> rootHashes;

    public DefaultHistoricalFileCollectionFingerprint(Map<String, NormalizedFileSnapshot> fingerprints, FingerprintCompareStrategy compareStrategy, ImmutableMultimap<String, HashCode> rootHashes) {
        this.fingerprints = fingerprints;
        this.compareStrategy = compareStrategy;
        this.rootHashes = rootHashes;
    }

    @Override
    public boolean visitChangesSince(FileCollectionFingerprint oldFingerprint, String title, boolean includeAdded, TaskStateChangeVisitor visitor) {
        return this.compareStrategy.visitChangesSince(visitor, this.getSnapshots(), oldFingerprint.getSnapshots(), title, includeAdded);
    }

    @VisibleForTesting
    FingerprintCompareStrategy getCompareStrategy() {
        return this.compareStrategy;
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return this.fingerprints;
    }

    public ImmutableMultimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    @Override
    public HistoricalFileCollectionFingerprint archive() {
        return this;
    }

    public static class SerializerImpl
    implements Serializer<DefaultHistoricalFileCollectionFingerprint> {
        private final SnapshotMapSerializer snapshotMapSerializer;
        private final StringInterner stringInterner;
        private final HashCodeSerializer hashCodeSerializer;

        public SerializerImpl(StringInterner stringInterner) {
            this.snapshotMapSerializer = new SnapshotMapSerializer(stringInterner);
            this.stringInterner = stringInterner;
            this.hashCodeSerializer = new HashCodeSerializer();
        }

        public DefaultHistoricalFileCollectionFingerprint read(Decoder decoder) throws IOException {
            int type = decoder.readSmallInt();
            FingerprintCompareStrategy compareStrategy = FingerprintCompareStrategy.values()[type];
            Object snapshots = this.snapshotMapSerializer.read(decoder);
            ImmutableMultimap<String, HashCode> rootHashes = this.readRootHashes(decoder);
            return new DefaultHistoricalFileCollectionFingerprint((Map<String, NormalizedFileSnapshot>)snapshots, compareStrategy, rootHashes);
        }

        private ImmutableMultimap<String, HashCode> readRootHashes(Decoder decoder) throws IOException {
            int numberOfRoots = decoder.readSmallInt();
            if (numberOfRoots == 0) {
                return ImmutableMultimap.of();
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (int i = 0; i < numberOfRoots; ++i) {
                String absolutePath = this.stringInterner.intern(decoder.readString());
                HashCode rootHash = this.hashCodeSerializer.read(decoder);
                builder.put((Object)absolutePath, (Object)rootHash);
            }
            return builder.build();
        }

        public void write(Encoder encoder, DefaultHistoricalFileCollectionFingerprint value) throws Exception {
            encoder.writeSmallInt(value.compareStrategy.ordinal());
            this.snapshotMapSerializer.write(encoder, value.getSnapshots());
            this.writeRootHashes(encoder, value.getRootHashes());
        }

        private void writeRootHashes(Encoder encoder, ImmutableMultimap<String, HashCode> rootHashes) throws IOException {
            encoder.writeSmallInt(rootHashes.size());
            for (Map.Entry entry : rootHashes.entries()) {
                encoder.writeString((CharSequence)entry.getKey());
                this.hashCodeSerializer.write(encoder, (HashCode)entry.getValue());
            }
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            SerializerImpl rhs = (SerializerImpl)obj;
            return Objects.equal((Object)((Object)this.snapshotMapSerializer), (Object)((Object)rhs.snapshotMapSerializer)) && Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.snapshotMapSerializer, this.hashCodeSerializer});
        }
    }
}

