/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.BulkJobDelete;
import org.rundeck.client.api.model.BulkToggleJobExecutionResponse;
import org.rundeck.client.api.model.BulkToggleJobScheduleResponse;
import org.rundeck.client.api.model.DeleteJob;
import org.rundeck.client.api.model.DeleteJobsResult;
import org.rundeck.client.api.model.IdList;
import org.rundeck.client.api.model.ImportResult;
import org.rundeck.client.api.model.JobItem;
import org.rundeck.client.api.model.JobLoadItem;
import org.rundeck.client.api.model.Simple;
import org.rundeck.client.api.model.scheduler.ForecastJobItem;
import org.rundeck.client.api.model.scheduler.ScheduledJobItem;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.Run;
import org.rundeck.client.tool.commands.jobs.Files;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.BulkJobActionOptions;
import org.rundeck.client.tool.options.JobFileOptions;
import org.rundeck.client.tool.options.JobIdentOptions;
import org.rundeck.client.tool.options.JobListOptions;
import org.rundeck.client.tool.options.JobLoadOptions;
import org.rundeck.client.tool.options.JobOutputFormatOption;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.tool.options.VerboseOption;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.Format;
import org.rundeck.client.util.ServiceClient;
import org.rundeck.client.util.Util;
import picocli.CommandLine;
import retrofit2.Call;

@CommandLine.Command(name="jobs", description={"List and manage Jobs."}, subcommands={Files.class})
public class Jobs
extends BaseCommand {
    public static final String UUID_REMOVE = "remove";
    public static final String UUID_PRESERVE = "preserve";

    @CommandLine.Command(description={"Delete jobs matching the query parameters. Optionally save the definitions to a file before deleting from the server. --idlist/-i, or --job/-j or --group/-g or --jobxact/-J or --groupxact/-G Options are required."})
    public int purge(@CommandLine.Mixin Purge options, @CommandLine.Mixin JobOutputFormatOption jobOutputFormatOption, @CommandLine.Mixin JobFileOptions jobFileOptions, @CommandLine.Mixin JobListOptions jobListOptions) throws IOException, InputError {
        int batchToUse;
        int idsToDelete;
        List<Object> ids = new ArrayList();
        if (jobListOptions.isIdlist()) {
            ids = jobListOptions.getIdlist();
        } else {
            if (!(jobListOptions.isJob() || jobListOptions.isGroup() || jobListOptions.isGroupExact() || jobListOptions.isJobExact())) {
                throw new InputError("must specify -i, or -j/-g/-J/-G to specify jobs to delete.");
            }
            String project = this.getRdTool().projectOrEnv(jobListOptions);
            List body = (List)this.getRdTool().apiCall(api -> api.listJobs(project, jobListOptions.getJob(), jobListOptions.getGroup(), jobListOptions.getJobExact(), jobListOptions.getGroupExact()));
            for (JobItem jobItem : body) {
                ids.add(jobItem.getId());
            }
        }
        if (jobFileOptions.isFile()) {
            this.list(jobOutputFormatOption, jobFileOptions, jobListOptions);
        }
        int idsSize = ids.size();
        int n = idsToDelete = options.isMax() ? Math.min(idsSize, options.getMax()) : idsSize;
        if (!options.isConfirm()) {
            if (null == System.console()) {
                this.getRdOutput().error("No user interaction available. Use --confirm to confirm purge without user interaction");
                this.getRdOutput().warning(String.format("Not deleting %d jobs", idsToDelete));
                return 2;
            }
            String s = System.console().readLine("Really delete %d Jobs? (y/N) ", idsToDelete);
            if (!"y".equals(s)) {
                this.getRdOutput().warning(String.format("Not deleting %d jobs", idsToDelete));
                return 2;
            }
        }
        int batch = options.isBatchSize() ? Math.min(idsToDelete, options.getBatchSize()) : idsToDelete;
        int total = 0;
        for (int i = 0; i < idsToDelete; i += batchToUse) {
            batchToUse = Math.min(batch, idsToDelete - total);
            ArrayList<Object> finalIds = new ArrayList<Object>(batchToUse);
            finalIds.addAll(ids.subList(i, i + batchToUse));
            DeleteJobsResult deletedJobs = (DeleteJobsResult)this.getRdTool().apiCall(api -> api.deleteJobsBulk(new BulkJobDelete(finalIds)));
            if (!deletedJobs.isAllsuccessful()) {
                this.getRdOutput().error(String.format("Failed to delete %d Jobs%n", deletedJobs.getFailed().size()));
                this.getRdOutput().output(deletedJobs.getFailed().stream().map(DeleteJob::toBasicString).collect(Collectors.toList()));
                return 1;
            }
            total += finalIds.size();
        }
        this.getRdOutput().info(String.format("%d Jobs were deleted%n", total));
        return 0;
    }

    @CommandLine.Command(description={"Load Job definitions from a file in XML, YAML or JSON format."})
    public int load(@CommandLine.Mixin JobLoadOptions options, @CommandLine.Mixin JobFileOptions fileOptions, @CommandLine.Mixin ProjectNameOptions projectNameOptions, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        if (!fileOptions.isFile()) {
            throw new InputError("-f is required");
        }
        File input = fileOptions.getFile();
        if (!input.canRead() || !input.isFile()) {
            throw new InputError(String.format("File is not readable or does not exist: %s", input));
        }
        MediaType mediaType = Client.MEDIA_TYPE_XML;
        if (fileOptions.getFormat() == JobFileOptions.Format.yaml) {
            mediaType = Client.MEDIA_TYPE_YAML;
        } else if (fileOptions.getFormat() == JobFileOptions.Format.json) {
            mediaType = Client.MEDIA_TYPE_JSON;
        }
        RequestBody requestBody = RequestBody.create(input, mediaType);
        String project = this.getRdTool().projectOrEnv(projectNameOptions);
        ImportResult importResult = (ImportResult)this.getRdTool().apiCall(api -> api.loadJobs(project, requestBody, options.getDuplicate().toString(), options.isRemoveUuids() ? UUID_REMOVE : UUID_PRESERVE));
        List<JobLoadItem> failed = importResult.getFailed();
        this.printLoadResult(importResult.getSucceeded(), "Succeeded", verboseOption.isVerbose());
        this.printLoadResult(importResult.getSkipped(), "Skipped", verboseOption.isVerbose());
        this.printLoadResult(failed, "Failed", verboseOption.isVerbose());
        return failed == null || failed.isEmpty() ? 0 : 1;
    }

    private void printLoadResult(List<JobLoadItem> list, String title, boolean isVerbose) {
        if (null != list && !list.isEmpty()) {
            this.getRdOutput().info(String.format("%d Jobs %s:%n", list.size(), title));
            if (isVerbose) {
                this.getRdOutput().output(list);
            } else {
                this.getRdOutput().output(list.stream().map(JobLoadItem::toBasicString).collect(Collectors.toList()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CommandLine.Command(description={"List jobs found in a project, or download Job definitions (-f)."})
    public void list(@CommandLine.Mixin JobOutputFormatOption jobOutputFormatOption, @CommandLine.Mixin JobFileOptions jobFileOptions, @CommandLine.Mixin JobListOptions jobListOptions) throws IOException, InputError {
        String project = this.getRdTool().projectOrEnv(jobListOptions);
        if (jobFileOptions.isFile()) {
            ResponseBody body1 = jobListOptions.isIdlist() ? (ResponseBody)this.getRdTool().apiCall(api -> api.exportJobs(project, String.join((CharSequence)",", jobListOptions.getIdlist()), jobFileOptions.getFormat().toString())) : (ResponseBody)this.getRdTool().apiCall(api -> api.exportJobs(project, jobListOptions.getJob(), jobListOptions.getGroup(), jobListOptions.getJobExact(), jobListOptions.getGroupExact(), jobFileOptions.getFormat().toString()));
            try (ResponseBody body = body1;){
                if (jobFileOptions.getFormat() == JobFileOptions.Format.yaml && !ServiceClient.hasAnyMediaType(body.contentType(), Client.MEDIA_TYPE_YAML, Client.MEDIA_TYPE_TEXT_YAML) || jobFileOptions.getFormat() == JobFileOptions.Format.json && !ServiceClient.hasAnyMediaType(body.contentType(), Client.MEDIA_TYPE_JSON) || jobFileOptions.getFormat() == JobFileOptions.Format.xml && !ServiceClient.hasAnyMediaType(body.contentType(), Client.MEDIA_TYPE_XML, Client.MEDIA_TYPE_TEXT_XML)) {
                    throw new IllegalStateException("Unexpected response format: " + body.contentType());
                }
                InputStream inputStream2 = body.byteStream();
                if ("-".equals(jobFileOptions.getFile().getName())) {
                    Util.copyStream(inputStream2, System.out);
                    return;
                }
                try (FileOutputStream out = new FileOutputStream(jobFileOptions.getFile());){
                    long total = Util.copyStream(inputStream2, out);
                    if (jobOutputFormatOption.isOutputFormat()) return;
                    this.getRdOutput().info(String.format("Wrote %d bytes of %s to file %s%n", total, body.contentType(), jobFileOptions.getFile()));
                    return;
                }
            }
        } else {
            List body = jobListOptions.isIdlist() ? (List)this.getRdTool().apiCall(api -> api.listJobs(project, String.join((CharSequence)",", jobListOptions.getIdlist()))) : (List)this.getRdTool().apiCall(api -> api.listJobs(project, jobListOptions.getJob(), jobListOptions.getGroup(), jobListOptions.getJobExact(), jobListOptions.getGroupExact()));
            if (!jobOutputFormatOption.isOutputFormat()) {
                this.getRdOutput().info(String.format("%d Jobs in project %s%n", body.size(), project));
            }
            this.outputJobList(jobOutputFormatOption, body);
        }
    }

    private void outputJobList(JobOutputFormatOption options, List<JobItem> body) {
        if (options.isVerbose()) {
            this.getRdOutput().output(body.stream().map(JobItem::toMap).collect(Collectors.toList()));
            return;
        }
        Function<JobItem, Object> outformat = options.isOutputFormat() ? Format.formatter(options.getOutputFormat(), JobItem::toMap, "%", "") : JobItem::toBasicString;
        this.getRdOutput().output(body.stream().map(outformat).collect(Collectors.toList()));
    }

    @CommandLine.Command(description={"Get info about a Job by ID (API v18)"})
    public void info(@CommandLine.Option(names={"-i", "--id"}, description={"Job ID"}, required=true) String id, @CommandLine.Mixin JobOutputFormatOption outputFormatOption) throws IOException, InputError {
        ScheduledJobItem body = (ScheduledJobItem)this.getRdTool().apiCall(api -> api.getJobInfo(id));
        this.outputJobList(outputFormatOption, Collections.singletonList(body));
    }

    @CommandLine.Command(description={"Get Schedule Forecast for a Job by ID (API v31)"})
    public void forecast(@CommandLine.Option(names={"-i", "--id"}, description={"Job ID"}, required=true) String id, @CommandLine.Option(names={"-t", "--time"}, description={"Time ahead using number+unit. e.g. 1h (1 hour).\n Use: h,n,s,d,w,m,y (hour,minute,second,day,week,month,year)"}) String time, @CommandLine.Option(names={"-m", "--max"}, description={"Max number of results"}) Integer max) throws IOException, InputError {
        this.getRdTool().requireApiVersion("jobs forecast", 31);
        ForecastJobItem body = (ForecastJobItem)this.getRdTool().apiCall(api -> api.getJobForecast(id, time, max));
        this.getRdOutput().output("Forecast:");
        if (body.getFutureScheduledExecutions() != null) {
            this.getRdOutput().output(body.getFutureScheduledExecutions());
        }
    }

    @CommandLine.Command(description={"Enable execution for a job"})
    public int enable(@CommandLine.Mixin JobIdentOptions options) throws IOException, InputError {
        return this.simpleJobApiCall(RundeckApi::jobExecutionEnable, options, "Enabled Job %s") ? 0 : 1;
    }

    @CommandLine.Command(description={"Disable execution for a job"})
    public int disable(@CommandLine.Mixin JobIdentOptions options) throws IOException, InputError {
        return this.simpleJobApiCall(RundeckApi::jobExecutionDisable, options, "Disabled Job %s") ? 0 : 1;
    }

    @CommandLine.Command(description={"Enable schedule for a job"})
    public int reschedule(@CommandLine.Mixin JobIdentOptions options) throws IOException, InputError {
        return this.simpleJobApiCall(RundeckApi::jobScheduleEnable, options, "Enabled Schedule for Job %s") ? 0 : 1;
    }

    @CommandLine.Command(description={"Disable schedule for a job"})
    public int unschedule(@CommandLine.Mixin JobIdentOptions options) throws IOException, InputError {
        return this.simpleJobApiCall(RundeckApi::jobScheduleDisable, options, "Disabled Schedule for Job %s") ? 0 : 1;
    }

    private boolean simpleJobApiCall(BiFunction<RundeckApi, String, Call<Simple>> func, JobIdentOptions options, String success) throws InputError, IOException {
        String jobId = Run.getJobIdFromOpts(options, this.getRdOutput(), this.getRdTool(), () -> this.getRdTool().projectOrEnv(options));
        if (null == jobId) {
            return false;
        }
        Simple simple = (Simple)this.getRdTool().apiCall(api -> (Call)func.apply((RundeckApi)api, jobId));
        if (simple.isSuccess()) {
            this.getRdOutput().info(String.format(success, jobId));
        }
        return simple.isSuccess();
    }

    public static String[] splitJobNameParts(String job) {
        if (!job.contains("/")) {
            return new String[]{null, job};
        }
        int i = job.lastIndexOf(47);
        String group = job.substring(0, i);
        String name = job.substring(i + 1);
        if (group.trim().isEmpty()) {
            group = null;
        }
        return new String[]{group, name};
    }

    private List<String> getJobList(BulkJobActionOptions options) throws InputError, IOException {
        ArrayList<String> ids = new ArrayList();
        if (options.isIdlist()) {
            ids = options.getIdlist();
        } else {
            if (!(options.isJob() || options.isGroup() || options.isGroupExact() || options.isJobExact())) {
                throw new InputError("must specify -i, or -j/-g/-J/-G to specify jobs to enable.");
            }
            String project = this.getRdTool().projectOrEnv(options);
            List body = (List)this.getRdTool().apiCall(api -> api.listJobs(project, options.getJob(), options.getGroup(), options.getJobExact(), options.getGroupExact()));
            for (JobItem jobItem : body) {
                ids.add(jobItem.getId());
            }
        }
        return ids;
    }

    @CommandLine.Command(description={"Enable execution for a set of jobs. --idlist/-i, or --job/-j or --group/-g or --jobxact/-J or --groupxact/-G Options are required."})
    public int enablebulk(@CommandLine.Mixin BulkJobActionOptions options, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        List<String> ids = this.getJobList(options);
        if (!options.isConfirm()) {
            if (null == System.console()) {
                this.getRdOutput().error("No user interaction available. Use --confirm to confirm request without user interaction");
                this.getRdOutput().warning(String.format("Not enabling %d jobs", ids.size()));
                return 2;
            }
            String s = System.console().readLine("Really enable %d Jobs? (y/N) ", ids.size());
            if (!"y".equals(s)) {
                this.getRdOutput().warning(String.format("Not enabling %d jobs", ids.size()));
                return 2;
            }
        }
        List<String> finalIds = ids;
        BulkToggleJobExecutionResponse response = (BulkToggleJobExecutionResponse)this.getRdTool().apiCall(api -> api.bulkEnableJobs(new IdList(finalIds)));
        if (response.isAllsuccessful()) {
            this.getRdOutput().info(String.format("%d Jobs were enabled%n", response.getRequestCount()));
            if (verboseOption.isVerbose()) {
                this.getRdOutput().output(response.getSucceeded().stream().map(BulkToggleJobExecutionResponse.Result::toString).collect(Collectors.toList()));
            }
            return 0;
        }
        this.getRdOutput().error(String.format("Failed to enable %d Jobs%n", response.getFailed().size()));
        this.getRdOutput().output(response.getFailed().stream().map(BulkToggleJobExecutionResponse.Result::toString).collect(Collectors.toList()));
        return 1;
    }

    @CommandLine.Command(description={"Disable execution for a set of jobs. --idlist/-i, or --job/-j or --group/-g or --jobxact/-J or --groupxact/-G Options are required."})
    public int disablebulk(@CommandLine.Mixin BulkJobActionOptions options, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        List<String> ids = this.getJobList(options);
        if (!options.isConfirm()) {
            if (null == System.console()) {
                this.getRdOutput().error("No user interaction available. Use --confirm to confirm request without user interaction");
                this.getRdOutput().warning(String.format("Not disabling %d jobs", ids.size()));
                return 2;
            }
            String s = System.console().readLine("Really disable %d Jobs? (y/N) ", ids.size());
            if (!"y".equals(s)) {
                this.getRdOutput().warning(String.format("Not disabling %d jobs", ids.size()));
                return 2;
            }
        }
        List<String> finalIds = ids;
        BulkToggleJobExecutionResponse response = (BulkToggleJobExecutionResponse)this.getRdTool().apiCall(api -> api.bulkDisableJobs(new IdList(finalIds)));
        if (response.isAllsuccessful()) {
            this.getRdOutput().info(String.format("%d Jobs were disabled%n", response.getRequestCount()));
            if (verboseOption.isVerbose()) {
                this.getRdOutput().output(response.getSucceeded().stream().map(BulkToggleJobExecutionResponse.Result::toString).collect(Collectors.toList()));
            }
            return 0;
        }
        this.getRdOutput().error(String.format("Failed to disable %d Jobs%n", response.getFailed().size()));
        this.getRdOutput().output(response.getFailed().stream().map(BulkToggleJobExecutionResponse.Result::toString).collect(Collectors.toList()));
        return 1;
    }

    @CommandLine.Command(description={"Enable schedule for a set of jobs. --idlist/-i, or --job/-j or --group/-g or --jobxact/-J or --groupxact/-G Options are required."})
    public int reschedulebulk(@CommandLine.Mixin BulkJobActionOptions options, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        List<String> ids = this.getJobList(options);
        if (!options.isConfirm()) {
            if (null == System.console()) {
                this.getRdOutput().error("No user interaction available. Use --confirm to confirm request without user interaction");
                this.getRdOutput().warning(String.format("Not rescheduling %d jobs", ids.size()));
                return 2;
            }
            String s = System.console().readLine("Really reschedule %d Jobs? (y/N) ", ids.size());
            if (!"y".equals(s)) {
                this.getRdOutput().warning(String.format("Not rescheduling %d jobs", ids.size()));
                return 2;
            }
        }
        List<String> finalIds = ids;
        BulkToggleJobScheduleResponse response = (BulkToggleJobScheduleResponse)this.getRdTool().apiCall(api -> api.bulkEnableJobSchedule(new IdList(finalIds)));
        if (response.isAllsuccessful()) {
            this.getRdOutput().info(String.format("%d Jobs were rescheduled%n", response.getRequestCount()));
            if (verboseOption.isVerbose()) {
                this.getRdOutput().output(response.getSucceeded().stream().map(BulkToggleJobScheduleResponse.Result::toString).collect(Collectors.toList()));
            }
            return 0;
        }
        this.getRdOutput().error(String.format("Failed to reschedule %d Jobs%n", response.getFailed().size()));
        this.getRdOutput().output(response.getFailed().stream().map(BulkToggleJobScheduleResponse.Result::toString).collect(Collectors.toList()));
        return 1;
    }

    @CommandLine.Command(description={"Disable schedule for a set of jobs. --idlist/-i, or --job/-j or --group/-g or --jobxact/-J or --groupxact/-G Options are required."})
    public int unschedulebulk(@CommandLine.Mixin BulkJobActionOptions options, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        List<String> ids = this.getJobList(options);
        if (!options.isConfirm()) {
            if (null == System.console()) {
                this.getRdOutput().error("No user interaction available. Use --confirm to confirm request without user interaction");
                this.getRdOutput().warning(String.format("Not unscheduling %d jobs", ids.size()));
                return 2;
            }
            String s = System.console().readLine("Really unschedule %d Jobs? (y/N) ", ids.size());
            if (!"y".equals(s)) {
                this.getRdOutput().warning(String.format("Not unscheduling %d jobs", ids.size()));
                return 2;
            }
        }
        List<String> finalIds = ids;
        BulkToggleJobScheduleResponse response = (BulkToggleJobScheduleResponse)this.getRdTool().apiCall(api -> api.bulkDisableJobSchedule(new IdList(finalIds)));
        if (response.isAllsuccessful()) {
            this.getRdOutput().info(String.format("%d Jobs were unsheduled%n", response.getRequestCount()));
            if (verboseOption.isVerbose()) {
                this.getRdOutput().output(response.getSucceeded().stream().map(BulkToggleJobScheduleResponse.Result::toString).collect(Collectors.toList()));
            }
            return 0;
        }
        this.getRdOutput().error(String.format("Failed to disable %d Jobs%n", response.getFailed().size()));
        this.getRdOutput().output(response.getFailed().stream().map(BulkToggleJobScheduleResponse.Result::toString).collect(Collectors.toList()));
        return 1;
    }

    public static class Purge {
        @CommandLine.Option(names={"--confirm", "-y"}, description={"Force confirmation of delete request."})
        boolean confirm;
        @CommandLine.Option(names={"--batch", "-b"}, description={"Batch size if there are many IDs"})
        Integer batchSize;
        @CommandLine.Option(names={"--max", "-m"}, description={"Maximum number of jobs to delete"})
        Integer max;

        boolean isBatchSize() {
            return this.batchSize != null && this.batchSize > 0;
        }

        boolean isMax() {
            return this.max != null && this.max > 0;
        }

        public boolean isConfirm() {
            return this.confirm;
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setConfirm(boolean confirm) {
            this.confirm = confirm;
        }

        public void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public void setMax(Integer max) {
            this.max = max;
        }
    }
}

