/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableUsageFinderFunction;
import net.sourceforge.pmd.util.Applier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassScope
extends AbstractScope {
    protected Map<ClassNameDeclaration, List<NameOccurrence>> classNames = new HashMap<ClassNameDeclaration, List<NameOccurrence>>();
    protected Map<MethodNameDeclaration, List<NameOccurrence>> methodNames = new HashMap<MethodNameDeclaration, List<NameOccurrence>>();
    protected Map<VariableNameDeclaration, List<NameOccurrence>> variableNames = new HashMap<VariableNameDeclaration, List<NameOccurrence>>();
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    @Override
    public void addDeclaration(VariableNameDeclaration variableDecl) {
        if (this.variableNames.containsKey(variableDecl)) {
            throw new RuntimeException(variableDecl + " is already in the symbol table");
        }
        this.variableNames.put(variableDecl, new ArrayList());
    }

    @Override
    public NameDeclaration addVariableNameOccurrence(NameOccurrence occurrence) {
        List<NameOccurrence> nameOccurrences;
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && occurrence.isMethodOrConstructorInvocation()) {
            List<NameOccurrence> nameOccurrences2 = this.methodNames.get(decl);
            if (nameOccurrences2 != null) {
                nameOccurrences2.add(occurrence);
                SimpleNode n = occurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !occurrence.isThisOrSuper() && (nameOccurrences = this.variableNames.get(decl)) != null) {
            nameOccurrences.add(occurrence);
            SimpleNode n = occurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    @Override
    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        VariableUsageFinderFunction f = new VariableUsageFinderFunction(this.variableNames);
        Applier.apply(f, this.variableNames.keySet().iterator());
        return f.getUsed();
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.methodNames;
    }

    @Override
    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.classNames;
    }

    @Override
    public ClassScope getEnclosingClassScope() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void addDeclaration(MethodNameDeclaration decl) {
        this.methodNames.put(decl, new ArrayList());
    }

    @Override
    public void addDeclaration(ClassNameDeclaration decl) {
        this.classNames.put(decl, new ArrayList());
    }

    @Override
    protected NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (this.variableNames.isEmpty() && this.methodNames.isEmpty()) {
                return null;
            }
            if (!this.variableNames.isEmpty()) {
                return this.variableNames.keySet().iterator().next();
            }
            return this.methodNames.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : this.methodNames.keySet()) {
                int args;
                if (!mnd.getImage().equals(occurrence.getImage()) || (args = occurrence.getArgumentCount()) != mnd.getParameterCount()) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, this.variableNames.keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        String res = "ClassScope (" + this.className + "): ";
        if (!this.classNames.isEmpty()) {
            res = res + "(" + this.glomNames(this.classNames.keySet()) + ")";
        }
        if (!this.methodNames.isEmpty()) {
            for (MethodNameDeclaration mnd : this.methodNames.keySet()) {
                res = res + mnd.toString();
                int usages = this.methodNames.get(mnd).size();
                res = res + "(begins at line " + mnd.getNode().getBeginLine() + ", " + usages + " usages)";
                res = res + ",";
            }
        }
        if (!this.variableNames.isEmpty()) {
            res = res + "(" + this.glomNames(this.variableNames.keySet()) + ")";
        }
        return res;
    }

    private String clipClassName(String in) {
        return in.substring(in.indexOf(46) + 1);
    }
}

