/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.language;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.model.Model;
import org.argouml.notation.Notation;
import org.argouml.notation.NotationName;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.GeneratorHelper;
import org.argouml.uml.generator.GeneratorManager;
import org.argouml.uml.generator.Language;
import org.argouml.uml.generator.SourceUnit;
import org.dbuml.base.controller.ActionsInterface;
import org.dbuml.base.factory.Factory;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.DBModelFacade;

public class GeneratorSQL
implements CodeGenerator {
    private static final GeneratorSQL SINGLETON = new GeneratorSQL();
    private static final Logger LOG = Logger.getLogger(GeneratorSQL.class);

    private GeneratorSQL() {
        NotationName nn = Notation.makeNotation((String)"SQL", null, (Icon)ResourceLoaderWrapper.lookupIconResource((String)"JavaNotation"));
        String cv = nn.getConfigurationValue();
        Language lang = GeneratorHelper.makeLanguage((String)cv, (String)nn.getTitle(), (Icon)nn.getIcon());
        GeneratorManager.getInstance().addGenerator(lang, (CodeGenerator)this);
    }

    public static GeneratorSQL getInstance() {
        return SINGLETON;
    }

    private String generateSource(Object obj) {
        Factory fac = DBModelFacade.getInstance().getMyFactory(obj);
        String retVal = null;
        if (fac != null) {
            ActionsInterface actionsinterface = fac.getActionsInterface();
            retVal = actionsinterface.generateSource(obj, false, true);
        } else {
            retVal = Translator.getInstance().localize("GENSQL_FAILURE_TITLE") + Translator.getInstance().localize("DB_FACTORY_NOTFOUND");
        }
        return retVal;
    }

    private String generatePath(Object cls) {
        String packagePath = this.generateRelativePackage(cls, null, CodeGenerator.FILE_SEPARATOR);
        packagePath = packagePath.substring(1);
        return packagePath;
    }

    private String generateRelativePackage(Object cls, Object pack, String sep) {
        StringBuffer packagePath = new StringBuffer();
        Object parent = Model.getFacade().getNamespace(cls);
        while (parent != null && parent != pack) {
            Object grandParent = Model.getFacade().getNamespace(parent);
            if (grandParent != null) {
                String name = Model.getFacade().getName(parent);
                if (packagePath.length() > 0) {
                    packagePath.insert(0, sep);
                }
                packagePath.insert(0, name);
            }
            parent = grandParent;
        }
        if (parent == null) {
            packagePath.insert(0, sep);
        }
        return packagePath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection generateFilesForElem(Object o, String path) {
        Vector<String> ret = new Vector<String>();
        String pathname = this.createDirectoriesPathname(o, path);
        String fileContent = this.generateSource(o);
        if (fileContent.length() != 0) {
            BufferedWriter fos = null;
            File f = new File(pathname);
            try {
                fos = new BufferedWriter(new FileWriter(f));
                fos.write(fileContent);
            }
            catch (IOException exp) {
                System.err.println("Ignored " + exp.getMessage());
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException exp) {
                    LOG.error((Object)("FAILED: " + f.getPath()));
                }
            }
            LOG.info((Object)("written: " + pathname));
            ret.add(pathname);
        }
        return ret;
    }

    private String createDirectoriesPathname(Object cls, String path) {
        String name = Model.getFacade().getName(cls);
        String pathname = "";
        if (name != null && name.length() > 0) {
            if (!path.endsWith(CodeGenerator.FILE_SEPARATOR)) {
                path = path + CodeGenerator.FILE_SEPARATOR;
            }
            String packagePath = this.generateRelativePackage(cls, null, ".");
            packagePath = packagePath.substring(1);
            String filename = name + ".sql";
            int lastIndex = -1;
            while (true) {
                File f;
                if (!(f = new File(path)).isDirectory() && !f.mkdir()) {
                    LOG.error((Object)(" could not make directory " + path));
                    path = null;
                    break;
                }
                if (lastIndex == packagePath.length()) break;
                int index = packagePath.indexOf(".", lastIndex + 1);
                if (index == -1) {
                    index = packagePath.length();
                }
                path = path + packagePath.substring(lastIndex + 1, index) + CodeGenerator.FILE_SEPARATOR;
                lastIndex = index;
            }
            if (pathname != null) {
                pathname = path + filename;
            }
        }
        return pathname;
    }

    public Collection generate(Collection elements, boolean deps) {
        ArrayList<SourceUnit> ret = new ArrayList<SourceUnit>();
        for (Object elem : elements) {
            String path = this.generatePath(elem);
            String name = Model.getFacade().getName(elem) + "sql";
            String content = this.generateSource(elem);
            SourceUnit su = new SourceUnit(name, path, content);
            ret.add(su);
        }
        return ret;
    }

    public Collection generateFileList(Collection elements, boolean deps) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object elem : elements) {
            ret.add(Model.getFacade().getName(elem) + ".sql");
        }
        return null;
    }

    public Collection generateFiles(Collection elements, String path, boolean deps) {
        ArrayList ret = new ArrayList();
        for (Object elem : elements) {
            ret.addAll(this.generateFilesForElem(elem, path));
        }
        return ret;
    }
}

