/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPasswordField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordGroup
implements ProcessingClient {
    private Vector<JPasswordField> fields = new Vector();
    private List<ValidatorContainer> validatorContainers = null;
    private Processor processor = null;
    private String modifiedPassword = null;
    private int currentValidator = 0;
    private InstallData idata;

    public PasswordGroup(InstallData installData, List<ValidatorContainer> list, String string) {
        try {
            this.idata = installData;
            this.validatorContainers = list;
        }
        catch (Throwable throwable) {
            Debug.trace("Failed in PasswordGroup constructor: " + throwable);
            this.validatorContainers = null;
        }
        try {
            this.processor = (Processor)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            Debug.trace("Failed in PasswordGroup constructor making processor: " + throwable);
            this.processor = null;
        }
    }

    public InstallData getIdata() {
        return this.idata;
    }

    @Override
    public int getNumFields() {
        return this.fields.size();
    }

    @Override
    public String getFieldContents(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.fields.size()) {
            throw new IndexOutOfBoundsException();
        }
        String string = new String(this.fields.elementAt(n).getPassword());
        return string;
    }

    public void addField(JPasswordField jPasswordField) {
        if (jPasswordField != null) {
            this.fields.add(jPasswordField);
        }
    }

    public boolean validateContents(int n) {
        boolean bl = true;
        try {
            this.currentValidator = n;
            ValidatorContainer validatorContainer = this.getValidatorContainer(n);
            Validator validator = validatorContainer.getValidator();
            if (validator != null) {
                bl = validator.validate(this);
            }
        }
        catch (Exception exception) {
            Debug.trace("validateContents(" + n + ") failed: " + exception);
        }
        return bl;
    }

    public String getValidatorMessage(int n) {
        String string = null;
        try {
            ValidatorContainer validatorContainer = this.getValidatorContainer(n);
            if (validatorContainer != null) {
                string = validatorContainer.getMessage();
            }
        }
        catch (Exception exception) {
            Debug.trace("getValidatorMessage(" + n + ") failed: " + exception);
        }
        return string;
    }

    public int validatorSize() {
        int n = 0;
        if (this.validatorContainers != null) {
            n = this.validatorContainers.size();
        }
        return n;
    }

    public ValidatorContainer getValidatorContainer() {
        return this.getValidatorContainer(this.currentValidator);
    }

    public ValidatorContainer getValidatorContainer(int n) {
        ValidatorContainer validatorContainer = null;
        try {
            validatorContainer = this.validatorContainers.get(n);
        }
        catch (Exception exception) {
            validatorContainer = null;
        }
        return validatorContainer;
    }

    @Override
    public boolean hasParams() {
        return this.hasParams(this.currentValidator);
    }

    public boolean hasParams(int n) {
        boolean bl = false;
        try {
            ValidatorContainer validatorContainer = this.getValidatorContainer(n);
            if (validatorContainer != null) {
                bl = validatorContainer.hasParams();
            }
        }
        catch (Exception exception) {
            Debug.trace("hasParams(" + n + ") failed: " + exception);
        }
        return bl;
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.getValidatorParams(this.currentValidator);
    }

    public Map<String, String> getValidatorParams(int n) {
        Map<String, String> map = null;
        try {
            ValidatorContainer validatorContainer = this.getValidatorContainer(n);
            if (validatorContainer != null) {
                map = validatorContainer.getValidatorParams();
            }
        }
        catch (Exception exception) {
            Debug.trace("getValidatorParams(" + n + ") failed: " + exception);
        }
        return map;
    }

    @Override
    public String getText() {
        return this.getValidatorMessage(this.currentValidator);
    }

    public void setModifiedPassword(String string) {
        this.modifiedPassword = string;
    }

    public String getPassword() {
        String string = "";
        if (this.modifiedPassword != null) {
            string = this.modifiedPassword;
            if (this.processor != null) {
                Debug.trace("Validator changed password, PROCESSOR WILL NOT RUN!");
            }
        } else if (this.processor != null) {
            string = this.processor.process(this);
        } else if (this.fields.size() > 0) {
            string = new String(this.fields.elementAt(0).getPassword());
        }
        return string;
    }
}

