/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.spell;

import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.SpellCountCalc;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;
import pcgen.util.Logging;

public class ProhibitedToken
implements PrimitiveToken<Spell>,
PrimitiveFilter<Spell> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private boolean prohibited;
    private CDOMReference<Spell> allSpells;

    public boolean initialize(LoadContext context, Class<Spell> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        if ("YES".equals(value)) {
            this.prohibited = true;
        } else if ("NO".equals(value)) {
            this.prohibited = false;
        } else {
            Logging.errorPrint((String)("Did not understand Prohibited value: " + value));
            return false;
        }
        this.allSpells = context.getReferenceContext().getCDOMAllReference(SPELL_CLASS);
        return true;
    }

    public String getTokenName() {
        return "PROHIBITED";
    }

    public Class<Spell> getReferenceClass() {
        return SPELL_CLASS;
    }

    public String getLSTformat(boolean useAny) {
        return this.getTokenName() + "=" + (this.prohibited ? "YES" : "NO");
    }

    public boolean allow(PlayerCharacter pc, Spell spell) {
        for (PCClass cl : pc.getDisplay().getClassSet()) {
            if (this.prohibited != SpellCountCalc.isProhibited((Spell)spell, (PCClass)cl, (PlayerCharacter)pc)) continue;
            return false;
        }
        return true;
    }

    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProhibitedToken) {
            ProhibitedToken other = (ProhibitedToken)obj;
            return this.prohibited == other.prohibited;
        }
        return false;
    }

    public int hashCode() {
        return this.prohibited ? 1345 : 999234;
    }

    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Spell, R> c) {
        return c.convert(this.allSpells, (PrimitiveFilter)this);
    }
}

