/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.persistence.PersistenceManager;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreCampaignTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int number;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreFeat.error", (Object[])new Object[]{prereq.toString()}));
        }
        int runningTotal = 0;
        runningTotal = prereq.getKey().startsWith("BOOKTYPE=") ? (runningTotal += this.countCampaignByBookType(prereq.getKey().substring(9), false)) : (prereq.getKey().startsWith("INCLUDESBOOKTYPE=") ? (runningTotal += this.countCampaignByBookType(prereq.getKey().substring(17), true)) : (prereq.getKey().startsWith("INCLUDES=") ? (runningTotal += this.countCampaignByName(prereq.getKey().substring(9), source, true)) : (runningTotal += this.countCampaignByName(prereq.getKey(), source, false))));
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    private int countCampaignByBookType(String bookType, boolean includeSubCampaigns) {
        HashSet<Campaign> matchingCampaigns = new HashSet<Campaign>();
        PersistenceManager pMan = PersistenceManager.getInstance();
        List selCampaigns = pMan.getChosenCampaignSourcefiles();
        for (URI element : selCampaigns) {
            List<Campaign> fullCampList;
            Campaign aCampaign = Globals.getCampaignByURI((URI)element, (boolean)false);
            if (includeSubCampaigns) {
                fullCampList = this.getFullCampaignList(aCampaign);
            } else {
                fullCampList = new ArrayList<Campaign>();
                fullCampList.add(aCampaign);
            }
            block1: for (Campaign camp : fullCampList) {
                for (String listType : camp.getBookTypeList()) {
                    if (!bookType.equalsIgnoreCase(listType)) continue;
                    matchingCampaigns.add(camp);
                    continue block1;
                }
            }
        }
        return matchingCampaigns.size();
    }

    private int countCampaignByName(String key, CDOMObject source, boolean includeSubCampaigns) {
        int total = 0;
        Campaign campaignToFind = Globals.getCampaignKeyedSilently((String)key);
        if (campaignToFind != null) {
            PersistenceManager pMan = PersistenceManager.getInstance();
            List selCampaigns = pMan.getChosenCampaignSourcefiles();
            for (URI element : selCampaigns) {
                Campaign aCampaign = Globals.getCampaignByURI((URI)element);
                if (includeSubCampaigns) {
                    List<Campaign> campList = this.getFullCampaignList(aCampaign);
                    for (Campaign camp : campList) {
                        if (!camp.equals((Object)campaignToFind)) continue;
                        ++total;
                    }
                    continue;
                }
                if (!aCampaign.equals((Object)campaignToFind)) continue;
                ++total;
            }
        } else {
            String sourceUri = source == null ? "" : String.valueOf(source.getSourceURI());
            Logging.errorPrint((String)("Unable to find campaign " + key + " used in prereq for source " + source + " at " + sourceUri));
        }
        return total;
    }

    private List<Campaign> getFullCampaignList(Campaign aCampaign) {
        ArrayList<Campaign> campList = new ArrayList<Campaign>();
        this.addChildrenRecursively(campList, aCampaign);
        return campList;
    }

    private void addChildrenRecursively(List<Campaign> campList, Campaign aCampaign) {
        campList.add(aCampaign);
        for (Campaign subCampaign : aCampaign.getSubCampaigns()) {
            this.addChildrenRecursively(campList, subCampaign);
        }
    }

    public String kindHandled() {
        return "CAMPAIGN";
    }

    public String toHtmlString(Prerequisite prereq) {
        if (prereq.getOperator() == PrerequisiteOperator.GTEQ && "1".equals(prereq.getOperand())) {
            return prereq.getKey();
        }
        String foo = LanguageBundle.getFormattedString((String)"PreCampaign.toHtml", (Object[])new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), prereq.getKey()});
        return foo;
    }
}

