/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.core.Language;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class AllowDupesToken
extends AbstractNonEmptyToken<Campaign>
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "ALLOWDUPES";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Campaign obj, String value) {
        if ("SPELL".equals(value)) {
            context.getObjectContext().addToList((CDOMObject)obj, ListKey.DUPES_ALLOWED, Spell.class);
            return ParseResult.SUCCESS;
        }
        if ("LANGUAGE".equals(value)) {
            context.getObjectContext().addToList((CDOMObject)obj, ListKey.DUPES_ALLOWED, Language.class);
            return ParseResult.SUCCESS;
        }
        return new ParseResult.Fail("Token must be SPELL or LANGUAGE", context);
    }

    public String[] unparse(LoadContext context, Campaign obj) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)obj, ListKey.DUPES_ALLOWED);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection added = changes.getAdded();
        TreeSet<String> returnSet = new TreeSet<String>();
        for (Class cl : added) {
            returnSet.add(StringPClassUtil.getStringFor((Class)cl));
        }
        return returnSet.toArray(new String[returnSet.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

