/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.gui.FlippingSplitPane;
import gmgen.gui.PreferencesPanel;
import gmgen.gui.PreferencesRootTreeNode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import pcgen.core.SettingsHandler;
import pcgen.gui2.dialog.AbstractPreferencesDialog;

public class PreferencesDialog
extends AbstractPreferencesDialog {
    private static final String OPTION_NAME_DIVIDER = "PreferencesDialog.PrefsDividerLocation";
    private static final String OPTION_NAME_X = "PreferencesDialog.PrefsWindowX";
    private static final String OPTION_NAME_Y = "PreferencesDialog.PrefsWindowY";
    private static final String OPTION_NAME_WIDTH = "PreferencesDialog.PrefsWindowWidth";
    private static final String OPTION_NAME_HEIGHT = "PreferencesDialog.PrefsWindowHeight";
    private static final String EMPTY = PreferencesDialog.class.getName();
    private FlippingSplitPane jSplitPane1;
    private JTree prefsTree;
    private PreferencesRootTreeNode root;
    private JPanel prefsPane;
    private CardLayout cardLayout;

    public PreferencesDialog(JFrame parent, boolean modal, PreferencesRootTreeNode root) {
        super(parent, "GMGen", modal);
        this.root = root;
        this.prefsTree.setModel(new DefaultTreeModel(root));
        this.initLast();
        this.initPreferences();
    }

    public void applyPreferences() {
        for (PreferencesPanel panel : this.root.getPanelList()) {
            panel.applyPreferences();
        }
    }

    private void PrefsTreeActionPerformed() {
        Object obj = this.prefsTree.getLastSelectedPathComponent();
        if (obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object uobj = node.getUserObject();
            if (uobj instanceof PreferencesPanel) {
                this.cardLayout.show(this.prefsPane, uobj.toString());
            } else {
                this.cardLayout.show(this.prefsPane, EMPTY);
            }
        }
    }

    @Override
    public void applyButtonActionPerformed() {
        this.applyPreferences();
    }

    @Override
    protected void close() {
        SettingsHandler.setGMGenOption(OPTION_NAME_DIVIDER, this.jSplitPane1.getDividerLocation());
        SettingsHandler.setGMGenOption(OPTION_NAME_X, this.getX());
        SettingsHandler.setGMGenOption(OPTION_NAME_Y, this.getY());
        SettingsHandler.setGMGenOption(OPTION_NAME_WIDTH, this.getSize().width);
        SettingsHandler.setGMGenOption(OPTION_NAME_HEIGHT, this.getSize().height);
        super.close();
    }

    @Override
    protected JComponent getCenter() {
        this.jSplitPane1 = new FlippingSplitPane();
        this.prefsTree = new JTree();
        this.prefsTree.setRootVisible(false);
        this.prefsTree.setShowsRootHandles(true);
        this.cardLayout = new CardLayout();
        this.prefsPane = new JPanel(this.cardLayout);
        this.prefsPane.add((Component)new JPanel(), EMPTY);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferencesDialog.this.close();
            }
        });
        this.jSplitPane1.setLeftComponent(new JScrollPane(this.prefsTree, 20, 30));
        this.prefsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PreferencesDialog.this.PrefsTreeActionPerformed();
            }
        });
        this.jSplitPane1.setRightComponent(this.prefsPane);
        return this.jSplitPane1;
    }

    private void initLast() {
        int iDividerLocation = SettingsHandler.getGMGenOption(OPTION_NAME_DIVIDER, 118);
        this.jSplitPane1.setDividerLocation(iDividerLocation);
        int iWinX = SettingsHandler.getGMGenOption(OPTION_NAME_X, 0);
        int iWinY = SettingsHandler.getGMGenOption(OPTION_NAME_Y, 0);
        this.setLocation(iWinX, iWinY);
        int iWinWidth = SettingsHandler.getGMGenOption(OPTION_NAME_WIDTH, 550);
        int iWinHeight = SettingsHandler.getGMGenOption(OPTION_NAME_HEIGHT, 385);
        this.setSize(iWinWidth, iWinHeight);
    }

    private void initPreferences() {
        for (PreferencesPanel panel : this.root.getPanelList()) {
            panel.initPreferences();
            JPanel jp = new JPanel(new BorderLayout());
            JLabel comp = new JLabel(panel.toString());
            Font f = UIManager.getFont("TitledBorder.font");
            comp.setFont(f);
            jp.add((Component)comp, "North");
            jp.add((Component)panel, "Center");
            this.prefsPane.add((Component)jp, panel.toString());
        }
    }
}

