/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import pcgen.cdom.base.PCGenIdentifier;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.util.Logging;

public abstract class AbstractItemFacet<IDT extends PCGenIdentifier, T>
extends AbstractDataFacet<IDT, T> {
    public boolean set(IDT id, T obj) {
        if (obj == null) {
            Logging.errorPrint(this.getClass() + " received null item: ignoring");
            return false;
        }
        T old = this.get(id);
        if (old != obj) {
            if (old != null) {
                this.fireDataFacetChangeEvent(id, old, 1);
            }
            this.setCache(id, obj);
            this.fireDataFacetChangeEvent(id, obj, 0);
            return true;
        }
        return false;
    }

    public T remove(IDT id) {
        Object old = this.removeCache(id);
        if (old != null) {
            this.fireDataFacetChangeEvent(id, old, 1);
        }
        return (T)old;
    }

    public T get(IDT id) {
        return (T)this.getCache(id);
    }

    public boolean matches(IDT id, T obj) {
        T current = this.get(id);
        return obj == null && current == null || obj != null && obj.equals(current);
    }

    @Override
    public void copyContents(IDT source, IDT copy) {
        T obj = this.get(source);
        if (obj != null) {
            this.setCache(copy, obj);
        }
    }
}

