/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.model;

import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import pcgen.cdom.base.SetFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.output.publish.OutputDB;

public class ClassFacet
extends AbstractDataFacet<CharID, PCClass>
implements SetFacet<CharID, PCClass> {
    private final ClassLevelChangeSupport support = new ClassLevelChangeSupport();

    public void addClass(CharID id, PCClass obj) {
        if (obj == null) {
            throw new IllegalArgumentException("PCClass to add may not be null");
        }
        if (this.getConstructingClassInfo(id).addClass(obj)) {
            this.fireDataFacetChangeEvent(id, obj, 0);
        }
    }

    public boolean setClassLevel(CharID id, PCClass pcc, PCClassLevel pcl) throws CloneNotSupportedException {
        if (pcc == null) {
            throw new IllegalArgumentException("Class cannot be null in setClassLevel");
        }
        if (pcl == null) {
            throw new IllegalArgumentException("Class Level cannot be null in setClassLevel");
        }
        ClassInfo info = this.getClassInfo(id);
        if (info == null) {
            return false;
        }
        PCClassLevel old = info.getClassLevel(pcc, pcl.get(IntegerKey.LEVEL));
        boolean returnVal = info.setClassLevel(pcc, pcl);
        this.support.fireClassLevelObjectChangeEvent(id, pcc, old, pcl);
        return returnVal;
    }

    public PCClassLevel getClassLevel(CharID id, PCClass obj, int level) {
        ClassInfo info = this.getClassInfo(id);
        if (info == null) {
            return null;
        }
        return info.getClassLevel(obj, level);
    }

    public void removeClass(CharID id, PCClass obj) {
        if (obj == null) {
            throw new IllegalArgumentException("PCClass to add may not be null");
        }
        ClassInfo info = this.getClassInfo(id);
        if (info != null) {
            if (info.containsClass(obj)) {
                this.setLevel(id, obj, 0);
                info.removeClass(obj);
                this.fireDataFacetChangeEvent(id, obj, 1);
            }
            if (info.isEmpty()) {
                this.removeCache(id);
            }
        }
    }

    public ClassInfo removeAllClasses(CharID id) {
        ClassInfo info = (ClassInfo)this.removeCache(id);
        if (info != null) {
            for (PCClass obj : info.getClassSet()) {
                this.fireDataFacetChangeEvent(id, obj, 1);
                int oldLevel = info.getLevel(obj);
                this.support.fireClassLevelChangeEvent(id, obj, oldLevel, 0);
            }
        }
        return info;
    }

    public void replaceClass(CharID id, PCClass oldClass, PCClass newClass) {
        ClassInfo info = this.getClassInfo(id);
        if (info != null) {
            info.replace(oldClass, newClass);
        }
    }

    @Override
    public Set<PCClass> getSet(CharID id) {
        ClassInfo info = this.getClassInfo(id);
        if (info == null) {
            return Collections.emptySet();
        }
        return info.getClassSet();
    }

    @Override
    public int getCount(CharID id) {
        ClassInfo info = this.getClassInfo(id);
        if (info == null) {
            return 0;
        }
        return info.classCount();
    }

    public boolean isEmpty(CharID id) {
        ClassInfo info = this.getClassInfo(id);
        return info == null || info.isEmpty();
    }

    public boolean contains(CharID id, PCClass obj) {
        ClassInfo info = this.getClassInfo(id);
        return info != null && info.containsClass(obj);
    }

    public void setLevel(CharID id, PCClass pcc, int level) {
        int oldLevel = this.getConstructingClassInfo(id).setLevel(pcc, level);
        this.support.fireClassLevelChangeEvent(id, pcc, oldLevel, level);
    }

    public int getLevel(CharID id, PCClass pcc) {
        ClassInfo info = this.getClassInfo(id);
        return info == null ? 0 : info.getLevel(pcc);
    }

    private ClassInfo getClassInfo(CharID id) {
        return (ClassInfo)this.getCache(id);
    }

    private ClassInfo getConstructingClassInfo(CharID id) {
        ClassInfo info = this.getClassInfo(id);
        if (info == null) {
            info = new ClassInfo();
            this.setCache(id, info);
        }
        return info;
    }

    @Override
    public void copyContents(CharID source, CharID destination) {
        ClassInfo info = this.getClassInfo(source);
        if (info != null) {
            this.setCache(destination, new ClassInfo(info));
        }
    }

    public void addLevelChangeListener(ClassLevelChangeListener listener) {
        this.support.addLevelChangeListener(listener);
    }

    public ClassLevelChangeListener[] getLevelChangeListeners() {
        return this.support.getLevelChangeListeners();
    }

    public void removeLevelChangeListener(ClassLevelChangeListener listener) {
        this.support.removeLevelChangeListener(listener);
    }

    public void init() {
        OutputDB.register("classes", this);
    }

    public static class ClassLevelChangeSupport {
        private final EventListenerList listenerList = new EventListenerList();

        public void addLevelChangeListener(ClassLevelChangeListener listener) {
            this.listenerList.add(ClassLevelChangeListener.class, listener);
        }

        public synchronized ClassLevelChangeListener[] getLevelChangeListeners() {
            return (ClassLevelChangeListener[])this.listenerList.getListeners(ClassLevelChangeListener.class);
        }

        public void removeLevelChangeListener(ClassLevelChangeListener listener) {
            this.listenerList.remove(ClassLevelChangeListener.class, listener);
        }

        protected void fireClassLevelChangeEvent(CharID id, PCClass pcc, int oldLevel, int newLevel) {
            if (oldLevel == newLevel) {
                return;
            }
            ClassLevelChangeListener[] listeners = (ClassLevelChangeListener[])this.listenerList.getListeners(ClassLevelChangeListener.class);
            ClassLevelChangeEvent ccEvent = null;
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = new ClassLevelChangeEvent(id, pcc, oldLevel, newLevel);
                }
                listeners[i].levelChanged(ccEvent);
            }
        }

        public void fireClassLevelObjectChangeEvent(CharID id, PCClass pcc, PCClassLevel oldLevel, PCClassLevel newLevel) {
            if (oldLevel == newLevel) {
                return;
            }
            ClassLevelChangeListener[] listeners = (ClassLevelChangeListener[])this.listenerList.getListeners(ClassLevelChangeListener.class);
            ClassLevelObjectChangeEvent ccEvent = null;
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = new ClassLevelObjectChangeEvent(id, pcc, oldLevel, newLevel);
                }
                listeners[i].levelObjectChanged(ccEvent);
            }
        }
    }

    public static class ClassLevelObjectChangeEvent
    extends EventObject {
        private final CharID charID;
        private final PCClass pcClass;
        private final PCClassLevel oldLvl;
        private final PCClassLevel newLvl;

        public ClassLevelObjectChangeEvent(CharID source, PCClass pcc, PCClassLevel oldLevel, PCClassLevel newLevel) {
            super(source);
            if (source == null) {
                throw new IllegalArgumentException("CharID cannot be null");
            }
            if (pcc == null) {
                throw new IllegalArgumentException("PCClass cannot be null");
            }
            if (newLevel == null) {
                throw new IllegalArgumentException("New Level cannot be null");
            }
            this.charID = source;
            this.pcClass = pcc;
            this.oldLvl = oldLevel;
            this.newLvl = newLevel;
        }

        public CharID getCharID() {
            return this.charID;
        }

        public PCClass getPCClass() {
            return this.pcClass;
        }

        public PCClassLevel getOldLevel() {
            return this.oldLvl;
        }

        public PCClassLevel getNewLevel() {
            return this.newLvl;
        }
    }

    public static class ClassLevelChangeEvent
    extends EventObject {
        private final CharID charID;
        private final PCClass pcClass;
        private final int oldLvl;
        private final int newLvl;

        public ClassLevelChangeEvent(CharID source, PCClass pcc, int oldLevel, int newLevel) {
            super(source);
            if (source == null) {
                throw new IllegalArgumentException("CharID cannot be null");
            }
            if (pcc == null) {
                throw new IllegalArgumentException("PCClass cannot be null");
            }
            this.charID = source;
            this.pcClass = pcc;
            this.oldLvl = oldLevel;
            this.newLvl = newLevel;
        }

        public CharID getCharID() {
            return this.charID;
        }

        public PCClass getPCClass() {
            return this.pcClass;
        }

        public int getOldLevel() {
            return this.oldLvl;
        }

        public int getNewLevel() {
            return this.newLvl;
        }
    }

    public static interface ClassLevelChangeListener
    extends EventListener {
        public void levelChanged(ClassLevelChangeEvent var1);

        public void levelObjectChanged(ClassLevelObjectChangeEvent var1);
    }

    public static class ClassInfo {
        private Map<PCClass, Map<Integer, PCClassLevel>> map = new LinkedHashMap<PCClass, Map<Integer, PCClassLevel>>();
        private Map<PCClass, Integer> levelmap = new HashMap<PCClass, Integer>();

        public ClassInfo() {
        }

        public ClassInfo(ClassInfo info) {
            for (Map.Entry<PCClass, Map<Integer, PCClassLevel>> me : info.map.entrySet()) {
                this.map.put(me.getKey(), new HashMap<Integer, PCClassLevel>(me.getValue()));
            }
            this.levelmap.putAll(info.levelmap);
        }

        public Integer setLevel(PCClass pcc, int level) {
            if (pcc == null) {
                throw new IllegalArgumentException("Class for setLevel must not be null");
            }
            if (level < 0) {
                throw new IllegalArgumentException("Level for " + pcc.getDisplayName() + " must be > 0");
            }
            if (level != 0 && !this.map.containsKey(pcc)) {
                throw new IllegalArgumentException("Cannot set level for PCClass " + pcc.getKeyName() + " which is not added");
            }
            Integer oldlvl = this.levelmap.put(pcc, level);
            return oldlvl == null ? 0 : oldlvl;
        }

        public int getLevel(PCClass pcc) {
            Integer level = this.levelmap.get(pcc);
            return level == null ? 0 : level;
        }

        public void replace(PCClass oldClass, PCClass newClass) {
            Map<PCClass, Map<Integer, PCClassLevel>> oldMap = this.map;
            this.map = new LinkedHashMap<PCClass, Map<Integer, PCClassLevel>>();
            for (Map.Entry<PCClass, Map<Integer, PCClassLevel>> me : oldMap.entrySet()) {
                PCClass currentClass = me.getKey();
                if (oldClass.equals(currentClass)) {
                    this.addClass(newClass);
                    continue;
                }
                this.map.put(currentClass, me.getValue());
            }
        }

        public boolean addClass(PCClass pcc) {
            if (this.map.containsKey(pcc)) {
                return false;
            }
            HashMap levelMap = new HashMap();
            this.map.put(pcc, levelMap);
            return true;
        }

        public boolean setClassLevel(PCClass pcc, PCClassLevel pcl) throws CloneNotSupportedException {
            Map<Integer, PCClassLevel> localMap = this.map.get(pcc);
            if (localMap == null) {
                return false;
            }
            pcl.ownBonuses(pcc);
            pcl.put(ObjectKey.PARENT, pcc);
            localMap.put(pcl.get(IntegerKey.LEVEL), pcl);
            return true;
        }

        public PCClassLevel getClassLevel(PCClass pcc, int level) {
            if (pcc == null) {
                throw new IllegalArgumentException("Class in getClassLevel cannot be null");
            }
            if (level < 0) {
                throw new IllegalArgumentException("Level cannot be negative in getClassLevel");
            }
            Map<Integer, PCClassLevel> localMap = null;
            for (PCClass k : this.map.keySet()) {
                if (!pcc.equals(k)) continue;
                localMap = this.map.get(k);
                break;
            }
            if (localMap == null) {
                throw new IllegalArgumentException("Level cannot be returned for Class " + pcc.getKeyName() + " which is not in the PC");
            }
            PCClassLevel classLevel = (PCClassLevel)localMap.get(level);
            if (classLevel == null) {
                classLevel = pcc.getOriginalClassLevel(level);
                classLevel.put(ObjectKey.PARENT, pcc);
                localMap.put(level, classLevel);
            }
            return classLevel;
        }

        public boolean removeClass(PCClass pcc) {
            boolean returnValue = this.map.containsKey(pcc);
            this.map.remove(pcc);
            return returnValue;
        }

        public Set<PCClass> getClassSet() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public int classCount() {
            return this.map.size();
        }

        public boolean containsClass(PCClass pcc) {
            return this.map.containsKey(pcc);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassInfo) {
                ClassInfo other = (ClassInfo)o;
                return this.map.equals(other.map) && this.levelmap.equals(other.levelmap);
            }
            return false;
        }
    }
}

