/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.analysis.EquipmentChoiceDriver;
import pcgen.core.analysis.SizeUtilities;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class EquipmentList {
    private static boolean autoGeneration = false;

    private EquipmentList() {
    }

    private static boolean isAutoGeneration() {
        return autoGeneration;
    }

    public static void setAutoGeneration(boolean auto) {
        autoGeneration = auto;
    }

    public static Equipment getEquipmentFromName(String baseName, PlayerCharacter aPC) {
        Equipment eq;
        ArrayList<String> modList = new ArrayList<String>();
        ArrayList<String> namList = new ArrayList<String>();
        ArrayList<String> sizList = new ArrayList<String>();
        String aName = baseName;
        int i = aName.indexOf(40);
        if (i >= 0) {
            StringTokenizer aTok = new StringTokenizer(aName.substring(i + 1), "/)", false);
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                SizeAdjustment sa = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(SizeAdjustment.class, cString);
                if (sa != null) {
                    sizList.add(cString);
                    continue;
                }
                if ("Mighty Composite".equalsIgnoreCase(cString)) {
                    modList.add("Mighty");
                    modList.add("Composite");
                    continue;
                }
                modList.add(cString);
            }
            aName = aName.substring(0, i).trim();
        }
        if (i >= 0) {
            for (i = modList.size() - 1; i >= 0; --i) {
                String namePart = (String)modList.get(i);
                if (EquipmentList.getModifierNamed(namePart) != null) continue;
                namList.add(0, namePart);
                modList.remove(i);
            }
        }
        int[] bonuses = null;
        int bonusCount = 0;
        i = aName.indexOf(43);
        if (i >= 0) {
            StringTokenizer aTok = new StringTokenizer(aName.substring(i), "/", false);
            bonusCount = aTok.countTokens();
            bonuses = new int[bonusCount];
            int idx = 0;
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                bonuses[idx++] = Delta.decode(cString);
            }
            aName = aName.substring(0, i).trim();
            if (bonusCount > 0) {
                for (int idx1 = 0; idx1 < namList.size(); ++idx1) {
                    String aString = (String)namList.get(idx1);
                    if (!"Mighty".equalsIgnoreCase(aString)) continue;
                    aString = Delta.toString(bonuses[bonusCount - 1]) + " " + aString;
                    namList.set(idx1, aString);
                    --bonusCount;
                }
            }
        }
        String omitString = "";
        String bonusString = "";
        while (true) {
            String eqName;
            if ((eq = EquipmentList.findEquipment(eqName = aName + bonusString, null, namList, sizList, omitString)) != null) {
                if (sizList.size() <= 1) break;
                sizList.remove(0);
                break;
            }
            eq = EquipmentList.findEquipment(eqName, namList, null, sizList, omitString);
            if (eq != null) {
                if (sizList.size() <= 1) break;
                sizList.remove(0);
                break;
            }
            eq = EquipmentList.findEquipment(eqName, namList, null, null, omitString);
            if (eq != null) break;
            if (sizList.size() == 1) {
                eq = EquipmentList.findEquipment(eqName, sizList, namList, null, omitString);
                if (eq == null) {
                    eq = EquipmentList.findEquipment(eqName, namList, sizList, null, omitString);
                }
                if (eq != null) {
                    sizList.clear();
                    break;
                }
            }
            if (baseName.indexOf("Thrown") >= 0 && omitString.length() == 0) {
                omitString = "Thrown";
                continue;
            }
            if (bonusCount <= 0 || bonuses == null || bonusString.length() != 0) break;
            omitString = "";
            bonusString = " " + Delta.toString(bonuses[0]);
        }
        if (eq != null) {
            boolean bModified = false;
            boolean bError = false;
            eq = eq.clone();
            for (String namePart : modList) {
                EquipmentModifier eqMod = EquipmentList.getQualifiedModifierNamed(namePart, eq);
                if (eqMod != null) {
                    eq.addEqModifier(eqMod, true, aPC);
                    if (!eqMod.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue() || !eq.isDouble()) continue;
                    eq.addEqModifier(eqMod, false, aPC);
                    bModified = true;
                    continue;
                }
                Logging.errorPrint("Could not find a qualified modifier named: " + namePart + " for " + eq.getName() + ":" + eq.typeList());
                bError = true;
            }
            if (bError) {
                return null;
            }
            if (sizList.size() != 0) {
                eq.resizeItem(aPC, Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(SizeAdjustment.class, (String)sizList.get(0)));
                bModified = true;
                if (sizList.size() > 1) {
                    Logging.errorPrint("Too many sizes in item name, used only 1st of: " + sizList);
                }
            }
            if (bModified) {
                eq.nameItemFromModifiers(aPC);
                Equipment equip = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, eq.getKeyName());
                if (equip == null) {
                    Globals.getContext().getReferenceContext().importObject(eq);
                } else {
                    eq = equip;
                }
            }
        }
        return eq;
    }

    public static List<Equipment> getEquipmentOfType(String desiredTypes, String excludedTypes) {
        List<String> desiredTypeList = CoreUtility.split(desiredTypes, '.');
        List<String> excludedTypeList = CoreUtility.split(excludedTypes, '.');
        ArrayList<Equipment> typeList = new ArrayList<Equipment>(100);
        if (desiredTypeList.size() != 0) {
            for (Equipment eq : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
                boolean addIt = true;
                for (String type : desiredTypeList) {
                    if (eq.isType(type)) continue;
                    addIt = false;
                    break;
                }
                if (addIt && excludedTypeList.size() != 0) {
                    for (String type : excludedTypeList) {
                        if (!eq.isType(type)) continue;
                        addIt = false;
                        break;
                    }
                }
                if (!addIt) continue;
                typeList.add(eq);
            }
        }
        return typeList;
    }

    public static void autoGenerateEquipment() {
        EquipmentList.setAutoGeneration(true);
        EquipmentList.autogenerateRacialEquipment();
        EquipmentList.autogenerateMasterWorkEquipment();
        EquipmentList.autogenerateMagicEquipment();
        EquipmentList.autogenerateExoticMaterialsEquipment();
        EquipmentList.setAutoGeneration(false);
    }

    private static void autogenerateExoticMaterialsEquipment() {
        if (SettingsHandler.isAutogenExoticMaterial()) {
            for (Equipment eq : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
                if (eq.isMagic() || eq.isUnarmed() || eq.isMasterwork() || !eq.isAmmunition() && !eq.isArmor() && !eq.isShield() && !eq.isWeapon()) continue;
                EquipmentModifier eqDarkwood = EquipmentList.getQualifiedModifierNamed("Darkwood", eq);
                EquipmentModifier eqAdamantine = EquipmentList.getQualifiedModifierNamed("Adamantine", eq);
                EquipmentModifier eqMithral = EquipmentList.getQualifiedModifierNamed("Mithral", eq);
                EquipmentList.createItem(eq, eqDarkwood, null, null, null);
                EquipmentList.createItem(eq, eqAdamantine, null, null, null);
                EquipmentList.createItem(eq, eqMithral, null, null, null);
            }
        }
    }

    private static void autogenerateMagicEquipment() {
        if (SettingsHandler.isAutogenMagic()) {
            for (int iPlus = 1; iPlus <= 5; ++iPlus) {
                String aBonus = Delta.toString(iPlus);
                for (Equipment eq : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
                    if (eq.isMagic() || eq.isMasterwork() || !eq.isAmmunition() && !eq.isArmor() && !eq.isShield() && !eq.isWeapon()) continue;
                    EquipmentModifier eqMod = EquipmentList.getQualifiedModifierNamed("Masterwork", eq);
                    if (eqMod == null) {
                        Logging.debugPrint("Could not generate a Masterwork " + eq.toString() + " as the equipment modifier could not be found.");
                        continue;
                    }
                    EquipmentChoice equipChoice = EquipmentChoiceDriver.buildEquipmentChoice(0, eq, eqMod, false, false, 0, null);
                    EquipmentChoice.EquipChoiceIterator equipIter = equipChoice.getChoiceIterator(true);
                    while (equipIter.hasNext()) {
                        String mwChoice = String.valueOf(equipIter.next());
                        eq = eq.clone();
                        eq.addEqModifier(eqMod, true, null, mwChoice, equipChoice);
                        if (eq.isWeapon() && eq.isDouble()) {
                            eq.addEqModifier(eqMod, false, null, mwChoice, equipChoice);
                        }
                        if ((eqMod = EquipmentList.getQualifiedModifierNamed(aBonus, eq)) == null) {
                            Logging.debugPrint("Could not generate a " + aBonus + " " + eq.toString() + " as the equipment modifier could not be found.");
                            continue;
                        }
                        EquipmentList.createItem(eq, eqMod, null, null, null);
                    }
                }
            }
        }
    }

    private static void autogenerateMasterWorkEquipment() {
        if (SettingsHandler.isAutogenMasterwork()) {
            for (Equipment eq : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
                EquipmentModifier eqMasterwork;
                if (eq.isMagic() || eq.isUnarmed() || eq.isMasterwork() || !eq.isAmmunition() && !eq.isArmor() && !eq.isShield() && !eq.isWeapon() || (eqMasterwork = EquipmentList.getQualifiedModifierNamed("Masterwork", eq)) == null) continue;
                EquipmentChoice equipChoice = EquipmentChoiceDriver.buildEquipmentChoice(0, eq, eqMasterwork, false, false, 0, null);
                EquipmentChoice.EquipChoiceIterator equipIter = equipChoice.getChoiceIterator(true);
                while (equipIter.hasNext()) {
                    String choice = String.valueOf(equipIter.next());
                    EquipmentList.createItem(eq, eqMasterwork, null, choice, equipChoice);
                }
            }
        }
    }

    private static void autogenerateRacialEquipment() {
        if (SettingsHandler.isAutogenRacial()) {
            HashSet<Integer> gensizesid = new HashSet<Integer>();
            AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
            for (Race race : ref.getConstructedCDOMObjects(Race.class)) {
                int iSize = race.getSafe(FormulaKey.SIZE).resolveStatic().intValue();
                gensizesid.add(iSize);
            }
            SizeAdjustment defaultSize = SizeUtilities.getDefaultSizeAdjustment();
            HashSet<SizeAdjustment> gensizes = new HashSet<SizeAdjustment>();
            for (Integer i : gensizesid) {
                gensizes.add(ref.getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(i));
            }
            gensizes.remove(defaultSize);
            PlayerCharacter dummyPc = new PlayerCharacter();
            for (Equipment eq : ref.getConstructedCDOMObjects(Equipment.class)) {
                if (!Globals.canResizeHaveEffect(dummyPc, eq, null)) continue;
                for (SizeAdjustment sa : gensizes) {
                    EquipmentList.createItem(eq, sa, dummyPc);
                }
            }
        }
    }

    private static EquipmentModifier getModifierNamed(String aName) {
        for (EquipmentModifier eqMod : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(EquipmentModifier.class)) {
            if (!eqMod.getDisplayName().equals(aName)) continue;
            return eqMod;
        }
        return null;
    }

    private static EquipmentModifier getQualifiedModifierNamed(String aName, Equipment eq) {
        for (EquipmentModifier eqMod : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(EquipmentModifier.class)) {
            if (!eqMod.getDisplayName().startsWith(aName)) continue;
            for (String t : eq.typeList()) {
                if (!eqMod.isType(t) || !PrereqHandler.passesAll(eqMod.getPrerequisiteList(), eq, null)) continue;
                return eqMod;
            }
        }
        return null;
    }

    private static void appendNameParts(List<String> nameList, String omitString, StringBuilder newName) {
        for (String namePart : nameList) {
            if (omitString.length() != 0 && namePart.equals(omitString)) continue;
            if (newName.length() > 2) {
                newName.append('/');
            }
            newName.append(namePart);
        }
    }

    private static void createItem(Equipment eq, SizeAdjustment sa, PlayerCharacter aPC) {
        EquipmentList.createItem(eq, null, sa, aPC, "", null);
    }

    private static void createItem(Equipment eq, EquipmentModifier eqMod, PlayerCharacter aPC, String choice, EquipmentChoice equipChoice) {
        EquipmentList.createItem(eq, eqMod, null, aPC, choice, equipChoice);
    }

    private static void createItem(Equipment eq, EquipmentModifier eqMod, SizeAdjustment sa, PlayerCharacter aPC, String choice, EquipmentChoice equipChoice) {
        if (eq == null) {
            return;
        }
        try {
            if (!eq.getSafe(ObjectKey.MOD_CONTROL).getModifiersAllowed() || eq.isArmor() && eq.getACMod(aPC) == 0 && eqMod != null && !eqMod.getDisplayName().equalsIgnoreCase("MASTERWORK")) {
                return;
            }
            if ((eq = eq.clone()) == null) {
                Logging.errorPrint("could not clone item");
                return;
            }
            if (eqMod != null) {
                eq.addEqModifier(eqMod, true, aPC, choice, equipChoice);
                if (eq.isWeapon() && eq.isDouble()) {
                    eq.addEqModifier(eqMod, false, aPC, choice, equipChoice);
                }
            }
            if (sa != null) {
                eq.resizeItem(aPC, sa);
            }
            String sKeyName = eq.nameItemFromModifiers(aPC);
            Equipment eqExists = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, sKeyName);
            if (eqExists != null) {
                return;
            }
            Type newType = EquipmentList.isAutoGeneration() ? Type.AUTO_GEN : Type.CUSTOM;
            if (!eq.isType(newType.toString())) {
                eq.addType(newType);
            }
            Globals.getContext().getReferenceContext().importObject(eq);
        }
        catch (NumberFormatException exception) {
            Logging.errorPrint("createItem: exception: " + eq.getName());
        }
    }

    private static Equipment findEquipment(String aName, List<String> preNameList, List<String> postNameList, List<String> sizList, String omitString) {
        StringBuilder newName = new StringBuilder(80);
        newName.append(" (");
        if (preNameList != null) {
            List<String> nameList = preNameList;
            EquipmentList.appendNameParts(nameList, omitString, newName);
        }
        if (sizList != null && sizList.size() > 1) {
            newName.append(sizList.get(0));
        }
        if (postNameList != null) {
            EquipmentList.appendNameParts(postNameList, omitString, newName);
        }
        if (newName.length() == 2) {
            newName.setLength(0);
        } else {
            newName.append(')');
        }
        Equipment eq = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, aName + newName);
        return eq;
    }
}

