/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.Loadable;
import pcgen.system.LanguageBundle;

public final class PaperInfo
implements Loadable {
    private URI sourceURI;
    private String infoName;
    private String sortKey;
    private final String[] paperInfo = new String[7];
    public static final int NAME = 0;
    public static final int HEIGHT = 1;
    public static final int WIDTH = 2;
    public static final int TOPMARGIN = 3;
    public static final int BOTTOMMARGIN = 4;
    public static final int LEFTMARGIN = 5;
    public static final int RIGHTMARGIN = 6;

    public void setPaperInfo(int infoType, String info) {
        if (!PaperInfo.validIndex(infoType)) {
            throw new IndexOutOfBoundsException("invalid index: " + infoType);
        }
        this.paperInfo[infoType] = StringUtils.isNotBlank(info) && info.startsWith("in_") ? LanguageBundle.getString(info) : info;
    }

    String getName() {
        return this.getPaperInfo(0);
    }

    public String getPaperInfo(int infoType) {
        if (!PaperInfo.validIndex(infoType)) {
            return null;
        }
        return this.paperInfo[infoType];
    }

    private static boolean validIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    @Override
    public void setName(String name) {
        this.infoName = name;
        this.paperInfo[0] = name;
    }

    @Override
    public String getDisplayName() {
        return this.infoName;
    }

    @Override
    public String getKeyName() {
        return this.getDisplayName();
    }

    @Override
    public String getLSTformat() {
        return this.getDisplayName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }

    public void setSortKey(String value) {
        if (value == null) {
            throw new IllegalArgumentException("SortKey cannot be null");
        }
        this.sortKey = value;
    }

    public String getSortKey() {
        return this.sortKey;
    }
}

