/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui2.converter.ConversionDecider;
import pcgen.gui2.converter.LSTConverter;
import pcgen.gui2.converter.ObjectInjector;
import pcgen.gui2.converter.event.TaskStrategyMessage;
import pcgen.gui2.converter.panel.ConversionChoiceDialog;
import pcgen.gui2.converter.panel.ConversionInputDialog;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.gui2.tools.Utility;
import pcgen.io.PCGFile;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.EditorLoadContext;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenPropBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class RunConvertPanel
extends ConvertSubPanel
implements Observer,
ConversionDecider {
    int totalFileCount = 0;
    int currentFileCount = 0;
    private JProgressBar progressBar;
    private ArrayList<Campaign> totalCampaigns;
    private final EditorLoadContext context = new EditorLoadContext();
    private JTextArea messageArea;
    private JScrollPane messageAreaContainer;
    private boolean errorState = false;
    private String lastNotifiedFilename = "";
    private String currFilename = "";
    private Component statusField;
    private File changeLogFile;
    private LoadHandler handler = null;

    public RunConvertPanel(Component statusField) {
        this.statusField = statusField;
        PCGenSettings context = PCGenSettings.getInstance();
        String dataLogFileName = context.initProperty("pcgen.convert.dataLogFile", "dataChanges.log");
        this.changeLogFile = new File(dataLogFileName);
    }

    @Override
    public boolean autoAdvance(CDOMObject pc) {
        return false;
    }

    @Override
    public boolean performAnalysis(final CDOMObject pc) {
        this.logSummary(pc);
        final File rootDir = pc.get(ObjectKey.DIRECTORY);
        final File outDir = pc.get(ObjectKey.WRITE_DIRECTORY);
        this.totalCampaigns = new ArrayList<Campaign>(pc.getSafeListFor(ListKey.CAMPAIGN));
        for (Campaign campaign : pc.getSafeListFor(ListKey.CAMPAIGN)) {
            for (CampaignSourceEntry fName : campaign.getSafeListFor(ListKey.FILE_PCC)) {
                Campaign c;
                URI uri = fName.getURI();
                if (!PCGFile.isPCGenCampaignFile(uri) || (c = Globals.getCampaignByURI(uri, false)) == null) continue;
                this.totalCampaigns.add(c);
            }
        }
        this.sortCampaignsByRank(this.totalCampaigns);
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileWriter changeLogWriter;
                Logging.registerHandler(RunConvertPanel.this.getHandler());
                SettingsHandler.setGame(pc.get(ObjectKey.GAME_MODE).getName());
                GameMode mode = SettingsHandler.getGame();
                mode.resolveInto(RunConvertPanel.this.context.getReferenceContext());
                mode.resolveInto(mode.getContext().getReferenceContext());
                try {
                    changeLogWriter = new FileWriter(RunConvertPanel.this.changeLogFile);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    String startTime = simpleDateFormat.format(new Date());
                    ((Writer)changeLogWriter).append("PCGen Data Converter v" + PCGenPropBundle.getVersionNumber() + " - conversion started at " + startTime + "\n");
                    ((Writer)changeLogWriter).append("Outputting files to " + outDir.getAbsolutePath() + "\n");
                }
                catch (IOException e1) {
                    Logging.errorPrint("Failed to initialise LSTConverter", e1);
                    return;
                }
                LSTConverter converter = new LSTConverter(RunConvertPanel.this.context, rootDir, outDir.getAbsolutePath(), RunConvertPanel.this, changeLogWriter);
                converter.addObserver(RunConvertPanel.this);
                int numFiles = 0;
                for (Campaign campaign : RunConvertPanel.this.totalCampaigns) {
                    numFiles += converter.getNumFilesInCampaign(campaign);
                }
                RunConvertPanel.this.setTotalFileCount(numFiles);
                converter.initCampaigns(RunConvertPanel.this.totalCampaigns);
                for (Campaign campaign : RunConvertPanel.this.totalCampaigns) {
                    converter.processCampaign(campaign);
                }
                ObjectInjector oi = new ObjectInjector(RunConvertPanel.this.context, outDir, rootDir, converter);
                try {
                    oi.writeInjectedObjects(RunConvertPanel.this.totalCampaigns);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    ((Writer)changeLogWriter).close();
                }
                catch (IOException e) {
                    Logging.errorPrint("LSTConverter.wrapUp failed", e);
                }
                converter.deleteObserver(RunConvertPanel.this);
                Logging.removeHandler(RunConvertPanel.this.getHandler());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                RunConvertPanel.this.setCurrentFilename("");
                RunConvertPanel.this.addMessage("\nConversion complete.");
                if (RunConvertPanel.this.getHandler().getNumErrors() > 0) {
                    JOptionPane.showMessageDialog(null, LanguageBundle.getFormattedString("in_lstConvErrorsFound", RunConvertPanel.this.getHandler().getNumErrors()), LanguageBundle.getString("in_lstConvErrorsTitle"), 0);
                }
                RunConvertPanel.this.progressBar.setValue(RunConvertPanel.this.progressBar.getMaximum());
                RunConvertPanel.this.fireProgressEvent(2);
            }
        }).start();
        return true;
    }

    @Override
    public void setupDisplay(JPanel panel, CDOMObject pc) {
        panel.setLayout(new GridBagLayout());
        JLabel introLabel = new JLabel("Conversion in progress");
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0);
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)introLabel, gbc);
        JLabel explainLabel = new JLabel("<html>The LST data is being converted. In the log, LSTERROR rows are errors that need to be manually corrected in the source data. LSTWARN rows indicate changes the converter is making. See " + this.changeLogFile.getAbsolutePath() + " for a log of all data changes.</html>");
        explainLabel.setFocusable(true);
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0);
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 5, 10);
        panel.add((Component)explainLabel, gbc);
        this.progressBar = this.getProgressBar();
        Dimension d = this.progressBar.getPreferredSize();
        d.width = 400;
        this.progressBar.setPreferredSize(d);
        this.progressBar.setStringPainted(true);
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0);
        gbc.fill = 2;
        panel.add((Component)this.progressBar, gbc);
        this.messageAreaContainer = new JScrollPane(this.getMessageArea());
        Utility.buildRelativeConstraints(gbc, 0, 0, 1.0, 1.0);
        gbc.fill = 1;
        panel.add((Component)this.messageAreaContainer, gbc);
        panel.setPreferredSize(new Dimension(800, 500));
    }

    private LoadHandler getHandler() {
        if (this.handler == null) {
            this.handler = new LoadHandler();
        }
        return this.handler;
    }

    public void setCurrentFilename(String filename) {
        String message;
        Graphics g = this.statusField.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(message = filename == null || filename.length() == 0 ? "" : "Converting " + filename);
        if (width >= this.statusField.getWidth()) {
            message = Utility.shortenString(fm, message, this.statusField.getWidth());
        }
        TaskStrategyMessage.sendStatus(this, message);
        this.currFilename = filename;
    }

    public void addMessage(String message) {
        if (this.currFilename.length() > 0 && !this.currFilename.equals(this.lastNotifiedFilename)) {
            this.getMessageArea().append("\n" + this.currFilename + "\n");
            this.lastNotifiedFilename = this.currFilename;
        }
        this.getMessageArea().append(message + "\n");
    }

    public void setErrorState(boolean errorState) {
        this.errorState = errorState;
    }

    public boolean getErrorState() {
        return this.errorState;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    private JTextArea getMessageArea() {
        if (this.messageArea == null) {
            this.messageArea = new JTextArea();
            this.messageArea.setName("errorMessageBox");
            this.messageArea.setEditable(false);
            this.messageArea.setTabSize(8);
        }
        return this.messageArea;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof URI) {
            this.setCurrentFileCount(this.currentFileCount + 1);
            URI uri = (URI)arg;
            this.setCurrentFilename(uri.toString());
        } else if (arg instanceof Exception) {
            final Exception e = (Exception)arg;
            Runnable doWork = new Runnable(){

                @Override
                public void run() {
                    RunConvertPanel.this.addMessage(e.getMessage());
                    RunConvertPanel.this.setErrorState(true);
                }
            };
            SwingUtilities.invokeLater(doWork);
            System.out.println("Persistence Observer: ERROR: " + e.getMessage());
        } else {
            System.out.println("Persistence Observer: UNKNOWN: " + arg);
        }
    }

    protected void setTotalFileCount(final int iFileCount) {
        this.totalFileCount = iFileCount;
        Runnable doWork = new Runnable(){

            @Override
            public void run() {
                RunConvertPanel.this.getProgressBar().setMaximum(iFileCount);
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    public void setCurrentFileCount(int curr) {
        this.currentFileCount = curr;
        this.getProgressBar().setValue(curr);
    }

    @Override
    public String getConversionDecision(String overallDescription, List<String> choiceDescriptions, List<String> choiceTokenResults, int defaultChoice) {
        final ConversionChoiceDialog ccd = new ConversionChoiceDialog(null, overallDescription, choiceDescriptions, defaultChoice);
        int result = 0;
        Runnable showDialog = new Runnable(){

            @Override
            public void run() {
                ccd.setVisible(true);
            }
        };
        try {
            SwingUtilities.invokeAndWait(showDialog);
        }
        catch (InterruptedException e) {
            Logging.errorPrint("Failed to display user choice, due to: ", e);
        }
        catch (InvocationTargetException e) {
            Logging.errorPrint("Failed to display user choice, due to: ", e);
        }
        result = ccd.getResult();
        return choiceTokenResults.get(result);
    }

    @Override
    public String getConversionInput(String overallDescription) {
        final ConversionInputDialog ccd = new ConversionInputDialog(null, overallDescription);
        Runnable showDialog = new Runnable(){

            @Override
            public void run() {
                ccd.setVisible(true);
            }
        };
        try {
            SwingUtilities.invokeAndWait(showDialog);
        }
        catch (InterruptedException e) {
            Logging.errorPrint("Failed to display user choice, due to: ", e);
        }
        catch (InvocationTargetException e) {
            Logging.errorPrint("Failed to display user choice, due to: ", e);
        }
        return ccd.getResult();
    }

    private void sortCampaignsByRank(List<Campaign> aSelectedCampaignsList) {
        Collections.sort(aSelectedCampaignsList, new Comparator<Campaign>(){

            @Override
            public int compare(Campaign c1, Campaign c2) {
                return c1.getSafe(IntegerKey.CAMPAIGN_RANK) - c2.getSafe(IntegerKey.CAMPAIGN_RANK);
            }
        });
    }

    private void logSummary(CDOMObject pc) {
        Logging.log(Logging.INFO, "Running data conversion using the following settings:");
        Logging.log(Logging.INFO, "Source Folder: " + pc.get(ObjectKey.DIRECTORY).getAbsolutePath());
        Logging.log(Logging.INFO, "Destination Folder: " + pc.get(ObjectKey.WRITE_DIRECTORY).getAbsolutePath());
        Logging.log(Logging.INFO, "Game mode: " + pc.get(ObjectKey.GAME_MODE).getDisplayName());
        List<Campaign> campaigns = pc.getSafeListFor(ListKey.CAMPAIGN);
        StringBuilder campDisplay = new StringBuilder("");
        for (int i = 0; i < campaigns.size(); ++i) {
            campDisplay.append(campaigns.get(i).getDisplayName());
            campDisplay.append("\n");
        }
        Logging.log(Logging.INFO, "Sources: " + campDisplay.toString());
        Logging.log(Logging.INFO, "Logging changes to " + this.changeLogFile.getAbsolutePath());
    }

    private class LoadHandler
    extends Handler {
        int numErrors = 0;
        int numWarnings = 0;

        public LoadHandler() {
            this.setLevel(Logging.LST_WARNING);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(final LogRecord logRecord) {
            Runnable doWork = new Runnable(){

                @Override
                public void run() {
                    if (logRecord.getLevel().intValue() > Logging.WARNING.intValue()) {
                        ++LoadHandler.this.numErrors;
                    } else if (logRecord.getLevel().intValue() > Logging.INFO.intValue()) {
                        ++LoadHandler.this.numWarnings;
                    }
                    RunConvertPanel.this.addMessage(logRecord.getLevel() + " " + logRecord.getMessage());
                    RunConvertPanel.this.setErrorState(true);
                }
            };
            SwingUtilities.invokeLater(doWork);
        }

        public int getNumErrors() {
            return this.numErrors;
        }

        public int getNumWarnings() {
            return this.numWarnings;
        }
    }
}

