/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.messages.FileMenuSaveMessage;
import java.io.File;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.facade.core.CharacterFacade;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.facade.CharacterFacadeImpl;
import pcgen.io.PCGFile;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.pluginmgr.messages.PlayerCharacterWasLoadedMessage;
import pcgen.pluginmgr.messages.RequestFileOpenedMessageForCurrentlyOpenedPCsMessage;
import pcgen.pluginmgr.messages.RequestOpenPlayerCharacterMessage;
import pcgen.pluginmgr.messages.RequestToSavePlayerCharacterMessage;
import pcgen.pluginmgr.messages.TransmitInitiativeValuesBetweenComponentsMessage;
import pcgen.system.CharacterManager;

public class GMGenMessageHandler
implements PCGenMessageHandler {
    private final PCGenFrame delegate;
    private final PCGenMessageHandler messageHandler;

    public GMGenMessageHandler(PCGenFrame delegate, PCGenMessageHandler mh) {
        this.delegate = delegate;
        this.messageHandler = mh;
    }

    @Override
    public void handleMessage(PCGenMessage message) {
        if (message instanceof RequestOpenPlayerCharacterMessage) {
            this.handleOpenPCGRequestMessage((RequestOpenPlayerCharacterMessage)message);
        } else if (message instanceof FileMenuSaveMessage) {
            this.handleSaveMessage((FileMenuSaveMessage)message);
        } else if (message instanceof RequestFileOpenedMessageForCurrentlyOpenedPCsMessage) {
            this.handleFetchOpenPCGRequestMessage();
        } else if (message instanceof RequestToSavePlayerCharacterMessage) {
            this.handleSavePcgMessage(message);
        } else if (message instanceof TransmitInitiativeValuesBetweenComponentsMessage) {
            this.handleInitHolderListSendMessage((TransmitInitiativeValuesBetweenComponentsMessage)message);
        } else if (message instanceof FocusOrStateChangeOccurredMessage) {
            this.handleStateChangedMessage();
        }
    }

    private void handleSavePcgMessage(PCGenMessage message) {
        RequestToSavePlayerCharacterMessage smessage = (RequestToSavePlayerCharacterMessage)message;
        PlayerCharacter pc = smessage.getPc();
        for (CharacterFacade facade : CharacterManager.getCharacters()) {
            if (!facade.matchesCharacter(pc)) continue;
            CharacterManager.saveCharacter(facade);
            break;
        }
    }

    private void handleSaveMessage(FileMenuSaveMessage message) {
    }

    private void handleInitHolderListSendMessage(TransmitInitiativeValuesBetweenComponentsMessage message) {
        InitHolderList list = message.getInitHolderList();
        for (int i = 0; i < list.size(); ++i) {
            InitHolder iH = (InitHolder)list.get(i);
            if (!(iH instanceof PcgCombatant)) continue;
            PcgCombatant pcg = (PcgCombatant)iH;
            PlayerCharacter aPC = pcg.getPC();
            Globals.getPCList().add(aPC);
            aPC.setDirty(true);
        }
    }

    private void handleOpenPCGRequestMessage(RequestOpenPlayerCharacterMessage message) {
        File pcFile = message.getFile();
        if (PCGFile.isPCGenCharacterFile(pcFile)) {
            PlayerCharacter playerCharacter = CharacterManager.openPlayerCharacter(pcFile, this.delegate, this.delegate.getLoadedDataSetRef().getReference(), message.isBlockLoadedMessage());
            message.setPlayerCharacter(playerCharacter);
            message.consume();
        } else if (PCGFile.isPCGenPartyFile(pcFile)) {
            CharacterManager.openParty(pcFile, this.delegate, this.delegate.getLoadedDataSetRef().getReference());
        }
    }

    private void handleFetchOpenPCGRequestMessage() {
        for (int i = 0; i < CharacterManager.getCharacters().getSize(); ++i) {
            CharacterFacade facade = (CharacterFacade)CharacterManager.getCharacters().getElementAt(i);
            if (!(facade instanceof CharacterFacadeImpl)) continue;
            CharacterFacadeImpl cfi = (CharacterFacadeImpl)facade;
            this.messageHandler.handleMessage(new PlayerCharacterWasLoadedMessage(this, cfi.getTheCharacter()));
        }
    }

    private void handleStateChangedMessage() {
    }
}

