/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.text.Collator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.Skill;
import pcgen.core.spell.Spell;
import pcgen.facade.core.TempBonusFacade;
import pcgen.system.LanguageBundle;
import pcgen.util.SortKeyAware;

public class TempBonusFacadeImpl
implements TempBonusFacade,
Comparable<TempBonusFacadeImpl>,
SortKeyAware {
    private final CDOMObject originObj;
    private boolean active;
    private final Object target;
    private final String bonusName;

    TempBonusFacadeImpl(CDOMObject theOrigin) {
        this.originObj = theOrigin;
        this.active = true;
        this.target = null;
        this.bonusName = null;
    }

    TempBonusFacadeImpl(CDOMObject theOrigin, Object theTarget, String bonusName) {
        this.target = theTarget;
        this.bonusName = bonusName;
        this.originObj = theOrigin;
        this.active = true;
    }

    void setActive(boolean newActive) {
        this.active = newActive;
    }

    @Override
    public String getSource() {
        return SourceFormat.getFormattedString(this.getOriginObj(), Globals.getSourceDisplay(), true);
    }

    @Override
    public String getSourceForNodeDisplay() {
        return SourceFormat.getFormattedString(this.getOriginObj(), SourceFormat.LONG, false);
    }

    @Override
    public String getKeyName() {
        return this.getOriginObj().getKeyName();
    }

    @Override
    public boolean isNamePI() {
        return this.getOriginObj().getSafe(ObjectKey.NAME_PI);
    }

    @Override
    public String getOriginType() {
        if (this.getOriginObj() instanceof Ability) {
            return LanguageBundle.getString("in_Ability");
        }
        if (this.getOriginObj() instanceof Equipment) {
            return LanguageBundle.getString("in_igEqModelColItem");
        }
        if (this.getOriginObj() instanceof Spell) {
            return LanguageBundle.getString("in_Spell");
        }
        if (this.getOriginObj() instanceof PCClass || this.getOriginObj() instanceof PCClassLevel) {
            return LanguageBundle.getString("in_classString");
        }
        if (this.getOriginObj() instanceof PCTemplate) {
            return LanguageBundle.getString("in_condition");
        }
        if (this.getOriginObj() instanceof Skill) {
            return LanguageBundle.getString("in_iskSkill");
        }
        return LanguageBundle.getString("in_itmRemBonButUnkownBonusType");
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public int compareTo(TempBonusFacadeImpl o) {
        String key2;
        Collator collator = Collator.getInstance();
        String key1 = this.getOriginObj().get(StringKey.SORT_KEY);
        if (key1 == null) {
            key1 = this.getOriginObj().getDisplayName();
        }
        if ((key2 = o.getOriginObj().get(StringKey.SORT_KEY)) == null) {
            key2 = o.getOriginObj().getDisplayName();
        }
        if (!key1.equals(key2)) {
            return collator.compare(key1, key2);
        }
        return collator.compare(this.getOriginObj().getDisplayName(), o.getOriginObj().getDisplayName());
    }

    @Override
    public String toString() {
        if (StringUtils.isNotEmpty(this.bonusName)) {
            return this.bonusName;
        }
        return this.getOriginObj().toString();
    }

    public CDOMObject getOriginObj() {
        return this.originObj;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originObj == null ? 0 : this.originObj.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TempBonusFacadeImpl other = (TempBonusFacadeImpl)obj;
        if (this.originObj == null ? other.originObj != null : !this.originObj.equals(other.originObj)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public String getType() {
        List<Type> types = this.originObj.getSafeListFor(ListKey.TYPE);
        return StringUtil.join(types, (String)".");
    }

    @Override
    public String getSortKey() {
        String sortKey = this.getOriginObj().get(StringKey.SORT_KEY);
        if (sortKey == null) {
            sortKey = this.getOriginObj().getDisplayName();
        }
        return sortKey;
    }
}

