/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import pcgen.gui2.util.SimpleTextIcon;

public class MultiLineTextIcon
implements Icon {
    private final List<Icon> icons;
    private int width;
    private int height;

    public MultiLineTextIcon(Component c, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        this.icons = new ArrayList<Icon>(tokenizer.countTokens());
        this.width = 0;
        this.height = 0;
        while (tokenizer.hasMoreTokens()) {
            SimpleTextIcon icon = new SimpleTextIcon(c, tokenizer.nextToken());
            this.width = Math.max(this.width, icon.getIconWidth());
            this.height += icon.getIconHeight();
            this.icons.add(icon);
        }
    }

    public MultiLineTextIcon(Component c, List<?> lines) {
        this.icons = new ArrayList<Icon>(lines.size());
        this.width = 0;
        this.height = 0;
        for (Object line : lines) {
            SimpleTextIcon icon = new SimpleTextIcon(c, line.toString());
            this.width = Math.max(this.width, icon.getIconWidth());
            this.height += icon.getIconHeight();
            this.icons.add(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (Icon icon : this.icons) {
            icon.paintIcon(c, g, x, y);
            y += icon.getIconHeight();
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

