/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class TokenUtilities {
    private TokenUtilities() {
    }

    public static <T extends Loadable> CDOMReference<T> getTypeOrPrimitive(LoadContext context, Class<T> cl, String s) {
        return TokenUtilities.getTypeOrPrimitive(context.getReferenceContext().getManufacturer(cl), s);
    }

    public static <T extends CDOMObject> CDOMGroupRef<T> getTypeReference(LoadContext context, Class<T> cl, String subStr) {
        return TokenUtilities.getTypeReference(context.getReferenceContext().getManufacturer(cl), subStr);
    }

    public static <T extends Loadable> CDOMReference<T> getTypeOrPrimitive(ReferenceManufacturer<T> rm, String s) {
        if (s.startsWith("TYPE.") || s.startsWith("TYPE=")) {
            return TokenUtilities.getTypeReference(rm, s.substring(5));
        }
        if (s.startsWith("!TYPE.") || s.startsWith("!TYPE=")) {
            Logging.errorPrint("!TYPE not supported in token, found: " + s);
            return null;
        }
        return rm.getReference(s);
    }

    public static <T extends Loadable> CDOMGroupRef<T> getTypeReference(SelectionCreator<T> rm, String s) {
        String[] types;
        if (s.length() == 0) {
            Logging.errorPrint("Type may not be empty in: " + s);
            return null;
        }
        if (s.charAt(0) == '.' || s.charAt(s.length() - 1) == '.') {
            Logging.errorPrint("Type may not start or end with . in: " + s);
            return null;
        }
        for (String type : types = s.split("\\.")) {
            if (type.length() != 0) continue;
            Logging.errorPrint("Attempt to acquire empty Type in: " + s);
            return null;
        }
        return rm.getTypeReference(types);
    }

    public static <T extends CDOMObject> CDOMReference<T> getReference(LoadContext context, Class<T> cl, String tokText) {
        CDOMReference lang = "ALL".equals(tokText) ? context.getReferenceContext().getCDOMAllReference(cl) : TokenUtilities.getTypeOrPrimitive(context, cl, tokText);
        return lang;
    }
}

