/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens.deprecated;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.Domain;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.DescriptionFormatting;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class DomainToken
extends Token {
    public static final String TOKENNAME = "DOMAIN";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            int domainIndex = 0;
            try {
                domainIndex = Math.max(0, Integer.parseInt(aTok.nextToken()) - 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (aTok.hasMoreTokens()) {
                String subToken = aTok.nextToken();
                if ("POWER".equals(subToken)) {
                    retString = DomainToken.getPowerToken(pc, domainIndex);
                }
            } else {
                retString = this.getDomainToken(pc.getDisplay(), domainIndex);
            }
        }
        return retString;
    }

    public String getDomainToken(CharacterDisplay display, int domainIndex) {
        try {
            Domain domain = new ArrayList<Domain>(display.getSortedDomainSet()).get(domainIndex);
            return OutputNameFormatting.getOutputName(domain);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPowerToken(PlayerCharacter pc, int domainIndex) {
        try {
            Domain domain = new ArrayList<Domain>(pc.getDisplay().getSortedDomainSet()).get(domainIndex);
            return DescriptionFormatting.piWrapDesc(domain, pc.getDescription(domain), true);
        }
        catch (Exception e) {
            return "";
        }
    }
}

