/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import gmgen.plugin.PcgCombatant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatter;
import pcgen.core.RollingMethods;
import plugin.initiative.AttackModel;
import plugin.initiative.gui.AutoSizingColumnModel;

public class AttackDialog
extends JDialog {
    private List<Integer> m_damageList = null;
    private List m_targetList = null;
    private AttackModel m_attack = null;
    private AttackTableModel m_tableModel = null;
    private JComboBox m_acTypeCombo;
    private JComboBox m_targets = null;
    private JComboBox m_targetsCombo;
    private JFormattedTextField m_field;
    private JLabel m_totalDamageLabel;
    private JTable m_table = null;
    private Vector m_combatants = null;
    private boolean m_subdual;
    private int m_totalDmg;

    public AttackDialog(AttackModel model) {
        super(GMGenSystem.inst);
        this.m_attack = model;
        this.initComponents();
    }

    public AttackDialog(AttackModel model, Vector combatants) {
        super(GMGenSystem.inst);
        this.m_attack = model;
        if (combatants != null) {
            this.m_combatants = (Vector)combatants.clone();
        }
        this.initComponents();
    }

    public List<Integer> getDamageList() {
        return this.m_damageList;
    }

    public List getDamagedCombatants() {
        return this.m_targetList;
    }

    public boolean isSubdual() {
        return this.m_subdual;
    }

    public int getTotalDmg() {
        return this.m_totalDmg;
    }

    protected void handleAcTypeAction(ActionEvent e) {
        this.m_field.setValue(((PcgCombatant)this.m_targetsCombo.getSelectedItem()).getPC().getDisplay().calcACOfType(this.m_acTypeCombo.getSelectedItem().toString()));
        this.m_tableModel.setAcType(this.m_acTypeCombo.getSelectedItem().toString());
    }

    protected void handleCancel() {
        this.m_damageList = null;
        this.m_targetList = null;
        this.setVisible(false);
    }

    protected void handleOk() {
        this.m_damageList = new ArrayList<Integer>(this.m_tableModel.getRowCount());
        this.m_targetList = new ArrayList(this.m_tableModel.getRowCount());
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            int dmg = this.m_tableModel.getIntAt(i, this.m_tableModel.columnFromKey("DMGTOT"));
            if (dmg <= 0) continue;
            this.m_damageList.add(dmg);
            Object target = this.m_tableModel.getValueAt(i, this.m_tableModel.columnFromKey("TARGET"));
            if (target == null || !(target instanceof PcgCombatant)) continue;
            this.m_targetList.add(target);
        }
        this.setVisible(false);
    }

    protected void handleSubdualAction(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.m_subdual = ((JCheckBox)e.getSource()).isSelected();
        }
    }

    protected void handleTableUpdate(TableModelEvent e) {
        int dmgColumn = this.m_tableModel.columnFromKey("DMGTOT");
        if (dmgColumn == e.getColumn() || e.getColumn() == -1 || e.getType() == -1 || e.getType() == 1) {
            this.m_totalDmg = 0;
            for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                this.m_totalDmg += this.m_tableModel.getIntAt(i, dmgColumn);
            }
            this.m_totalDamageLabel.setText("<html>Total Damage: <b>" + this.m_totalDmg + "</b></html>");
        }
    }

    protected void handleTargetAction(ActionEvent e) {
        if (this.m_targetsCombo != null && this.m_targetsCombo.getSelectedItem() != null && this.m_targetsCombo.getSelectedItem() instanceof PcgCombatant) {
            PcgCombatant combatant = (PcgCombatant)this.m_targetsCombo.getSelectedItem();
            this.m_field.setValue(combatant.getPC().getDisplay().calcACOfType(this.m_acTypeCombo.getSelectedItem().toString()));
            this.m_tableModel.setTarget(combatant);
        }
    }

    protected void performRoll() {
        this.m_tableModel.rollAttacks();
    }

    private void initComponents() {
        this.setTitle("Attack: " + this.m_attack.toString());
        this.getContentPane().setLayout(new BorderLayout());
        this.m_attack.getBonusList();
        JPanel center = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        AutoSizingColumnModel columns = new AutoSizingColumnModel();
        this.m_tableModel = new AttackTableModel();
        this.m_tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AttackDialog.this.handleTableUpdate(e);
            }
        });
        this.m_table = new JTable(this.m_tableModel, columns);
        columns.referenceTable(this.m_table);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setAutoCreateColumnsFromModel(true);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(columns.getTotalPreferredWidth(), this.m_table.getRowHeight() * this.m_table.getRowCount()));
        center.add((Component)new JScrollPane(this.m_table), "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        this.m_totalDamageLabel = new JLabel("<html>Total Damage: <b>0</b></html>");
        bottom.add(this.m_totalDamageLabel);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        JCheckBox checkbox = new JCheckBox("Damage is subdual?");
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttackDialog.this.handleSubdualAction(e);
            }
        });
        bottom.add(checkbox);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton button = null;
        button = new JButton(new AbstractAction("Roll"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttackDialog.this.performRoll();
            }
        });
        bottom.add(button);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        button = new JButton(new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttackDialog.this.handleOk();
            }
        });
        bottom.add(button);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        button = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttackDialog.this.handleCancel();
            }
        });
        bottom.add(button);
        this.getContentPane().add((Component)bottom, "South");
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        if (this.m_combatants != null && this.m_combatants.size() > 0) {
            this.m_targets = new JComboBox(this.m_combatants);
            this.m_table.setDefaultEditor(PcgCombatant.class, new DefaultCellEditor(this.m_targets));
            this.m_targetsCombo = new JComboBox(this.m_combatants);
            this.m_targetsCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttackDialog.this.handleTargetAction(e);
                }
            });
            top.add(new JLabel("Attack Character: "));
            top.add(this.m_targetsCombo);
            this.m_acTypeCombo = new JComboBox();
            this.m_acTypeCombo.addItem("Total");
            this.m_acTypeCombo.addItem("Flatfooted");
            this.m_acTypeCombo.addItem("Touch");
            this.m_acTypeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttackDialog.this.handleAcTypeAction(e);
                }
            });
            top.add(new JLabel("Use AC Type: "));
            top.add(this.m_acTypeCombo);
        }
        DefaultFormatter formatter = new DefaultFormatter();
        formatter.setValueClass(Integer.class);
        formatter.setCommitsOnValidEdit(true);
        this.m_field = new JFormattedTextField(formatter);
        this.m_field.setFocusLostBehavior(1);
        this.m_field.setPreferredSize(new Dimension(40, this.m_field.getPreferredSize().height));
        this.m_field.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != null && evt.getPropertyName().equals("value")) {
                    AttackDialog.this.m_tableModel.setArmorClass((Integer)AttackDialog.this.m_field.getValue());
                }
            }
        });
        top.add(new JLabel("AC"));
        top.add(this.m_field);
        this.m_field.setValue(15);
        this.handleTargetAction(null);
        this.getContentPane().add((Component)top, "North");
        this.pack();
        this.setLocationRelativeTo(GMGenSystem.inst);
    }

    public class AttackTableModel
    extends DefaultTableModel {
        static final String COLUMN_KEY_BONUS = "BONUS";
        static final String COLUMN_KEY_FUDGE = "FUDGE";
        static final String COLUMN_KEY_INCREMENT = "INCREMENT";
        static final String COLUMN_KEY_RANGE = "RANGE";
        static final String COLUMN_KEY_ROLL = "ROLL";
        static final String COLUMN_KEY_TOTAL = "TOTAL";
        static final String COLUMN_KEY_CRITROLL = "CRITROLL";
        static final String COLUMN_KEY_CRITTOTAL = "CRITTOTAL";
        static final String COLUMN_KEY_HIT = "HIT";
        static final String COLUMN_KEY_CRIT = "CRIT";
        static final String COLUMN_KEY_DMG = "DMG";
        static final String COLUMN_KEY_DMGTOT = "DMGTOT";
        static final String COLUMN_KEY_TARGET = "TARGET";
        static final String COLUMN_KEY_AC = "ARMORCLASS";
        static final int COLUMN_INDEX_NAME = 0;
        static final int COLUMN_INDEX_CLASS = 1;
        static final int COLUMN_INDEX_DEFAULT = 2;
        static final int COLUMN_INDEX_EDITABLE = 3;
        static final int COLUMN_INDEX_KEY = 4;
        private String m_acType = "Total";
        private Object[][] columns = new Object[][]{{"Bonus", Integer.class, null, Boolean.FALSE, "BONUS"}, {"Fudge", Integer.class, 0, Boolean.TRUE, "FUDGE"}, {"Increment", Integer.class, AttackDialog.access$400(AttackDialog.this).getRangeAsInt(), Boolean.FALSE, "INCREMENT"}, {"Range", Integer.class, null, Boolean.TRUE, "RANGE"}, {"Roll", Integer.class, null, Boolean.FALSE, "ROLL"}, {"Total", Integer.class, null, Boolean.FALSE, "TOTAL"}, {"Target", PcgCombatant.class, null, Boolean.TRUE, "TARGET"}, {"AC", Integer.class, null, Boolean.TRUE, "ARMORCLASS"}, {"Crit Roll", Integer.class, null, Boolean.FALSE, "CRITROLL"}, {"Crit Total", Integer.class, null, Boolean.FALSE, "CRITTOTAL"}, {"Hit", Boolean.class, Boolean.FALSE, Boolean.TRUE, "HIT"}, {"Crit", Boolean.class, Boolean.FALSE, Boolean.TRUE, "CRIT"}, {"Dmg", String.class, null, Boolean.TRUE, "DMG"}, {"Dmg Tot", Integer.class, null, Boolean.TRUE, "DMGTOT"}};

        public AttackTableModel() {
            int i;
            int[] attacks = AttackDialog.this.m_attack.getBonusList();
            Vector<Object> values = new Vector<Object>(this.columns.length);
            values.setSize(values.capacity());
            for (i = 0; i < this.columns.length; ++i) {
                this.addColumn(this.columns[i][0]);
                values.add(i, this.columns[i][2]);
            }
            for (i = 0; i < attacks.length; ++i) {
                values.set(this.columnFromKey(COLUMN_KEY_BONUS), attacks[i]);
                values.set(this.columnFromKey(COLUMN_KEY_DMG), AttackDialog.this.m_attack.getDamage(i));
                this.addRow((Vector)values.clone());
            }
        }

        public void setAcType(String string) {
            this.m_acType = string;
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.recalcRow(row, this.columnFromKey(COLUMN_KEY_TARGET));
            }
        }

        public void setArmorClass(int ac) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(ac, i, this.columnFromKey(COLUMN_KEY_AC));
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return (Boolean)this.columns[column][3];
        }

        public Class getColumnClass(int columnIndex) {
            return (Class)this.columns[columnIndex][1];
        }

        public void setTarget(PcgCombatant target) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(target, i, this.columnFromKey(COLUMN_KEY_TARGET));
            }
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            super.setValueAt(aValue, row, column);
            this.recalcRow(row, column);
        }

        public void rollAttacks() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.rollAttack(i);
            }
        }

        private int getIntAt(int row, int column) {
            int returnValue = 0;
            if (this.getValueAt(row, column) != null && this.getValueAt(row, column) instanceof Integer) {
                returnValue = (Integer)this.getValueAt(row, column);
            }
            return returnValue;
        }

        private int columnFromKey(String key) {
            int returnValue = -1;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i][4].equals(key)) continue;
                returnValue = i;
                break;
            }
            return returnValue;
        }

        private void recalcRow(int row, int column) {
            int result;
            int attTotal = 0;
            int attackModifier = this.getIntAt(row, this.columnFromKey(COLUMN_KEY_BONUS)) + this.getIntAt(row, this.columnFromKey(COLUMN_KEY_FUDGE));
            if (this.getIntAt(row, this.columnFromKey(COLUMN_KEY_INCREMENT)) > 0 && this.getIntAt(row, this.columnFromKey(COLUMN_KEY_RANGE)) > 0) {
                attackModifier += (int)Math.floor((double)this.getIntAt(row, this.columnFromKey(COLUMN_KEY_RANGE)) / (double)this.getIntAt(row, this.columnFromKey(COLUMN_KEY_INCREMENT))) * -2;
            }
            attTotal = (result = this.getIntAt(row, this.columnFromKey(COLUMN_KEY_ROLL))) == 1 || result == 0 ? result : result + attackModifier;
            if (column == this.columnFromKey(COLUMN_KEY_BONUS) || column == this.columnFromKey(COLUMN_KEY_FUDGE) || column == this.columnFromKey(COLUMN_KEY_INCREMENT) || column == this.columnFromKey(COLUMN_KEY_RANGE) || column == this.columnFromKey(COLUMN_KEY_ROLL)) {
                this.setValueAt(attTotal, row, this.columnFromKey(COLUMN_KEY_TOTAL));
            }
            if (column == this.columnFromKey(COLUMN_KEY_TARGET) && this.getValueAt(row, this.columnFromKey(COLUMN_KEY_TARGET)) instanceof PcgCombatant) {
                this.setValueAt(((PcgCombatant)this.getValueAt(row, this.columnFromKey(COLUMN_KEY_TARGET))).getPC().getDisplay().calcACOfType(this.m_acType), row, this.columnFromKey(COLUMN_KEY_AC));
            }
            if (column == this.columnFromKey(COLUMN_KEY_TOTAL) || column == this.columnFromKey(COLUMN_KEY_AC)) {
                if (attTotal >= this.getIntAt(row, this.columnFromKey(COLUMN_KEY_AC)) || this.getIntAt(row, this.columnFromKey(COLUMN_KEY_ROLL)) >= 20) {
                    this.setValueAt(Boolean.TRUE, row, this.columnFromKey(COLUMN_KEY_HIT));
                } else {
                    this.setValueAt(Boolean.FALSE, row, this.columnFromKey(COLUMN_KEY_HIT));
                }
            }
            if (column == this.columnFromKey(COLUMN_KEY_CRITROLL) || column == this.columnFromKey(COLUMN_KEY_AC)) {
                int critTotal = 0;
                if (this.getIntAt(row, this.columnFromKey(COLUMN_KEY_CRITROLL)) > 1) {
                    critTotal = this.getIntAt(row, this.columnFromKey(COLUMN_KEY_CRITROLL)) + attackModifier;
                    this.setValueAt(critTotal, row, this.columnFromKey(COLUMN_KEY_CRITTOTAL));
                } else {
                    this.setValueAt(null, row, this.columnFromKey(COLUMN_KEY_CRITTOTAL));
                }
                if (critTotal > this.getIntAt(row, this.columnFromKey(COLUMN_KEY_AC)) || this.getIntAt(row, this.columnFromKey(COLUMN_KEY_CRITROLL)) >= 20) {
                    this.setValueAt(Boolean.TRUE, row, this.columnFromKey(COLUMN_KEY_CRIT));
                } else {
                    this.setValueAt(Boolean.FALSE, row, this.columnFromKey(COLUMN_KEY_CRIT));
                }
            }
            if (column == this.columnFromKey(COLUMN_KEY_HIT) || column == this.columnFromKey(COLUMN_KEY_CRIT)) {
                if (((Boolean)this.getValueAt(row, this.columnFromKey(COLUMN_KEY_HIT))).booleanValue()) {
                    int numberOfRolls = 1;
                    String damageString = (String)this.getValueAt(row, this.columnFromKey(COLUMN_KEY_DMG));
                    if (damageString.indexOf("/") >= 0) {
                        StringTokenizer tok = new StringTokenizer(damageString, "/");
                        Object[] heads = new String[tok.countTokens()];
                        int i = 0;
                        while (tok.hasMoreTokens()) {
                            heads[i] = tok.nextToken();
                            ++i;
                        }
                        damageString = (String)JOptionPane.showInputDialog(AttackDialog.this, "This weapon appears to have more than one possible damage die listed.  Please choose one:", "Multiple Damage Dice", 3, null, heads, heads[1]);
                        this.setValueAt(damageString, row, this.columnFromKey(COLUMN_KEY_DMG));
                    }
                    if (((Boolean)this.getValueAt(row, this.columnFromKey(COLUMN_KEY_CRIT))).booleanValue()) {
                        numberOfRolls = Integer.parseInt(AttackDialog.this.m_attack.getCritMultiple(row));
                    }
                    int dmg = 0;
                    for (int i = 0; i < numberOfRolls; ++i) {
                        dmg += RollingMethods.roll(damageString);
                    }
                    this.setValueAt(dmg, row, this.columnFromKey(COLUMN_KEY_DMGTOT));
                } else {
                    this.setValueAt(null, row, this.columnFromKey(COLUMN_KEY_DMGTOT));
                }
            }
        }

        private void rollAttack(int row) {
            this.setValueAt(RollingMethods.roll("1d20"), row, this.columnFromKey(COLUMN_KEY_ROLL));
            if (this.getIntAt(row, this.columnFromKey(COLUMN_KEY_ROLL)) >= AttackDialog.this.m_attack.getCritRangeMin(row) && ((Boolean)this.getValueAt(row, this.columnFromKey(COLUMN_KEY_HIT))).booleanValue()) {
                this.setValueAt(RollingMethods.roll("1d20"), row, this.columnFromKey(COLUMN_KEY_CRITROLL));
            } else {
                this.setValueAt(null, row, this.columnFromKey(COLUMN_KEY_CRITROLL));
            }
        }
    }
}

