/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;
import pcgen.util.Logging;

public class NaturalattacksLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
PostDeferredToken<CDOMObject> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    @Override
    public String getTokenName() {
        return "NATURALATTACKS";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        int count = 1;
        StringTokenizer attackTok = new StringTokenizer(value, "|");
        while (attackTok.hasMoreTokens()) {
            String tokString = attackTok.nextToken();
            ParseResult pr = this.checkForIllegalSeparator(',', tokString);
            if (!pr.passed()) {
                return pr;
            }
            Equipment anEquip = this.createNaturalWeapon(context, obj, tokString.intern());
            if (anEquip == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            if (count == 1) {
                anEquip.setModifiedName("Natural/Primary");
            } else {
                anEquip.setModifiedName("Natural/Secondary");
            }
            anEquip.setOutputIndex(0);
            anEquip.setOutputSubindex(count);
            anEquip.setQty(new Float(1.0f));
            anEquip.setNumberCarried(new Float(1.0f));
            context.getObjectContext().addToList(obj, ListKey.NATURAL_WEAPON, anEquip);
            ++count;
        }
        return ParseResult.SUCCESS;
    }

    private Equipment createNaturalWeapon(LoadContext context, CDOMObject obj, String wpn) {
        boolean attacksFixed;
        StringTokenizer commaTok = new StringTokenizer(wpn, ",");
        int numTokens = commaTok.countTokens();
        if (numTokens < 4) {
            Logging.errorPrint("Invalid Build of Natural Weapon in " + this.getTokenName() + ": " + wpn);
            return null;
        }
        String attackName = commaTok.nextToken();
        if (attackName.equalsIgnoreCase("NONE")) {
            Logging.errorPrint("Attempt to Build 'None' as a Natural Weapon in " + this.getTokenName() + ": " + wpn);
            return null;
        }
        attackName = attackName.intern();
        Equipment anEquip = new Equipment();
        anEquip.setName(attackName);
        anEquip.put(ObjectKey.PARENT, obj);
        EquipmentHead equipHead = anEquip.getEquipmentHead(1);
        String profType = commaTok.nextToken();
        if (this.hasIllegalSeparator('.', profType)) {
            return null;
        }
        StringTokenizer dotTok = new StringTokenizer(profType, ".");
        while (dotTok.hasMoreTokens()) {
            Type type = Type.getConstant(dotTok.nextToken());
            anEquip.addToListFor(ListKey.TYPE, type);
        }
        String numAttacks = commaTok.nextToken();
        boolean bl = attacksFixed = numAttacks.length() > 0 && numAttacks.charAt(0) == '*';
        if (attacksFixed) {
            numAttacks = numAttacks.substring(1);
        }
        anEquip.put(ObjectKey.ATTACKS_PROGRESS, !attacksFixed);
        try {
            int bonusAttacks = Integer.parseInt(numAttacks) - 1;
            BonusObj aBonus = Bonus.newBonus(context, "WEAPON|ATTACKS|" + bonusAttacks);
            if (aBonus == null) {
                Logging.errorPrint(this.getTokenName() + " was given invalid number of attacks: " + bonusAttacks);
                return null;
            }
            anEquip.addToListFor(ListKey.BONUS, aBonus);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Non-numeric value for number of attacks in " + this.getTokenName() + ": '" + numAttacks + "'");
            return null;
        }
        equipHead.put(StringKey.DAMAGE, commaTok.nextToken());
        int handsrequired = 0;
        while (commaTok.hasMoreTokens()) {
            String hString = commaTok.nextToken();
            if (hString.startsWith("SPROP=")) {
                anEquip.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(hString.substring(6)));
                continue;
            }
            try {
                handsrequired = Integer.parseInt(hString);
            }
            catch (NumberFormatException exc) {
                Logging.errorPrint("Non-numeric value for hands required: '" + hString + "'");
                return null;
            }
        }
        anEquip.put(IntegerKey.SLOTS, handsrequired);
        anEquip.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
        WeaponProf cwp = context.getReferenceContext().silentlyGetConstructedCDOMObject(WEAPONPROF_CLASS, attackName);
        if (cwp == null) {
            cwp = context.getReferenceContext().constructNowIfNecessary(WEAPONPROF_CLASS, attackName);
            cwp.addToListFor(ListKey.TYPE, Type.NATURAL);
        }
        CDOMSingleRef<WeaponProf> wp = context.getReferenceContext().getCDOMReference(WEAPONPROF_CLASS, attackName);
        anEquip.put(ObjectKey.WEAPON_PROF, wp);
        anEquip.addToListFor(ListKey.IMPLIED_WEAPONPROF, wp);
        equipHead.put(IntegerKey.CRIT_RANGE, 1);
        equipHead.put(IntegerKey.CRIT_MULT, 2);
        return anEquip;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<Equipment> changes = context.getObjectContext().getListChanges(obj, ListKey.NATURAL_WEAPON);
        Collection<Equipment> eqadded = changes.getAdded();
        if (eqadded == null || eqadded.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Equipment lstw : eqadded) {
            List<BonusObj> bonuses;
            Equipment eq;
            String name;
            if (!first) {
                sb.append("|");
            }
            if ((name = (eq = (Equipment)Equipment.class.cast(lstw)).getDisplayName()) == null) {
                context.addWriteMessage(this.getTokenName() + " expected Equipment to have a name");
                return null;
            }
            sb.append(name).append(",");
            List<Type> type = eq.getListFor(ListKey.TYPE);
            if (type == null || type.isEmpty()) {
                context.addWriteMessage(this.getTokenName() + " expected Equipment to have a type");
                return null;
            }
            sb.append(StringUtil.join(type, (String)"."));
            sb.append(",");
            Boolean attProgress = eq.get(ObjectKey.ATTACKS_PROGRESS);
            if (attProgress == null) {
                context.addWriteMessage(this.getTokenName() + " expected Equipment to know ATTACKS_PROGRESS state");
                return null;
            }
            if (!attProgress.booleanValue()) {
                sb.append('*');
            }
            if ((bonuses = eq.getListFor(ListKey.BONUS)) == null || bonuses.isEmpty()) {
                sb.append("1");
            } else {
                if (bonuses.size() != 1) {
                    context.addWriteMessage(this.getTokenName() + " expected only one BONUS on Equipment: " + bonuses);
                    return null;
                }
                BonusObj extraAttacks = bonuses.iterator().next();
                sb.append(Integer.parseInt(extraAttacks.getValue()) + 1);
            }
            sb.append(",");
            EquipmentHead head = eq.getEquipmentHeadReference(1);
            if (head == null) {
                context.addWriteMessage(this.getTokenName() + " expected an EquipmentHead on Equipment");
                return null;
            }
            String damage = head.get(StringKey.DAMAGE);
            if (damage == null) {
                context.addWriteMessage(this.getTokenName() + " expected a Damage on EquipmentHead");
                return null;
            }
            sb.append(damage);
            Integer hands = eq.get(IntegerKey.SLOTS);
            if (hands != null && hands != 0) {
                sb.append(',').append(hands);
            }
            List<SpecialProperty> spropList = eq.getSafeListFor(ListKey.SPECIAL_PROPERTIES);
            for (SpecialProperty sprop : spropList) {
                sb.append(",SPROP=").append(sprop.toString());
            }
            first = false;
        }
        return new String[]{sb.toString()};
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public boolean process(LoadContext context, CDOMObject obj) {
        List<Equipment> natWeapons = obj.getListFor(ListKey.NATURAL_WEAPON);
        if (natWeapons != null) {
            Integer requiredSize;
            Formula sizeFormula = obj.getSafe(FormulaKey.SIZE);
            if (obj.get(FormulaKey.SIZE) == null && obj.hasPreReqTypeOf("SIZE") && (requiredSize = this.getRequiredSize(obj)) != null) {
                sizeFormula = FormulaFactory.getFormulaFor(requiredSize);
            }
            if (sizeFormula.isStatic()) {
                int isize = sizeFormula.resolveStatic().intValue();
                SizeAdjustment size = context.getReferenceContext().getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(isize);
                for (Equipment e : natWeapons) {
                    CDOMDirectSingleRef<SizeAdjustment> sizeRef = CDOMDirectSingleRef.getRef(size);
                    e.put(ObjectKey.BASESIZE, sizeRef);
                    e.put(ObjectKey.SIZE, sizeRef);
                }
            } else {
                Logging.errorPrint("SIZE in " + obj.getClass().getSimpleName() + " " + obj.getKeyName() + " must not be a variable " + "if it contains a NATURALATTACKS token");
            }
        }
        return true;
    }

    private Integer getRequiredSize(CDOMObject obj) {
        HashSet<Prerequisite> sizePrereqs = new HashSet<Prerequisite>();
        for (Prerequisite prereq : obj.getPrerequisiteList()) {
            sizePrereqs.addAll(PrerequisiteUtilities.getPreReqsOfKind(prereq, "SIZE"));
        }
        Integer requiredSize = null;
        for (Prerequisite prereq : sizePrereqs) {
            SizeAdjustment sa = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(SizeAdjustment.class, prereq.getOperand());
            int targetSize = sa.get(IntegerKey.SIZEORDER);
            if (requiredSize != null && requiredSize != targetSize) {
                return null;
            }
            requiredSize = targetSize;
        }
        return requiredSize;
    }

    @Override
    public Class<CDOMObject> getDeferredTokenClass() {
        return this.getTokenClass();
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

