/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class TemplateToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<PCTemplate> {
    private static final Class<PCTemplate> PCTEMPLATE_CLASS = PCTemplate.class;

    @Override
    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    public String getTokenName() {
        return "TEMPLATE";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        Formula count;
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String activeValue = sep.next();
        if (!sep.hasNext()) {
            count = FormulaFactory.ONE;
        } else {
            count = FormulaFactory.getFormulaFor(activeValue);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            activeValue = sep.next();
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getFullName() + " had too many pipe separated items: " + value, context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty(',', activeValue);
        if (!pr.passed()) {
            return pr;
        }
        ArrayList<CDOMSingleRef<PCTemplate>> refs = new ArrayList<CDOMSingleRef<PCTemplate>>();
        StringTokenizer tok = new StringTokenizer(activeValue, ",");
        while (tok.hasMoreTokens()) {
            refs.add(context.getReferenceContext().getCDOMReference(PCTEMPLATE_CLASS, tok.nextToken()));
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        ChoiceSet cs = new ChoiceSet("TEMPLATE", rcs);
        ConcretePersistentTransitionChoice<PCTemplate> tc = new ConcretePersistentTransitionChoice<PCTemplate>(cs, count);
        context.getObjectContext().addToList(obj, ListKey.ADD, tc);
        tc.setChoiceActor(this);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<PersistentTransitionChoice<?>> grantChanges = context.getObjectContext().getListChanges(obj, ListKey.ADD);
        Collection<PersistentTransitionChoice<?>> addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice transitionChoice : addedItems) {
            SelectableSet cs = transitionChoice.getChoices();
            if (!PCTEMPLATE_CLASS.equals(cs.getChoiceClass())) continue;
            Formula f = transitionChoice.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            if (f.isStatic() && f.resolveStatic().doubleValue() <= 0.0) {
                context.addWriteMessage("Count in " + this.getFullName() + " must be > 0");
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(cs.getLSTformat());
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(CDOMObject owner, PCTemplate choice, PlayerCharacter pc) {
        pc.addTemplate(choice);
    }

    @Override
    public boolean allow(PCTemplate choice, PlayerCharacter pc, boolean allowStack) {
        return !pc.hasTemplate(choice);
    }

    @Override
    public PCTemplate decodeChoice(LoadContext context, String s) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(PCTEMPLATE_CLASS, s);
    }

    @Override
    public String encodeChoice(PCTemplate choice) {
        return choice.getKeyName();
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, PCTemplate choice) {
    }

    @Override
    public void removeChoice(PlayerCharacter pc, CDOMObject owner, PCTemplate choice) {
        pc.removeTemplate(choice);
    }
}

