/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.abilitycategory;

import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.Type;
import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class TypeToken
extends AbstractNonEmptyToken<AbilityCategory>
implements CDOMPrimaryToken<AbilityCategory>,
DeferredToken<AbilityCategory> {
    @Override
    public String getTokenName() {
        return "TYPE";
    }

    @Override
    public ParseResult parseNonEmptyToken(LoadContext context, AbilityCategory ac, String value) {
        if ("*".equals(value)) {
            ac.setAllAbilityTypes(true);
            return ParseResult.SUCCESS;
        }
        ParseResult pr = this.checkForIllegalSeparator('.', value);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer st = new StringTokenizer(value, ".");
        while (st.hasMoreTokens()) {
            String typeString = st.nextToken();
            if ("*".equals(typeString)) {
                return new ParseResult.Fail("Use of named types along with TYPE:* in category " + ac.getDisplayName() + " is invalid.  Found: " + value, context);
            }
            ac.addAbilityType(Type.getConstant(typeString));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, AbilityCategory ac) {
        if (ac.isAllAbilityTypes()) {
            return new String[]{"*"};
        }
        Set<Type> types = ac.getTypes();
        if (types.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(types, (String)".")};
    }

    @Override
    public Class<AbilityCategory> getTokenClass() {
        return AbilityCategory.class;
    }

    @Override
    public Class<AbilityCategory> getDeferredTokenClass() {
        return AbilityCategory.class;
    }

    @Override
    public boolean process(LoadContext context, AbilityCategory ac) {
        if (ac.isAllAbilityTypes()) {
            if (!ac.getTypes().isEmpty()) {
                Logging.log(Logging.LST_ERROR, "Use of named types along with TYPE:* in category " + ac.getDisplayName() + " is invalid.");
                return false;
            }
            if (ac.hasDirectReferences()) {
                Logging.log(Logging.LST_ERROR, "Use of ABILITYLIST along with TYPE:* in category " + ac.getDisplayName() + " is invalid.");
                return false;
            }
        }
        return true;
    }
}

