//**************************************************************************************************
//                                         FileTasks.hpp                                           *
//                                        ---------------                                          *
// Description : This is a helper class for FrmMain, it handles most of the file operations.       *
// Started     : 2005-05-28                                                                        *
// Last Update : 2020-10-06                                                                        *
// Copyright   : (C) 2005-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef FILETASKS_HPP
#define FILETASKS_HPP

// Application includes

class FrmMain;

#include "TypeDefs.hpp"
#include "Config.hpp"
#include "base/SimnBase.hpp"
#include "process/PrcSchem.hpp"
#include "process/PrcNetLstr.hpp"

// wxWidgets includes

#include <wx/config.h>

//**************************************************************************************************

class FileTasks
{
  private :

    FrmMain   * m_poFrmMain;    // Pointer to application main frame
    PrcNetLstr  m_oPrcNetLstr;  // Netlist file conversion utility

    // Object initialization functions
    void  InitGuileProc ( void );
    void  InitSchemFiles( void );
    void  InitNetLstFile( void );

    void  DlgErrSchems  ( void );
    void  DlgErrNetLst  ( void );

    bool  bExecImport   ( void );

  public :

    explicit  FileTasks( FrmMain * poFrmMain );
             ~FileTasks( );

    void  Initialize( void );  // This function calls all the initialization fns

    bool  bIsOk_gnetlist( void );

    bool  bSetTitle     ( void );
    bool  bSetGuileProc ( const wxString      &  rosGuileProc  );
    bool  bSetSchemFiles( const wxString      & roasFileNames );
    bool  bSetSchemFiles( const wxArrayString & roasFileNames );
    bool  bSetNetLstFile( const wxString      &  rosFileName=PRCNETLST_USE_SCHEM );
    bool  bSetLogFile   ( const wxString      &  rosFileName  )
                                            { return( m_oPrcNetLstr.bSetLogFile( rosFileName ) ); }

    const wxString      &  rosGetGuileProc ( void );
    const wxArrayString & rosaGetSchemFiles( void );
    const wxString      &  rosGetNetLstFile( void );
    const wxString      &  rosGetLogFile   ( void );

    bool  bDlgOpen    ( void );
    bool  bDlgImport  ( void );
    bool  bDelTmpFiles( void );

    bool  bOpen  ( void );
    bool  bImport( void );
    bool  bReload( void );
    bool  bClose ( void );
    bool  bExit  ( void );

    bool  bReloadReqd( void );

    // Declare friend classes
    friend  class  FrmMain;
};

//**************************************************************************************************

#endif // FILETASKS_HPP
