/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.tools.ant.BuildException;
import org.java.plugin.tools.ant.BaseJpfTask;
import org.java.plugin.tools.docgen.DocGenerator;

public final class DocTask
extends BaseJpfTask {
    private File destDir;
    private File overviewFile;
    private String encoding;
    private String docEncoding;
    private String templatesPath;
    private File stylesheetFile;

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void setOverview(File file) {
        this.overviewFile = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDocEncoding(String string) {
        this.docEncoding = string;
    }

    public void setStylesheetFile(File file) {
        this.stylesheetFile = file;
    }

    public void setTemplates(String string) {
        this.templatesPath = string;
    }

    public void execute() {
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!", this.getLocation());
        }
        if (!this.destDir.exists() && !this.destDir.mkdirs()) {
            throw new BuildException("can't make " + this.destDir + " folder", this.getLocation());
        }
        if (this.destDir.list().length != 0) {
            throw new BuildException("directory " + this.destDir + " is not empty", this.getLocation());
        }
        this.initRegistry(true);
        this.log("Generating plug-ins documentation...");
        try {
            DocGenerator docGenerator = this.templatesPath != null ? new DocGenerator(this.getRegistry(), this.getPathResolver(), this.templatesPath, this.encoding) : new DocGenerator(this.getRegistry(), this.getPathResolver());
            if (this.overviewFile != null) {
                docGenerator.setDocumentationOverview(this.getFileContent(this.overviewFile));
            }
            if (this.stylesheetFile != null) {
                docGenerator.setStylesheet(this.getFileContent(this.stylesheetFile));
            }
            if (this.docEncoding != null) {
                docGenerator.setOutputEncoding(this.docEncoding);
            }
            docGenerator.generate(this.destDir);
            this.log("... documentation generated to folder " + this.destDir);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(File file) throws IOException {
        BufferedReader bufferedReader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[256];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            ((Reader)bufferedReader).close();
        }
    }
}

