/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.java.plugin.util.IoUtil;

final class ShadingUtil {
    static String getExtension(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && n > 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpack(ZipFile zipFile, File file) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            File file2 = new File(file.getCanonicalPath() + "/" + string);
            if (string.endsWith("/")) {
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new IOException("can't create folder " + file2);
                }
            } else {
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new IOException("can't create folder " + file3);
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2, false));
                try {
                    IoUtil.copyStream(zipFile.getInputStream(zipEntry), bufferedOutputStream, 1024);
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            file2.setLastModified(zipEntry.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpack(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string = zipEntry.getName();
            File file2 = new File(file.getCanonicalPath() + "/" + string);
            if (string.endsWith("/")) {
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new IOException("can't create folder " + file2);
                }
            } else {
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new IOException("can't create folder " + file3);
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2, false));
                try {
                    IoUtil.copyStream(zipInputStream, bufferedOutputStream, 1024);
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            file2.setLastModified(zipEntry.getTime());
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            IoUtil.emptyFolder(file);
        }
        return file.delete();
    }

    static Date getLastModified(URL uRL) throws IOException {
        Object object;
        long l = 0L;
        File file = IoUtil.url2file(uRL);
        if (file != null) {
            l = file.lastModified();
        } else {
            object = uRL.openConnection();
            if (object instanceof JarURLConnection) {
                return ShadingUtil.getLastModified(((JarURLConnection)object).getJarFileURL());
            }
            l = ((URLConnection)object).getLastModified();
        }
        if (l == 0L) {
            throw new IOException("can't retrieve modification date for resource " + uRL);
        }
        object = Calendar.getInstance(Locale.ENGLISH);
        ((Calendar)object).setTime(new Date(l));
        ((Calendar)object).set(14, 0);
        return ((Calendar)object).getTime();
    }

    private static String getRelativePath(File file, File file2) throws IOException {
        String string;
        String string2;
        String string3 = file2.getCanonicalPath();
        if (file.isFile()) {
            File file3 = file.getParentFile();
            if (file3 == null) {
                return null;
            }
            string2 = file3.getCanonicalPath();
        } else {
            string2 = file.getCanonicalPath();
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        int n = string2.indexOf(File.separatorChar);
        String string4 = null;
        while (n != -1 && string3.startsWith(string = string2.substring(0, n + 1))) {
            string4 = string;
            n = string2.indexOf(File.separatorChar, n + 1);
        }
        if (string4 == null) {
            return null;
        }
        string3 = string3.substring(string4.length());
        if (string4.length() == string2.length()) {
            return string3;
        }
        int n2 = 0;
        n = string2.indexOf(File.separatorChar, string4.length());
        while (n != -1) {
            ++n2;
            n = string2.indexOf(File.separatorChar, n + 1);
        }
        for (int i = 0; i < n2; ++i) {
            string3 = ".." + File.separator + string3;
        }
        return string3;
    }

    private static String getRelativeUrl(File file, File file2) throws IOException {
        String string = ShadingUtil.getRelativePath(file, file2);
        if (string == null) {
            return null;
        }
        string = string.replace('\\', '/');
        if (file2.isDirectory() && !string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    static String getRelativeUrl(File file, URL uRL) throws IOException {
        int n;
        String string;
        File file2 = IoUtil.url2file(uRL);
        if (file2 != null && (string = ShadingUtil.getRelativeUrl(file, file2)) != null) {
            return string;
        }
        if ("jar".equalsIgnoreCase(uRL.getProtocol()) && (n = (string = uRL.toExternalForm()).indexOf("!/")) != -1) {
            return "jar:" + ShadingUtil.getRelativeUrl(file, new URL(string.substring(4, n))) + string.substring(n);
        }
        return uRL.toExternalForm();
    }

    static URL buildURL(URL uRL, String string) throws MalformedURLException {
        if (!string.toLowerCase(Locale.ENGLISH).startsWith("jar:")) {
            return new URL(uRL, string);
        }
        int n = string.indexOf("!/");
        if (n == -1) {
            return new URL(uRL, string);
        }
        return new URL("jar:" + new URL(uRL, string.substring(4, n)).toExternalForm() + string.substring(n));
    }

    private ShadingUtil() {
    }
}

