/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;

public class StandardPathResolver
extends PathResolver {
    protected Log log = LogFactory.getLog(this.getClass());
    private Map urlMap = new HashMap();

    public void registerContext(Identity identity, URL uRL) {
        if (!(identity instanceof PluginDescriptor) && !(identity instanceof PluginFragment)) {
            throw new IllegalArgumentException("unsupported identity class " + identity.getClass().getName());
        }
        URL uRL2 = this.urlMap.put(identity.getId(), uRL);
        if (uRL2 != null) {
            this.log.warn("old context URL " + uRL2 + " has been replaced with new " + uRL + " for " + identity + " with key " + identity.getId());
        } else {
            this.log.debug("context URL " + uRL + " registered for " + identity + " with key " + identity.getId());
        }
    }

    public void unregisterContext(String string) {
        URL uRL = (URL)this.urlMap.remove(string);
        if (uRL == null) {
            this.log.warn("no context was registered with key " + string);
        } else {
            this.log.debug("context URL " + uRL + " un-registered for key " + string);
        }
    }

    public URL resolvePath(Identity identity, String string) {
        URL uRL;
        if (identity instanceof PluginDescriptor || identity instanceof PluginFragment) {
            uRL = this.getRegisteredConext(identity.getId());
        } else if (identity instanceof PluginElement) {
            PluginElement pluginElement = (PluginElement)identity;
            uRL = pluginElement.getDeclaringPluginFragment() != null ? this.getRegisteredConext(pluginElement.getDeclaringPluginFragment().getId()) : this.getRegisteredConext(pluginElement.getDeclaringPluginDescriptor().getId());
        } else {
            throw new IllegalArgumentException("unknown identity class " + identity.getClass().getName());
        }
        return this.resolvePath(uRL, string);
    }

    public URL getRegisteredConext(String string) {
        URL uRL = (URL)this.urlMap.get(string);
        if (uRL == null) {
            throw new IllegalArgumentException("unknown plug-in or plug-in fragment ID - " + string);
        }
        return uRL;
    }

    public boolean isContextRegistered(String string) {
        return this.urlMap.containsKey(string);
    }

    protected URL resolvePath(URL uRL, String string) {
        if ("".equals(string) || "/".equals(string)) {
            return uRL;
        }
        try {
            String string2;
            File file = IoUtil.url2file(uRL);
            if (file != null && file.isFile() && ((string2 = file.getName().toLowerCase(Locale.getDefault())).endsWith(".jar") || string2.endsWith(".zip"))) {
                return new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/" + string);
            }
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.log.error("can't create URL in context of " + uRL + " and path " + string, malformedURLException);
            throw new IllegalArgumentException("path " + string + " in context of " + uRL + " cause creation of malformed URL");
        }
    }

    public void configure(ExtendedProperties extendedProperties) throws Exception {
    }
}

