/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.JpfException;
import org.java.plugin.PathResolver;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.PluginLifecycleHandler;

public final class StandardPluginManager
extends PluginManager {
    Log log = LogFactory.getLog(this.getClass());
    private final PathResolver pathResolver;
    private final PluginRegistry registry;
    private final PluginLifecycleHandler lifecycleHandler;
    private final Map activePlugins = new HashMap();
    private final Set activatingPlugins = new HashSet();
    private final Set badPlugins = new HashSet();
    private final List activationLog = new LinkedList();
    private final Map classLoaders = new HashMap();
    private final Set disabledPlugins = new HashSet();
    private final List listeners = Collections.synchronizedList(new LinkedList());
    private PluginRegistry.RegistryChangeListener registryChangeListener;

    protected StandardPluginManager(PluginRegistry pluginRegistry, PathResolver pathResolver, PluginLifecycleHandler pluginLifecycleHandler) {
        this.registry = pluginRegistry;
        this.pathResolver = pathResolver;
        this.lifecycleHandler = pluginLifecycleHandler;
        this.lifecycleHandler.init(this);
        this.registryChangeListener = new PluginRegistry.RegistryChangeListener(){

            public void registryChanged(PluginRegistry.RegistryChangeData registryChangeData) {
                StandardPluginManager.this.registryChangeHandler(registryChangeData);
            }
        };
        this.registry.registerListener(this.registryChangeListener);
    }

    public PluginRegistry getRegistry() {
        return this.registry;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    synchronized void registryChangeHandler(PluginRegistry.RegistryChangeData registryChangeData) {
        String string;
        this.badPlugins.clear();
        Iterator iterator = registryChangeData.removedPlugins().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.deactivatePlugin(string);
            this.pathResolver.unregisterContext(string);
        }
        iterator = registryChangeData.modifiedPlugins().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.activePlugins.containsKey(string)) {
                this.deactivatePlugin(string);
                try {
                    this.activatePlugin(string);
                }
                catch (Exception exception) {
                    this.log.error("failed activating modified plug-in " + string, exception);
                }
                continue;
            }
            PluginClassLoader pluginClassLoader = (PluginClassLoader)this.classLoaders.get(string);
            if (pluginClassLoader == null) continue;
            this.notifyClassLoader(pluginClassLoader);
        }
    }

    public Map publishPlugins(PluginManager.PluginLocation[] pluginLocationArray) throws JpfException {
        URL[] uRLArray = new URL[pluginLocationArray.length];
        HashMap<URL, URL> hashMap = new HashMap<URL, URL>(pluginLocationArray.length);
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = pluginLocationArray[i].getManifestLocation();
            hashMap.put(uRLArray[i], pluginLocationArray[i].getContextLocation());
        }
        Map map = this.registry.register(uRLArray);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.pathResolver.registerContext((Identity)entry.getValue(), (URL)hashMap.get(entry.getKey()));
        }
        return map;
    }

    public Plugin getPlugin(String string) throws PluginLifecycleException {
        Plugin plugin = (Plugin)this.activePlugins.get(string);
        if (plugin != null) {
            return plugin;
        }
        if (this.badPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled externally");
        }
        PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        return this.activatePlugin(pluginDescriptor);
    }

    public void activatePlugin(String string) throws PluginLifecycleException {
        if (this.activePlugins.containsKey(string)) {
            return;
        }
        if (this.badPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled externally");
        }
        PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        this.activatePlugin(pluginDescriptor);
    }

    public Plugin getPluginFor(Object object) {
        if (object == null) {
            return null;
        }
        ClassLoader classLoader = object instanceof Class ? ((Class)object).getClassLoader() : (object instanceof ClassLoader ? (ClassLoader)object : object.getClass().getClassLoader());
        if (!(classLoader instanceof PluginClassLoader)) {
            return null;
        }
        PluginDescriptor pluginDescriptor = ((PluginClassLoader)classLoader).getPluginDescriptor();
        Plugin plugin = (Plugin)this.activePlugins.get(pluginDescriptor.getId());
        if (plugin != null) {
            return plugin;
        }
        throw new IllegalStateException("can't get plug-in " + pluginDescriptor);
    }

    public boolean isPluginActivated(PluginDescriptor pluginDescriptor) {
        return this.activePlugins.containsKey(pluginDescriptor.getId());
    }

    public boolean isBadPlugin(PluginDescriptor pluginDescriptor) {
        return this.badPlugins.contains(pluginDescriptor.getId());
    }

    public boolean isPluginActivating(PluginDescriptor pluginDescriptor) {
        return this.activatingPlugins.contains(pluginDescriptor.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginClassLoader getPluginClassLoader(PluginDescriptor pluginDescriptor) {
        if (this.badPlugins.contains(pluginDescriptor.getId())) {
            throw new IllegalArgumentException("plug-in " + pluginDescriptor.getId() + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(pluginDescriptor.getId())) {
            throw new IllegalArgumentException("plug-in " + pluginDescriptor.getId() + " disabled externally");
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)this.classLoaders.get(pluginDescriptor.getId());
        if (pluginClassLoader != null) {
            return pluginClassLoader;
        }
        StandardPluginManager standardPluginManager = this;
        synchronized (standardPluginManager) {
            pluginClassLoader = (PluginClassLoader)this.classLoaders.get(pluginDescriptor.getId());
            if (pluginClassLoader != null) {
                return pluginClassLoader;
            }
            pluginClassLoader = this.lifecycleHandler.createPluginClassLoader(pluginDescriptor);
            this.classLoaders.put(pluginDescriptor.getId(), pluginClassLoader);
        }
        return pluginClassLoader;
    }

    public synchronized void shutdown() {
        this.log.debug("shutting down...");
        this.dump();
        this.registry.unregisterListener(this.registryChangeListener);
        ArrayList arrayList = new ArrayList(this.activationLog);
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
            if (pluginDescriptor == null) {
                this.log.warn("can't find descriptor for plug-in " + string + " to deactivate plug-in");
                continue;
            }
            this.deactivatePlugin(pluginDescriptor);
        }
        this.dump();
        this.classLoaders.clear();
        this.disabledPlugins.clear();
        this.listeners.clear();
        this.lifecycleHandler.dispose();
        this.log.info("shutdown done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Plugin activatePlugin(PluginDescriptor pluginDescriptor) throws PluginLifecycleException {
        Plugin plugin = (Plugin)this.activePlugins.get(pluginDescriptor.getId());
        if (plugin != null) {
            return plugin;
        }
        if (this.badPlugins.contains(pluginDescriptor.getId())) {
            throw new IllegalArgumentException("plug-in " + pluginDescriptor.getId() + " disabled as it wasn't properly initialized");
        }
        if (this.activatingPlugins.contains(pluginDescriptor.getId())) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginDependenciesLoopDetected", pluginDescriptor.getId());
        }
        this.activatingPlugins.add(pluginDescriptor.getId());
        try {
            Object object;
            try {
                this.checkPrerequisites(pluginDescriptor);
                object = pluginDescriptor.getPluginClassName();
                plugin = object == null || ((String)object).trim().length() == 0 ? new EmptyPlugin() : this.lifecycleHandler.createPluginInstance(pluginDescriptor);
                this.initPlugin(plugin, pluginDescriptor);
                this.lifecycleHandler.beforePluginStart(plugin);
                this.startPlugin(plugin);
            }
            catch (PluginLifecycleException pluginLifecycleException) {
                this.badPlugins.add(pluginDescriptor.getId());
                this.classLoaders.remove(pluginDescriptor.getId());
                throw pluginLifecycleException;
            }
            catch (Exception exception) {
                this.badPlugins.add(pluginDescriptor.getId());
                this.classLoaders.remove(pluginDescriptor.getId());
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginStartFailed", pluginDescriptor.getUniqueId(), exception);
            }
            this.activePlugins.put(pluginDescriptor.getId(), plugin);
            this.activationLog.add(pluginDescriptor.getId());
            this.log.info("plug-in started - " + pluginDescriptor.getUniqueId());
            this.fireEvent(plugin, true);
            object = plugin;
            return object;
        }
        finally {
            this.activatingPlugins.remove(pluginDescriptor.getId());
        }
    }

    private void checkPrerequisites(PluginDescriptor pluginDescriptor) throws PluginLifecycleException {
        Iterator iterator = pluginDescriptor.getPrerequisites().iterator();
        while (iterator.hasNext()) {
            PluginPrerequisite pluginPrerequisite = (PluginPrerequisite)iterator.next();
            if (this.activatingPlugins.contains(pluginPrerequisite.getPluginId())) continue;
            if (this.badPlugins.contains(pluginPrerequisite.getPluginId())) {
                if (pluginPrerequisite.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteBad", new Object[]{pluginDescriptor.getId(), pluginPrerequisite.getPluginId()});
            }
            if (this.disabledPlugins.contains(pluginPrerequisite.getPluginId())) {
                if (pluginPrerequisite.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteDisabled", new Object[]{pluginDescriptor.getId(), pluginPrerequisite.getPluginId()});
            }
            if (!pluginPrerequisite.matches()) {
                if (pluginPrerequisite.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteIncompatible", new Object[]{pluginDescriptor.getId(), pluginPrerequisite.getPluginId()});
            }
            try {
                this.activatePlugin(this.registry.getPluginDescriptor(pluginPrerequisite.getPluginId()));
            }
            catch (PluginLifecycleException pluginLifecycleException) {
                if (pluginPrerequisite.isOptional()) {
                    this.log.warn("failed activating optional plug-in from prerequisite " + pluginPrerequisite, pluginLifecycleException);
                    continue;
                }
                throw pluginLifecycleException;
            }
        }
    }

    public void deactivatePlugin(String string) {
        Object object;
        if (!this.activePlugins.containsKey(string)) {
            return;
        }
        PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        Object object2 = this.registry.getDependingPlugins(pluginDescriptor).iterator();
        while (object2.hasNext()) {
            object = (PluginDescriptor)object2.next();
            hashMap.put(object.getId(), (PluginDescriptor)object);
        }
        object2 = new LinkedList();
        object = new ArrayList(this.activationLog);
        Collections.reverse(object);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals(pluginDescriptor.getId())) {
                object2.add(pluginDescriptor);
                continue;
            }
            if (!hashMap.containsKey(string2)) continue;
            object2.add(hashMap.get(string2));
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            this.deactivatePlugin((PluginDescriptor)iterator.next());
        }
        this.dump();
    }

    private synchronized void deactivatePlugin(PluginDescriptor pluginDescriptor) {
        PluginClassLoader pluginClassLoader;
        Plugin plugin = (Plugin)this.activePlugins.remove(pluginDescriptor.getId());
        if (plugin != null) {
            try {
                if (plugin.isActive()) {
                    this.fireEvent(plugin, false);
                    this.stopPlugin(plugin);
                    this.lifecycleHandler.afterPluginStop(plugin);
                    this.log.info("plug-in stopped - " + pluginDescriptor.getUniqueId());
                } else {
                    this.log.warn("plug-in " + pluginDescriptor.getUniqueId() + " is not active although present in active plug-ins list");
                }
            }
            catch (Exception exception) {
                this.log.error("error while stopping plug-in " + pluginDescriptor.getUniqueId(), exception);
            }
        }
        if ((pluginClassLoader = (PluginClassLoader)this.classLoaders.remove(pluginDescriptor.getId())) != null) {
            this.disposeClassLoader(pluginClassLoader);
        }
        this.badPlugins.remove(pluginDescriptor.getId());
        this.activationLog.remove(pluginDescriptor.getId());
    }

    private void dump() {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("PLUGIN MANAGER DUMP:\r\n");
        stringBuffer.append("-------------- DUMP BEGIN -----------------\r\n");
        stringBuffer.append("\tActive plug-ins: " + this.activePlugins.size()).append("\r\n");
        Iterator<Object> iterator = this.activePlugins.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tActivating plug-ins: " + this.activatingPlugins.size()).append("\r\n");
        iterator = this.activatingPlugins.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tPlug-ins with instantiated class loaders: " + this.classLoaders.size()).append("\r\n");
        iterator = this.classLoaders.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tDisabled plug-ins: " + this.disabledPlugins.size()).append("\r\n");
        iterator = this.disabledPlugins.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tBad plug-ins: " + this.badPlugins.size()).append("\r\n");
        iterator = this.badPlugins.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tActivation log: " + this.activationLog.size()).append("\r\n");
        iterator = this.activationLog.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        stringBuffer.append("-------------- DUMP END -----------------");
        this.log.trace(stringBuffer.toString());
    }

    public PluginDescriptor[] disablePlugin(PluginDescriptor pluginDescriptor) {
        LinkedList<PluginDescriptor> linkedList = new LinkedList<PluginDescriptor>();
        if (!this.disabledPlugins.contains(pluginDescriptor.getId())) {
            this.deactivatePlugin(pluginDescriptor);
            this.fireEvent(pluginDescriptor, false);
            this.disabledPlugins.add(pluginDescriptor.getId());
            linkedList.add(pluginDescriptor);
        }
        Iterator iterator = this.registry.getDependingPlugins(pluginDescriptor).iterator();
        while (iterator.hasNext()) {
            PluginDescriptor pluginDescriptor2 = (PluginDescriptor)iterator.next();
            if (this.disabledPlugins.contains(pluginDescriptor2.getId())) continue;
            this.deactivatePlugin(pluginDescriptor2);
            this.fireEvent(pluginDescriptor2, false);
            this.disabledPlugins.add(pluginDescriptor2.getId());
            linkedList.add(pluginDescriptor2);
        }
        return linkedList.toArray(new PluginDescriptor[linkedList.size()]);
    }

    public PluginDescriptor[] enablePlugin(PluginDescriptor pluginDescriptor, boolean bl) {
        LinkedList<PluginDescriptor> linkedList = new LinkedList<PluginDescriptor>();
        if (this.disabledPlugins.contains(pluginDescriptor.getId())) {
            this.disabledPlugins.remove(pluginDescriptor.getId());
            this.fireEvent(pluginDescriptor, true);
            linkedList.add(pluginDescriptor);
        }
        if (bl) {
            Iterator iterator = this.registry.getDependingPlugins(pluginDescriptor).iterator();
            while (iterator.hasNext()) {
                PluginDescriptor pluginDescriptor2 = (PluginDescriptor)iterator.next();
                if (!this.disabledPlugins.contains(pluginDescriptor2.getId())) continue;
                this.disabledPlugins.remove(pluginDescriptor2.getId());
                this.fireEvent(pluginDescriptor2, true);
                linkedList.add(pluginDescriptor2);
            }
        }
        return linkedList.toArray(new PluginDescriptor[linkedList.size()]);
    }

    public boolean isPluginEnabled(PluginDescriptor pluginDescriptor) {
        return !this.disabledPlugins.contains(pluginDescriptor.getId());
    }

    public void registerListener(PluginManager.EventListener eventListener) {
        if (this.listeners.contains(eventListener)) {
            throw new IllegalArgumentException("listener " + eventListener + " already registered");
        }
        this.listeners.add(eventListener);
    }

    public void unregisterListener(PluginManager.EventListener eventListener) {
        if (!this.listeners.remove(eventListener)) {
            throw new IllegalArgumentException("unknown listener " + eventListener);
        }
    }

    private void fireEvent(Object object, boolean bl) {
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginManager.EventListener[] eventListenerArray = this.listeners.toArray(new PluginManager.EventListener[this.listeners.size()]);
        if (object instanceof PluginDescriptor) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)object;
            if (bl) {
                this.log.debug("propagating \"pluginEnabled\" event for " + pluginDescriptor);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    eventListenerArray[i].pluginEnabled(pluginDescriptor);
                }
            } else {
                this.log.debug("propagating \"pluginDisabled\" event for " + pluginDescriptor);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    eventListenerArray[i].pluginDisabled(pluginDescriptor);
                }
            }
        } else {
            Plugin plugin = (Plugin)object;
            if (bl) {
                this.log.debug("propagating \"pluginActivated\" event for " + plugin);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    eventListenerArray[i].pluginActivated(plugin);
                }
            } else {
                this.log.debug("propagating \"pluginDeactivated\" event for " + plugin);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    eventListenerArray[i].pluginDeactivated(plugin);
                }
            }
        }
    }

    private static final class EmptyPlugin
    extends Plugin {
        private EmptyPlugin() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

