/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationInitializer;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.BootErrorHandlerConsole;
import org.java.plugin.boot.BootErrorHandlerGui;
import org.java.plugin.boot.ControlThread;
import org.java.plugin.boot.DefaultApplicationInitializer;
import org.java.plugin.boot.ErrorDialog;
import org.java.plugin.boot.ServiceApplication;
import org.java.plugin.boot.SplashWindow;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;

public final class Boot {
    public static final String BOOT_ERROR_FILE_NAME = "jpf-boot-error.txt";
    public static final String BOOT_MODE_COMMAND_NAME = "jpf.boot.mode";
    public static final String BOOT_MODE_SHELL = "shell";
    public static final String BOOT_MODE_START = "start";
    public static final String BOOT_MODE_STOP = "stop";
    public static final String BOOT_MODE_RESTART = "restart";
    static final String PACKAGE_NAME = "org.java.plugin.boot";
    private static final String PARAM_CONTROL_HOST = "org.java.plugin.boot.controlHost";
    private static final String PARAM_CONTROL_PORT = "org.java.plugin.boot.controlPort";
    private static final String PARAM_ERROR_HANDLER = "org.java.plugin.boot.errorHandler";
    private static final String PARAM_APP_INITIALIZER = "org.java.plugin.boot.appInitializer";
    private static final String PARAM_SPLASH_IMAGE = "org.java.plugin.boot.splashImage";
    static /* synthetic */ Class class$org$java$plugin$boot$Boot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Boot.clearBootLog();
        ExtendedProperties extendedProperties = new ExtendedProperties(System.getProperties());
        try {
            FileInputStream fileInputStream = new FileInputStream("boot.properties");
            try {
                extendedProperties.load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = extendedProperties.containsKey(PARAM_CONTROL_HOST) && extendedProperties.containsKey(PARAM_CONTROL_PORT);
        BootErrorHandler bootErrorHandler = Boot.getErrorHandlerInstance(extendedProperties.getProperty(PARAM_ERROR_HANDLER), bl);
        try {
            Object object;
            String string;
            String string2;
            if (extendedProperties.getProperty("applicationRoot") == null) {
                string2 = new File(".").getCanonicalPath();
                extendedProperties.put("applicationRoot", string2);
            }
            string2 = bl ? InetAddress.getByName(extendedProperties.getProperty(PARAM_CONTROL_HOST)) : null;
            int n = bl ? Integer.parseInt(extendedProperties.getProperty(PARAM_CONTROL_PORT), 10) : 0;
            String string3 = System.getProperty(BOOT_MODE_COMMAND_NAME);
            if (string3 != null) {
                string3 = string3.trim().toLowerCase(Locale.ENGLISH);
            } else {
                string3 = BOOT_MODE_SHELL;
                System.setProperty(BOOT_MODE_COMMAND_NAME, string3);
            }
            if (bl && BOOT_MODE_STOP.equals(string3)) {
                if (!ControlThread.stopRunningApplication((InetAddress)((Object)string2), n)) {
                    System.out.println("application not running");
                } else {
                    System.out.println("application stopped");
                }
                return;
            }
            if (bl && BOOT_MODE_START.equals(string3)) {
                if (ControlThread.isApplicationRunning((InetAddress)((Object)string2), n)) {
                    bootErrorHandler.handleFatalError("Application already running.");
                    return;
                }
                Application application = Boot.initApplication(bootErrorHandler, extendedProperties, stringArray);
                if (application == null) {
                    System.exit(1);
                    return;
                }
                if (!(application instanceof ServiceApplication)) {
                    bootErrorHandler.handleFatalError("Application is not a service.");
                    return;
                }
                ControlThread controlThread = new ControlThread((InetAddress)((Object)string2), n, (ServiceApplication)application);
                application.startApplication();
                controlThread.start();
                System.out.println("application started in BACKGROUND mode");
                return;
            }
            if (bl && BOOT_MODE_RESTART.equals(string3)) {
                Application application;
                if (ControlThread.stopRunningApplication((InetAddress)((Object)string2), n)) {
                    System.out.println("another instance of application stopped");
                }
                if ((application = Boot.initApplication(bootErrorHandler, extendedProperties, stringArray)) == null) {
                    System.exit(1);
                    return;
                }
                if (!(application instanceof ServiceApplication)) {
                    bootErrorHandler.handleFatalError("Application is not a service.");
                    return;
                }
                ControlThread controlThread = new ControlThread((InetAddress)((Object)string2), n, (ServiceApplication)application);
                application.startApplication();
                controlThread.start();
                System.out.println("application started in BACKGROUND mode");
                return;
            }
            if (bl && ControlThread.stopRunningApplication((InetAddress)((Object)string2), n)) {
                System.out.println("another instance of application stopped");
            }
            if ((string = extendedProperties.getProperty(PARAM_SPLASH_IMAGE, null)) != null && string.length() > 0) {
                object = new File(string);
                if (((File)object).isFile()) {
                    SplashWindow.splash(IoUtil.file2url((File)object));
                } else {
                    System.out.println("splash image file " + object + " not found");
                }
            }
            if ((object = Boot.initApplication(bootErrorHandler, extendedProperties, stringArray)) == null) {
                System.exit(1);
                return;
            }
            if (object instanceof ServiceApplication) {
                object.startApplication();
                SplashWindow.disposeSplash();
                System.out.println("application started in SHELL mode");
                Boot.runShell();
                Boot.stopApplication((Application)object);
            } else {
                object.startApplication();
                SplashWindow.disposeSplash();
            }
        }
        catch (Throwable throwable) {
            SplashWindow.disposeSplash();
            Boot.bootLog(throwable);
            bootErrorHandler.handleFatalError("Application start failed.", throwable);
            System.exit(1);
        }
    }

    public static void stopApplication(Application application) throws Exception {
        PluginManager pluginManager;
        if (application instanceof ServiceApplication) {
            ((ServiceApplication)application).stopApplication();
        }
        if ((pluginManager = PluginManager.lookup(application)) != null) {
            pluginManager.shutdown();
        }
        LogFactory.getLog((Class)(class$org$java$plugin$boot$Boot == null ? (class$org$java$plugin$boot$Boot = Boot.class$("org.java.plugin.boot.Boot")) : class$org$java$plugin$boot$Boot)).info((Object)"logging system finalized");
        LogFactory.getLog((Class)(class$org$java$plugin$boot$Boot == null ? (class$org$java$plugin$boot$Boot = Boot.class$("org.java.plugin.boot.Boot")) : class$org$java$plugin$boot$Boot)).info((Object)"---------------------------------");
        LogFactory.releaseAll();
    }

    private static BootErrorHandler getErrorHandlerInstance(String string, boolean bl) {
        if (string != null) {
            try {
                return (BootErrorHandler)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return bl ? new BootErrorHandlerConsole() : new BootErrorHandlerGui();
    }

    private static Application initApplication(BootErrorHandler bootErrorHandler, ExtendedProperties extendedProperties, String[] stringArray) throws Exception {
        ApplicationInitializer applicationInitializer = null;
        String string = extendedProperties.getProperty(PARAM_APP_INITIALIZER);
        if (string != null) {
            try {
                applicationInitializer = (ApplicationInitializer)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (applicationInitializer == null) {
            applicationInitializer = new DefaultApplicationInitializer();
        }
        applicationInitializer.configure(extendedProperties);
        return applicationInitializer.initApplication(bootErrorHandler, stringArray);
    }

    private static void runShell() {
        int n;
        System.out.println("Press 'q' key to exit.");
        do {
            try {
                n = System.in.read();
            }
            catch (IOException iOException) {
                break;
            }
        } while ('q' != (char)n && 'Q' != (char)n);
    }

    private static void clearBootLog() {
        File file = new File(BOOT_ERROR_FILE_NAME);
        if (file.isFile()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootLog(Throwable throwable) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(BOOT_ERROR_FILE_NAME, false), "UTF-8");
            try {
                outputStreamWriter.write("JPF Application boot failed.");
                outputStreamWriter.write(System.getProperty("line.separator"));
                outputStreamWriter.write(ErrorDialog.getErrorDetails(throwable));
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (Throwable throwable2) {
            throw new Error("boot failed", throwable);
        }
    }

    private Boot() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

