/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import weka.core.AttributeInfo;
import weka.core.AttributeMetaInfo;
import weka.core.Copyable;
import weka.core.DateAttributeInfo;
import weka.core.Instances;
import weka.core.NominalAttributeInfo;
import weka.core.ProtectedProperties;
import weka.core.RelationalAttributeInfo;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaEnumeration;

public class Attribute
implements Copyable,
Serializable,
RevisionHandler {
    static final long serialVersionUID = -742180568732916383L;
    public static final int NUMERIC = 0;
    public static final int NOMINAL = 1;
    public static final int STRING = 2;
    public static final int DATE = 3;
    public static final int RELATIONAL = 4;
    public static final int ORDERING_SYMBOLIC = 0;
    public static final int ORDERING_ORDERED = 1;
    public static final int ORDERING_MODULO = 2;
    public static final String ARFF_ATTRIBUTE = "@attribute";
    public static final String ARFF_ATTRIBUTE_INTEGER = "integer";
    public static final String ARFF_ATTRIBUTE_REAL = "real";
    public static final String ARFF_ATTRIBUTE_NUMERIC = "numeric";
    public static final String ARFF_ATTRIBUTE_STRING = "string";
    public static final String ARFF_ATTRIBUTE_DATE = "date";
    public static final String ARFF_ATTRIBUTE_RELATIONAL = "relational";
    public static final String ARFF_END_SUBRELATION = "@end";
    protected static final int STRING_COMPRESS_THRESHOLD = 200;
    protected final String m_Name;
    protected int m_Type;
    protected AttributeInfo m_AttributeInfo;
    protected int m_Index = -1;
    protected double m_Weight = 1.0;
    protected AttributeMetaInfo m_AttributeMetaInfo;

    public Attribute(String attributeName) {
        this(attributeName, (ProtectedProperties)null);
    }

    public Attribute(String attributeName, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        if (metadata != null) {
            this.m_AttributeMetaInfo = new AttributeMetaInfo(metadata, this);
        }
    }

    public Attribute(String attributeName, boolean createStringAttribute) {
        this(attributeName, createStringAttribute, (ProtectedProperties)null);
    }

    public Attribute(String attributeName, boolean createStringAttribute, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        if (createStringAttribute) {
            this.m_AttributeInfo = new NominalAttributeInfo(null, attributeName);
            this.m_Type = 2;
        }
        if (metadata != null) {
            this.m_AttributeMetaInfo = new AttributeMetaInfo(metadata, this);
        }
    }

    public Attribute(String attributeName, String dateFormat) {
        this(attributeName, dateFormat, (ProtectedProperties)null);
    }

    public Attribute(String attributeName, String dateFormat, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        this.m_Type = 3;
        this.m_AttributeInfo = new DateAttributeInfo(dateFormat);
        if (metadata != null) {
            this.m_AttributeMetaInfo = new AttributeMetaInfo(metadata, this);
        }
    }

    public Attribute(String attributeName, List<String> attributeValues) {
        this(attributeName, attributeValues, (ProtectedProperties)null);
    }

    public Attribute(String attributeName, List<String> attributeValues, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        this.m_AttributeInfo = new NominalAttributeInfo(attributeValues, attributeName);
        this.m_Type = attributeValues == null ? 2 : 1;
        if (metadata != null) {
            this.m_AttributeMetaInfo = new AttributeMetaInfo(metadata, this);
        }
    }

    public Attribute(String attributeName, Instances header) {
        this(attributeName, header, (ProtectedProperties)null);
    }

    public Attribute(String attributeName, Instances header, ProtectedProperties metadata) {
        if (header.numInstances() > 0) {
            throw new IllegalArgumentException("Header for relation-valued attribute should not contain any instances");
        }
        this.m_Name = attributeName;
        this.m_Type = 4;
        this.m_AttributeInfo = new RelationalAttributeInfo(header);
        if (metadata != null) {
            this.m_AttributeMetaInfo = new AttributeMetaInfo(metadata, this);
        }
    }

    @Override
    public Object copy() {
        return this.copy(this.m_Name);
    }

    public final Enumeration<Object> enumerateValues() {
        if (this.isNominal() || this.isString()) {
            final WekaEnumeration<Object> ee = new WekaEnumeration<Object>(((NominalAttributeInfo)this.m_AttributeInfo).m_Values);
            return new Enumeration<Object>(){

                @Override
                public boolean hasMoreElements() {
                    return ee.hasMoreElements();
                }

                @Override
                public Object nextElement() {
                    Object oo = ee.nextElement();
                    if (oo instanceof SerializedObject) {
                        return ((SerializedObject)oo).getObject();
                    }
                    return oo;
                }
            };
        }
        return null;
    }

    public final boolean equals(Object other) {
        return this.equalsMsg(other) == null;
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final String equalsMsg(Object other) {
        if (other == null) {
            return "Comparing with null object";
        }
        if (!other.getClass().equals(this.getClass())) {
            return "Object has wrong class";
        }
        Attribute att = (Attribute)other;
        if (!this.m_Name.equals(att.m_Name)) {
            return "Names differ: " + this.m_Name + " != " + att.m_Name;
        }
        if (this.isNominal() && att.isNominal()) {
            if (((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size() != ((NominalAttributeInfo)att.m_AttributeInfo).m_Values.size()) {
                return "Different number of labels: " + ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size() + " != " + ((NominalAttributeInfo)att.m_AttributeInfo).m_Values.size();
            }
            for (int i = 0; i < ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size(); ++i) {
                if (((NominalAttributeInfo)this.m_AttributeInfo).m_Values.get(i).equals(((NominalAttributeInfo)att.m_AttributeInfo).m_Values.get(i))) continue;
                return "Labels differ at position " + (i + 1) + ": " + ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.get(i) + " != " + ((NominalAttributeInfo)att.m_AttributeInfo).m_Values.get(i);
            }
            return null;
        }
        if (this.isRelationValued() && att.isRelationValued()) {
            return ((RelationalAttributeInfo)this.m_AttributeInfo).m_Header.equalHeadersMsg(((RelationalAttributeInfo)att.m_AttributeInfo).m_Header);
        }
        if (this.type() != att.type()) {
            return "Types differ: " + Attribute.typeToString(this) + " != " + Attribute.typeToString(att);
        }
        return null;
    }

    public static String typeToString(Attribute att) {
        return Attribute.typeToString(att.type());
    }

    public static String typeToString(int type) {
        String result;
        switch (type) {
            case 0: {
                result = ARFF_ATTRIBUTE_NUMERIC;
                break;
            }
            case 1: {
                result = "nominal";
                break;
            }
            case 2: {
                result = ARFF_ATTRIBUTE_STRING;
                break;
            }
            case 3: {
                result = ARFF_ATTRIBUTE_DATE;
                break;
            }
            case 4: {
                result = ARFF_ATTRIBUTE_RELATIONAL;
                break;
            }
            default: {
                result = "unknown(" + type + ")";
            }
        }
        return result;
    }

    public static String typeToStringShort(Attribute att) {
        return Attribute.typeToStringShort(att.type());
    }

    public static String typeToStringShort(int type) {
        String result;
        switch (type) {
            case 0: {
                result = "Num";
                break;
            }
            case 1: {
                result = "Nom";
                break;
            }
            case 2: {
                result = "Str";
                break;
            }
            case 3: {
                result = "Dat";
                break;
            }
            case 4: {
                result = "Rel";
                break;
            }
            default: {
                result = "???";
            }
        }
        return result;
    }

    public final int index() {
        return this.m_Index;
    }

    public final int indexOfValue(String value) {
        Integer val;
        if (!this.isNominal() && !this.isString()) {
            return -1;
        }
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - searching uncompressed.");
            }
        }
        if ((val = ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.get(store)) == null) {
            return -1;
        }
        return val;
    }

    public final boolean isNominal() {
        return this.m_Type == 1;
    }

    public final boolean isNumeric() {
        return this.m_Type == 0 || this.m_Type == 3;
    }

    public final boolean isRelationValued() {
        return this.m_Type == 4;
    }

    public final boolean isString() {
        return this.m_Type == 2;
    }

    public final boolean isDate() {
        return this.m_Type == 3;
    }

    public final String name() {
        return this.m_Name;
    }

    public final int numValues() {
        if (!(this.isNominal() || this.isString() || this.isRelationValued())) {
            return 0;
        }
        return ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size();
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_ATTRIBUTE).append(" ").append(Utils.quote(this.m_Name)).append(" ");
        switch (this.m_Type) {
            case 1: {
                text.append('{');
                Enumeration<Object> enu = this.enumerateValues();
                while (enu.hasMoreElements()) {
                    text.append(Utils.quote((String)enu.nextElement()));
                    if (!enu.hasMoreElements()) continue;
                    text.append(',');
                }
                text.append('}');
                text.append(this.weight() != 1.0 ? " {" + this.weight() + "}" : "");
                break;
            }
            case 0: {
                text.append(ARFF_ATTRIBUTE_NUMERIC);
                text.append(this.weight() != 1.0 ? " {" + this.weight() + "}" : "");
                break;
            }
            case 2: {
                text.append(ARFF_ATTRIBUTE_STRING);
                text.append(this.weight() != 1.0 ? " {" + this.weight() + "}" : "");
                break;
            }
            case 3: {
                text.append(ARFF_ATTRIBUTE_DATE).append(" ").append(Utils.quote(((DateAttributeInfo)this.m_AttributeInfo).m_DateFormat.toPattern()));
                text.append(this.weight() != 1.0 ? " {" + this.weight() + "}" : "");
                break;
            }
            case 4: {
                text.append(ARFF_ATTRIBUTE_RELATIONAL);
                text.append(this.weight() != 1.0 ? " {" + this.weight() + "}" : "");
                text.append("\n");
                Enumeration<Attribute> enm = ((RelationalAttributeInfo)this.m_AttributeInfo).m_Header.enumerateAttributes();
                while (enm.hasMoreElements()) {
                    text.append(enm.nextElement()).append("\n");
                }
                text.append(ARFF_END_SUBRELATION).append(" ").append(Utils.quote(this.m_Name));
                break;
            }
            default: {
                text.append("UNKNOWN");
            }
        }
        return text.toString();
    }

    public final int type() {
        return this.m_Type;
    }

    public final String getDateFormat() {
        if (this.isDate()) {
            return ((DateAttributeInfo)this.m_AttributeInfo).m_DateFormat.toPattern();
        }
        return "";
    }

    public final String value(int valIndex) {
        if (!this.isNominal() && !this.isString()) {
            return "";
        }
        Object val = ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.get(valIndex);
        if (val instanceof SerializedObject) {
            val = ((SerializedObject)val).getObject();
        }
        return (String)val;
    }

    public final Instances relation() {
        if (!this.isRelationValued()) {
            return null;
        }
        return ((RelationalAttributeInfo)this.m_AttributeInfo).m_Header;
    }

    public final Instances relation(int valIndex) {
        if (!this.isRelationValued()) {
            return null;
        }
        return (Instances)((RelationalAttributeInfo)this.m_AttributeInfo).m_Values.get(valIndex);
    }

    public Attribute(String attributeName, int index) {
        this(attributeName);
        this.m_Index = index;
    }

    public Attribute(String attributeName, String dateFormat, int index) {
        this(attributeName, dateFormat);
        this.m_Index = index;
    }

    public Attribute(String attributeName, List<String> attributeValues, int index) {
        this(attributeName, attributeValues);
        this.m_Index = index;
    }

    public Attribute(String attributeName, Instances header, int index) {
        this(attributeName, header);
        this.m_Index = index;
    }

    public int addStringValue(String value) {
        Integer index;
        if (!this.isString()) {
            return -1;
        }
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        if ((index = ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.get(store)) != null) {
            return index;
        }
        int intIndex = ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size();
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.add(store);
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.put(store, new Integer(intIndex));
        return intIndex;
    }

    public void setStringValue(String value) {
        if (!this.isString()) {
            return;
        }
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.clear();
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.clear();
        if (value != null) {
            this.addStringValue(value);
        }
    }

    public int addStringValue(Attribute src, int index) {
        if (!this.isString()) {
            return -1;
        }
        Object store = ((NominalAttributeInfo)src.m_AttributeInfo).m_Values.get(index);
        Integer oldIndex = ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.get(store);
        if (oldIndex != null) {
            return oldIndex;
        }
        int intIndex = ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size();
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.add(store);
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.put(store, new Integer(intIndex));
        return intIndex;
    }

    public int addRelation(Instances value) {
        if (!this.isRelationValued()) {
            return -1;
        }
        if (!((RelationalAttributeInfo)this.m_AttributeInfo).m_Header.equalHeaders(value)) {
            throw new IllegalArgumentException("Incompatible value for relation-valued attribute.\n" + ((RelationalAttributeInfo)this.m_AttributeInfo).m_Header.equalHeadersMsg(value));
        }
        Integer index = ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.get(value);
        if (index != null) {
            return index;
        }
        int intIndex = ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size();
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.add(value);
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.put(value, new Integer(intIndex));
        return intIndex;
    }

    final void addValue(String value) {
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values = (ArrayList)Utils.cast(((NominalAttributeInfo)this.m_AttributeInfo).m_Values.clone());
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable = (Hashtable)Utils.cast(((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.clone());
        this.forceAddValue(value);
    }

    public final Attribute copy(String newName) {
        Attribute copy = new Attribute(newName);
        copy.m_Index = this.m_Index;
        copy.m_Type = this.m_Type;
        copy.m_AttributeInfo = this.m_AttributeInfo;
        copy.m_AttributeMetaInfo = this.m_AttributeMetaInfo;
        copy.m_Weight = this.m_Weight;
        return copy;
    }

    final void delete(int index) {
        if (!(this.isNominal() || this.isString() || this.isRelationValued())) {
            throw new IllegalArgumentException("Can only remove value of nominal, string or relation- valued attribute!");
        }
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values = (ArrayList)Utils.cast(((NominalAttributeInfo)this.m_AttributeInfo).m_Values.clone());
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.remove(index);
        if (!this.isRelationValued()) {
            Hashtable<Object, Integer> hash = new Hashtable<Object, Integer>(((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.size());
            Enumeration<Object> enu = ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.keys();
            while (enu.hasMoreElements()) {
                Object string = enu.nextElement();
                Integer valIndexObject = ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.get(string);
                int valIndex = valIndexObject;
                if (valIndex > index) {
                    hash.put(string, new Integer(valIndex - 1));
                    continue;
                }
                if (valIndex >= index) continue;
                hash.put(string, valIndexObject);
            }
            ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable = hash;
        }
    }

    final void forceAddValue(String value) {
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.add(store);
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.put(store, new Integer(((NominalAttributeInfo)this.m_AttributeInfo).m_Values.size() - 1));
    }

    final void setIndex(int index) {
        this.m_Index = index;
    }

    final void setValue(int index, String string) {
        switch (this.m_Type) {
            case 1: 
            case 2: {
                ((NominalAttributeInfo)this.m_AttributeInfo).m_Values = (ArrayList)Utils.cast(((NominalAttributeInfo)this.m_AttributeInfo).m_Values.clone());
                ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable = (Hashtable)Utils.cast(((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.clone());
                Object store = string;
                if (string.length() > 200) {
                    try {
                        store = new SerializedObject(string, true);
                    }
                    catch (Exception ex) {
                        System.err.println("Couldn't compress string attribute value - storing uncompressed.");
                    }
                }
                ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.remove(((NominalAttributeInfo)this.m_AttributeInfo).m_Values.get(index));
                ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.set(index, store);
                ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.put(store, new Integer(index));
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only set values for nominal or string attributes!");
            }
        }
    }

    final void setValue(int index, Instances data) {
        if (this.isRelationValued()) {
            if (!data.equalHeaders(((RelationalAttributeInfo)this.m_AttributeInfo).m_Header)) {
                throw new IllegalArgumentException("Can't set relational value. Headers not compatible.\n" + data.equalHeadersMsg(((RelationalAttributeInfo)this.m_AttributeInfo).m_Header));
            }
        } else {
            throw new IllegalArgumentException("Can only set value for relation-valued attributes!");
        }
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values = (ArrayList)Utils.cast(((NominalAttributeInfo)this.m_AttributeInfo).m_Values.clone());
        ((NominalAttributeInfo)this.m_AttributeInfo).m_Values.set(index, data);
    }

    public String formatDate(double date) {
        switch (this.m_Type) {
            case 3: {
                return ((DateAttributeInfo)this.m_AttributeInfo).m_DateFormat.format(new Date((long)date));
            }
        }
        throw new IllegalArgumentException("Can only format date values for date attributes!");
    }

    public double parseDate(String string) throws ParseException {
        switch (this.m_Type) {
            case 3: {
                long time = ((DateAttributeInfo)this.m_AttributeInfo).m_DateFormat.parse(string).getTime();
                return time;
            }
        }
        throw new IllegalArgumentException("Can only parse date values for date attributes!");
    }

    public final ProtectedProperties getMetadata() {
        if (this.m_AttributeMetaInfo == null) {
            return null;
        }
        return this.m_AttributeMetaInfo.m_Metadata;
    }

    public final int ordering() {
        if (this.m_AttributeMetaInfo == null) {
            return 1;
        }
        return this.m_AttributeMetaInfo.m_Ordering;
    }

    public final boolean isRegular() {
        if (this.m_AttributeMetaInfo == null) {
            return true;
        }
        return this.m_AttributeMetaInfo.m_IsRegular;
    }

    public final boolean isAveragable() {
        if (this.m_AttributeMetaInfo == null) {
            return true;
        }
        return this.m_AttributeMetaInfo.m_IsAveragable;
    }

    public final boolean hasZeropoint() {
        if (this.m_AttributeMetaInfo == null) {
            return true;
        }
        return this.m_AttributeMetaInfo.m_HasZeropoint;
    }

    public final double weight() {
        return this.m_Weight;
    }

    public void setWeight(double value) {
        this.m_Weight = value;
    }

    public final double getLowerNumericBound() {
        if (this.m_AttributeMetaInfo == null) {
            return -1.7976931348623157E308;
        }
        return this.m_AttributeMetaInfo.m_LowerBound;
    }

    public final boolean lowerNumericBoundIsOpen() {
        if (this.m_AttributeMetaInfo == null) {
            return true;
        }
        return this.m_AttributeMetaInfo.m_LowerBoundIsOpen;
    }

    public final double getUpperNumericBound() {
        if (this.m_AttributeMetaInfo == null) {
            return Double.MAX_VALUE;
        }
        return this.m_AttributeMetaInfo.m_UpperBound;
    }

    public final boolean upperNumericBoundIsOpen() {
        if (this.m_AttributeMetaInfo == null) {
            return true;
        }
        return this.m_AttributeMetaInfo.m_UpperBoundIsOpen;
    }

    public final boolean isInRange(double value) {
        if (this.m_Type == 3 || Utils.isMissingValue(value)) {
            return true;
        }
        if (this.m_Type != 0) {
            int intVal = (int)value;
            if (intVal < 0 || intVal >= ((NominalAttributeInfo)this.m_AttributeInfo).m_Hashtable.size()) {
                return false;
            }
        } else {
            if (this.m_AttributeMetaInfo == null) {
                return true;
            }
            if (this.m_AttributeMetaInfo.m_LowerBoundIsOpen ? value <= this.m_AttributeMetaInfo.m_LowerBound : value < this.m_AttributeMetaInfo.m_LowerBound) {
                return false;
            }
            if (this.m_AttributeMetaInfo.m_UpperBoundIsOpen ? value >= this.m_AttributeMetaInfo.m_UpperBound : value > this.m_AttributeMetaInfo.m_UpperBound) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public static void main(String[] ops) {
        try {
            new Attribute("length");
            Attribute weight = new Attribute("weight");
            Attribute date = new Attribute(ARFF_ATTRIBUTE_DATE, "yyyy-MM-dd HH:mm:ss");
            System.out.println(date);
            double dd = date.parseDate("2001-04-04 14:13:55");
            System.out.println("Test date = " + dd);
            System.out.println(date.formatDate(dd));
            dd = new Date().getTime();
            System.out.println("Date now = " + dd);
            System.out.println(date.formatDate(dd));
            ArrayList<String> my_nominal_values = new ArrayList<String>(3);
            my_nominal_values.add("first");
            my_nominal_values.add("second");
            my_nominal_values.add("third");
            Attribute position = new Attribute("position", my_nominal_values);
            System.out.println("Name of \"position\": " + position.name());
            Enumeration<Object> attValues = position.enumerateValues();
            while (attValues.hasMoreElements()) {
                String string = (String)attValues.nextElement();
                System.out.println("Value of \"position\": " + string);
            }
            Attribute copy = (Attribute)position.copy();
            System.out.println("Copy is the same as original: " + copy.equals(position));
            System.out.println("Index of attribute \"weight\" (should be -1): " + weight.index());
            System.out.println("Index of value \"first\" of \"position\" (should be 0): " + position.indexOfValue("first"));
            System.out.println("\"position\" is numeric: " + position.isNumeric());
            System.out.println("\"position\" is nominal: " + position.isNominal());
            System.out.println("\"position\" is string: " + position.isString());
            System.out.println("Name of \"position\": " + position.name());
            System.out.println("Number of values for \"position\": " + position.numValues());
            for (int i = 0; i < position.numValues(); ++i) {
                System.out.println("Value " + i + ": " + position.value(i));
            }
            System.out.println(position);
            switch (position.type()) {
                case 0: {
                    System.out.println("\"position\" is numeric");
                    break;
                }
                case 1: {
                    System.out.println("\"position\" is nominal");
                    break;
                }
                case 2: {
                    System.out.println("\"position\" is string");
                    break;
                }
                case 3: {
                    System.out.println("\"position\" is date");
                    break;
                }
                case 4: {
                    System.out.println("\"position\" is relation-valued");
                    break;
                }
                default: {
                    System.out.println("\"position\" has unknown type");
                }
            }
            ArrayList<Attribute> atts = new ArrayList<Attribute>(1);
            atts.add(position);
            Instances relation = new Instances("Test", atts, 0);
            Attribute relationValuedAtt = new Attribute("test", relation);
            System.out.println(relationValuedAtt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

