/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmDeviceList;
import javax.microedition.lcdui.ScmImage;
import javax.microedition.lcdui.ScmTextComponent;
import javax.microedition.lcdui.Screen;

public class Alert
extends Screen {
    public static final Command DISMISS_COMMAND = new Command("OK", 4, -9999);
    public static final int FOREVER = -2;
    private int timeout;
    private AlertType type;
    private ScmTextComponent text = new ScmTextComponent(null, "alert", false);
    private ScmDeviceList lst = new ScmDeviceList(this);
    private ScmImage image = new ScmImage(null, null, 3);
    private Thread terminator;
    private Gauge indicator;
    Displayable next;

    public Alert(String title, String alertText, Image image, AlertType type) {
        this(title);
        this.text.constraints = 131072;
        this.setString(alertText);
        this.image.image = image;
        this.image.invalidate();
        this.type = type;
    }

    public Alert(String title) {
        super(title);
        this.lst.add(this.image);
        this.lst.add(this.text);
        this.container.setMain(this.lst, true);
        super.addCommand(DISMISS_COMMAND);
    }

    void handleCommand(Command cmd, Item item) {
        if (cmd == DISMISS_COMMAND) {
            this.terminator = null;
            if (this.next != null) {
                this.display.setCurrent(this.next);
                this.next = null;
            }
        } else {
            super.handleCommand(cmd, item);
        }
    }

    public Image getImage() {
        return this.image.image;
    }

    public Gauge getIndicator() {
        return this.indicator;
    }

    public String getString() {
        return this.text.getText();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getDefaultTimeout() {
        return -2;
    }

    public void setTimeout(int time) {
        this.timeout = time;
        if (this.timeout != -2) {
            this.terminator = new Thread(){

                public void run() {
                    try {
                        1.sleep(Alert.this.timeout);
                        if (Alert.this.terminator == this) {
                            Alert.this.handleCommand(DISMISS_COMMAND, null);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.terminator.start();
        } else {
            this.terminator = null;
        }
    }

    public void setImage(Image image) {
        this.image.image = image;
        this.image.invalidate();
        this.lst.doLayout();
    }

    public void setIndicator(Gauge indicator) {
        this.indicator = indicator;
    }

    public void setString(String text) {
        this.text.setText(text);
        this.text.invalidate();
        this.lst.doLayout();
    }

    public void setType(AlertType type) {
        this.type = type;
    }

    public void addCommand(Command cmd) {
        this.removeCommand(DISMISS_COMMAND);
        super.addCommand(cmd);
    }

    public AlertType getType() {
        return this.type;
    }

    public void _showNotify() {
        this.lst.doLayout();
        this.text.requestFocus();
    }
}

