/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.SwingMEWrapper;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.me4se.ME4SEPanel;
import net.yura.mobile.gui.components.Label;

public class LobbyTab
extends ME4SEPanel
implements SwingGUITab,
ActionListener {
    ResourceBundle resb = TranslationBundle.getBundle();
    MiniLobbyClient mlc;
    Risk risk;
    JToolBar toolbar;
    JButton start;
    JButton stop;

    public LobbyTab(Risk myrisk) {
        this.getApplicationManager().applet = RiskUIUtil.applet;
        this.risk = myrisk;
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        this.start = new JButton("Start Lobby");
        this.start.setActionCommand("start");
        this.start.addActionListener(this);
        this.toolbar.add(this.start);
        this.stop = new JButton("Stop Lobby");
        this.stop.setActionCommand("stop");
        this.stop.addActionListener(this);
        this.toolbar.add(this.stop);
        this.updateButton();
        this.add((net.yura.mobile.gui.components.Component)new Label("click start in the toolbar"));
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("start".equals(action)) {
            this.createLobby();
            this.updateButton();
        } else {
            this.closeLobby();
            this.updateButton();
        }
    }

    private void updateButton() {
        this.start.setEnabled(this.mlc == null);
        this.stop.setEnabled(this.mlc != null);
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    public String getName() {
        return this.resb.getString("swing.tab.online");
    }

    void createLobby() {
        this.mlc = SwingMEWrapper.makeMiniLobbyClient(this.risk, SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.mlc.removeBackButton();
        this.add((net.yura.mobile.gui.components.Component)this.mlc.getRoot());
    }

    void closeLobby() {
        this.mlc.destroy();
        this.mlc = null;
        this.add((net.yura.mobile.gui.components.Component)new Label("no lobby"));
    }
}

