/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.ArtifactCollectionInternal;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.provider.BuildableBackedProvider;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueFactory;

public class DefaultArtifactCollection
implements ArtifactCollectionInternal {
    private final ResolutionBackedFileCollection fileCollection;
    private final boolean lenient;
    private final CalculatedValue<ArtifactSetResult> result;

    public DefaultArtifactCollection(ResolutionBackedFileCollection files, boolean lenient, ResolutionHost resolutionHost, CalculatedValueFactory calculatedValueFactory) {
        this.fileCollection = files;
        this.lenient = lenient;
        this.result = calculatedValueFactory.create(resolutionHost.displayName("files"), () -> {
            ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor();
            this.fileCollection.getSelectedArtifacts().visitArtifacts(visitor, lenient);
            Set<ResolvedArtifactResult> artifactResults = visitor.getArtifacts();
            Set<Throwable> failures = visitor.getFailures();
            if (!lenient) {
                resolutionHost.rethrowFailure("artifacts", failures);
            }
            return new ArtifactSetResult(artifactResults, failures);
        });
    }

    @Override
    public ResolutionHost getResolutionHost() {
        return this.fileCollection.getResolutionHost();
    }

    @Override
    public boolean isLenient() {
        return this.lenient;
    }

    public FileCollection getArtifactFiles() {
        return this.fileCollection;
    }

    public Set<ResolvedArtifactResult> getArtifacts() {
        this.ensureResolved();
        return ((ArtifactSetResult)this.result.get()).artifactResults;
    }

    public Provider<Set<ResolvedArtifactResult>> getResolvedArtifacts() {
        return new BuildableBackedProvider((Buildable)((FileCollectionInternal)this.getArtifactFiles()), (Class)Cast.uncheckedCast(Set.class), (Factory)new ArtifactCollectionResolvedArtifactsFactory(this));
    }

    public Iterator<ResolvedArtifactResult> iterator() {
        this.ensureResolved();
        return ((ArtifactSetResult)this.result.get()).artifactResults.iterator();
    }

    public Collection<Throwable> getFailures() {
        this.ensureResolved();
        return ((ArtifactSetResult)this.result.get()).failures;
    }

    @Override
    public void visitArtifacts(ArtifactVisitor visitor) {
        this.fileCollection.getSelectedArtifacts().visitArtifacts(visitor, this.lenient);
    }

    private void ensureResolved() {
        this.result.finalizeIfNotAlready();
    }

    private static class ArtifactCollectionResolvedArtifactsFactory
    implements Factory<Set<ResolvedArtifactResult>> {
        private final ArtifactCollection artifactCollection;

        private ArtifactCollectionResolvedArtifactsFactory(ArtifactCollection artifactCollection) {
            this.artifactCollection = artifactCollection;
        }

        public Set<ResolvedArtifactResult> create() {
            return this.artifactCollection.getArtifacts();
        }
    }

    private static class ArtifactSetResult {
        private final Set<ResolvedArtifactResult> artifactResults;
        private final Set<Throwable> failures;

        ArtifactSetResult(Set<ResolvedArtifactResult> artifactResults, Set<Throwable> failures) {
            this.artifactResults = artifactResults;
            this.failures = failures;
        }
    }
}

