/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;

public class ImmutableCapabilities {
    public static final ImmutableCapabilities EMPTY = new ImmutableCapabilities((ImmutableSet<ImmutableCapability>)ImmutableSet.of());
    private final ImmutableSet<ImmutableCapability> capabilities;

    public ImmutableCapabilities(ImmutableSet<ImmutableCapability> capabilities) {
        this.capabilities = capabilities;
    }

    public static ImmutableCapabilities of(@Nullable Capability capability) {
        if (capability == null) {
            return EMPTY;
        }
        return new ImmutableCapabilities((ImmutableSet<ImmutableCapability>)ImmutableSet.of((Object)ImmutableCapabilities.asImmutable(capability)));
    }

    public static ImmutableCapabilities of(@Nullable Collection<? extends Capability> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return EMPTY;
        }
        if (capabilities.size() == 1) {
            Capability single = capabilities.iterator().next();
            return ImmutableCapabilities.of(single);
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)capabilities.size());
        for (Capability capability : capabilities) {
            builder.add((Object)ImmutableCapabilities.asImmutable(capability));
        }
        return new ImmutableCapabilities((ImmutableSet<ImmutableCapability>)builder.build());
    }

    private static ImmutableCapability asImmutable(Capability capability) {
        if (capability instanceof ImmutableCapability) {
            return (ImmutableCapability)capability;
        }
        return new DefaultImmutableCapability(capability.getGroup(), capability.getName(), capability.getVersion());
    }

    public ImmutableSet<ImmutableCapability> asSet() {
        return this.capabilities;
    }

    public ImmutableCapabilities orElse(ImmutableCapability defaultCapability) {
        if (this.capabilities.isEmpty()) {
            return ImmutableCapabilities.of((Capability)defaultCapability);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCapabilities that = (ImmutableCapabilities)o;
        return this.capabilities.equals(that.capabilities);
    }

    public int hashCode() {
        return this.capabilities.hashCode();
    }
}

