/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.AggregatedReplStageState;
import org.jetbrains.kotlin.cli.common.repl.Evaluable;
import org.jetbrains.kotlin.cli.common.repl.GenericReplCompilingEvaluatorKt;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.InvokeWrapper;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCompilerWithoutCheck;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ReplFullEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ScriptArgsWithTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001!B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J4\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00172\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J0\u0010\u001e\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompilingEvaluatorBase;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplFullEvaluator;", "compiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompilerWithoutCheck;", "evaluator", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;", "fallbackScriptArgs", "Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplCompilerWithoutCheck;Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;)V", "getCompiler", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCompilerWithoutCheck;", "getEvaluator", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;", "compileAndEval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "state", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "scriptArgs", "invokeWrapper", "Lorg/jetbrains/kotlin/cli/common/repl/InvokeWrapper;", "compileToEvaluable", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "Lorg/jetbrains/kotlin/cli/common/repl/Evaluable;", "defaultScriptArgs", "createState", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "eval", "compileResult", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "DelayedEvaluation", "cli-common"})
public class GenericReplCompilingEvaluatorBase
implements ReplFullEvaluator {
    @NotNull
    private final ReplCompilerWithoutCheck compiler;
    @NotNull
    private final ReplEvaluator evaluator;
    @Nullable
    private final ScriptArgsWithTypes fallbackScriptArgs;

    public GenericReplCompilingEvaluatorBase(@NotNull ReplCompilerWithoutCheck compiler, @NotNull ReplEvaluator evaluator, @Nullable ScriptArgsWithTypes fallbackScriptArgs) {
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        this.compiler = compiler;
        this.evaluator = evaluator;
        this.fallbackScriptArgs = fallbackScriptArgs;
    }

    public /* synthetic */ GenericReplCompilingEvaluatorBase(ReplCompilerWithoutCheck replCompilerWithoutCheck, ReplEvaluator replEvaluator, ScriptArgsWithTypes scriptArgsWithTypes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            scriptArgsWithTypes = null;
        }
        this(replCompilerWithoutCheck, replEvaluator, scriptArgsWithTypes);
    }

    @NotNull
    public final ReplCompilerWithoutCheck getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final ReplEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    @NotNull
    public IReplStageState<?> createState(@NotNull ReentrantReadWriteLock lock2) {
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        return new AggregatedReplStageState(this.compiler.createState(lock2), this.evaluator.createState(lock2), lock2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ReplEvalResult compileAndEval(@NotNull IReplStageState<?> state, @NotNull ReplCodeLine codeLine, @Nullable ScriptArgsWithTypes scriptArgs, @Nullable InvokeWrapper invokeWrapper) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)codeLine.getCode())).toString()).length() == 0) {
            return new ReplEvalResult.UnitResult();
        }
        ReentrantReadWriteLock reentrantReadWriteLock = state.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            ReplEvalResult replEvalResult;
            Lock lock2;
            ReplCompileResult compiled;
            boolean bl = false;
            AggregatedReplStageState aggregatedState = state.asState(AggregatedReplStageState.class);
            ReplCompileResult replCompileResult = compiled = this.compiler.compile(state, codeLine);
            if (replCompileResult instanceof ReplCompileResult.Error) {
                int n2;
                AggregatedReplStageState aggregatedReplStageState;
                AggregatedReplStageState $this$compileAndEval_u24lambda_u244_u24lambda_u241 = aggregatedReplStageState = aggregatedState;
                boolean bl2 = false;
                ReentrantReadWriteLock reentrantReadWriteLock2 = $this$compileAndEval_u24lambda_u244_u24lambda_u241.getLock();
                ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock2.readLock();
                int n3 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
                for (int i = 0; i < n3; ++i) {
                    readLock2.unlock();
                }
                lock2 = reentrantReadWriteLock2.writeLock();
                ((ReentrantReadWriteLock.WriteLock)lock2).lock();
                try {
                    boolean bl3 = false;
                    int n4 = n2 = $this$compileAndEval_u24lambda_u244_u24lambda_u241.getState1().getHistory().size() == $this$compileAndEval_u24lambda_u244_u24lambda_u241.getState2().getHistory().size() ? 1 : 0;
                    if (_Assertions.ENABLED && n2 == 0) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    GenericReplCompilingEvaluatorKt.access$adjustHistories($this$compileAndEval_u24lambda_u244_u24lambda_u241);
                    Unit unit2 = Unit.INSTANCE;
                }
                finally {
                    for (n2 = 0; n2 < n3; ++n2) {
                        readLock2.lock();
                    }
                    ((ReentrantReadWriteLock.WriteLock)lock2).unlock();
                }
                replEvalResult = new ReplEvalResult.Error.CompileTime(((ReplCompileResult.Error)compiled).getMessage(), ((ReplCompileResult.Error)compiled).getLocation());
            } else if (replCompileResult instanceof ReplCompileResult.Incomplete) {
                replEvalResult = new ReplEvalResult.Incomplete(((ReplCompileResult.Incomplete)compiled).getMessage());
            } else {
                if (!(replCompileResult instanceof ReplCompileResult.CompiledClasses)) throw new NoWhenBranchMatchedException();
                ReplEvalResult result2 = this.eval(state, (ReplCompileResult.CompiledClasses)compiled, scriptArgs, invokeWrapper);
                ReplEvalResult replEvalResult2 = result2;
                if ((replEvalResult2 instanceof ReplEvalResult.Error ? true : replEvalResult2 instanceof ReplEvalResult.HistoryMismatch) ? true : replEvalResult2 instanceof ReplEvalResult.Incomplete) {
                    int n5;
                    AggregatedReplStageState aggregatedReplStageState;
                    AggregatedReplStageState $this$compileAndEval_u24lambda_u244_u24lambda_u243 = aggregatedReplStageState = aggregatedState;
                    boolean bl4 = false;
                    ReentrantReadWriteLock reentrantReadWriteLock3 = $this$compileAndEval_u24lambda_u244_u24lambda_u243.getLock();
                    lock2 = reentrantReadWriteLock3.readLock();
                    int n6 = reentrantReadWriteLock3.getWriteHoldCount() == 0 ? reentrantReadWriteLock3.getReadHoldCount() : 0;
                    for (int i = 0; i < n6; ++i) {
                        ((ReentrantReadWriteLock.ReadLock)lock2).unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock2 = reentrantReadWriteLock3.writeLock();
                    writeLock2.lock();
                    try {
                        boolean bl5 = false;
                        if ($this$compileAndEval_u24lambda_u244_u24lambda_u243.getState1().getHistory().size() > $this$compileAndEval_u24lambda_u244_u24lambda_u243.getState2().getHistory().size()) {
                            GenericReplCompilingEvaluatorKt.access$adjustHistories($this$compileAndEval_u24lambda_u244_u24lambda_u243);
                            int n7 = n5 = $this$compileAndEval_u24lambda_u244_u24lambda_u243.getState1().getHistory().size() == $this$compileAndEval_u24lambda_u244_u24lambda_u243.getState2().getHistory().size() ? 1 : 0;
                            if (_Assertions.ENABLED && n5 == 0) {
                                String string3 = "Assertion failed";
                                throw new AssertionError((Object)string3);
                            }
                        }
                        Unit unit3 = Unit.INSTANCE;
                    }
                    finally {
                        for (n5 = 0; n5 < n6; ++n5) {
                            ((ReentrantReadWriteLock.ReadLock)lock2).lock();
                        }
                        writeLock2.unlock();
                    }
                    replEvalResult = result2;
                } else {
                    if (!(replEvalResult2 instanceof ReplEvalResult.ValueResult ? true : replEvalResult2 instanceof ReplEvalResult.UnitResult)) throw new NoWhenBranchMatchedException();
                    replEvalResult = result2;
                }
            }
            ReplEvalResult replEvalResult3 = replEvalResult;
            return replEvalResult3;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public ReplEvalResult eval(@NotNull IReplStageState<?> state, @NotNull ReplCompileResult.CompiledClasses compileResult, @Nullable ScriptArgsWithTypes scriptArgs, @Nullable InvokeWrapper invokeWrapper) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)compileResult, (String)"compileResult");
        return this.evaluator.eval(state, compileResult, scriptArgs, invokeWrapper);
    }

    @Override
    @NotNull
    public Pair<ReplCompileResult, Evaluable> compileToEvaluable(@NotNull IReplStageState<?> state, @NotNull ReplCodeLine codeLine, @Nullable ScriptArgsWithTypes defaultScriptArgs) {
        Pair pair;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        ReplCompileResult compiled = this.compiler.compile(state, codeLine);
        if (compiled instanceof ReplCompileResult.CompiledClasses) {
            ReplCompileResult.CompiledClasses compiledClasses = (ReplCompileResult.CompiledClasses)compiled;
            ScriptArgsWithTypes scriptArgsWithTypes = defaultScriptArgs;
            if (scriptArgsWithTypes == null) {
                scriptArgsWithTypes = this.fallbackScriptArgs;
            }
            pair = new Pair((Object)compiled, (Object)new DelayedEvaluation(state, compiledClasses, this.evaluator, scriptArgsWithTypes));
        } else {
            pair = new Pair((Object)compiled, null);
        }
        return pair;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompilingEvaluatorBase$DelayedEvaluation;", "Lorg/jetbrains/kotlin/cli/common/repl/Evaluable;", "state", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "compiledCode", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "evaluator", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;", "defaultScriptArgs", "Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;", "(Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;Lorg/jetbrains/kotlin/cli/common/repl/ScriptArgsWithTypes;)V", "getCompiledCode", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "scriptArgs", "invokeWrapper", "Lorg/jetbrains/kotlin/cli/common/repl/InvokeWrapper;", "cli-common"})
    public static final class DelayedEvaluation
    implements Evaluable {
        @NotNull
        private final IReplStageState<?> state;
        @NotNull
        private final ReplCompileResult.CompiledClasses compiledCode;
        @NotNull
        private final ReplEvaluator evaluator;
        @Nullable
        private final ScriptArgsWithTypes defaultScriptArgs;

        public DelayedEvaluation(@NotNull IReplStageState<?> state, @NotNull ReplCompileResult.CompiledClasses compiledCode, @NotNull ReplEvaluator evaluator, @Nullable ScriptArgsWithTypes defaultScriptArgs) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)compiledCode, (String)"compiledCode");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            this.state = state;
            this.compiledCode = compiledCode;
            this.evaluator = evaluator;
            this.defaultScriptArgs = defaultScriptArgs;
        }

        @Override
        @NotNull
        public ReplCompileResult.CompiledClasses getCompiledCode() {
            return this.compiledCode;
        }

        @Override
        @NotNull
        public ReplEvalResult eval(@Nullable ScriptArgsWithTypes scriptArgs, @Nullable InvokeWrapper invokeWrapper) {
            ReplCompileResult.CompiledClasses compiledClasses = this.getCompiledCode();
            ScriptArgsWithTypes scriptArgsWithTypes = scriptArgs;
            if (scriptArgsWithTypes == null) {
                scriptArgsWithTypes = this.defaultScriptArgs;
            }
            return this.evaluator.eval(this.state, compiledClasses, scriptArgsWithTypes, invokeWrapper);
        }
    }
}

