#******************************************************************************
#
#       Copyright:      2009-2022 Paul Obermeier (obermeier@tcl3d.org)
#
#                       See the file "Tcl3D_License.txt" for information on
#                       usage and redistribution of this file, and for a
#                       DISCLAIMER OF ALL WARRANTIES.
#
#       Module:         Tcl3D -> tcl3dOsg
#       Filename:       tcl3dOsgBitmaps.tcl
#
#       Author:         Paul Obermeier
#
#       Description:    Tcl module with bitmaps specific to
#                       the OSG module.
#
#******************************************************************************

proc tcl3dOsgGetBitmapName { nodeType } {
    set bmpName [format "tcl3dOsgBmp%s" $nodeType]
    if { [info proc $bmpName] ne $bmpName } {
        set bmpName "tcl3dOsgBmpUnknown"
    }
    return $bmpName
}

###############################################################################
#[@e
#       Name:           tcl3dOsgGetBitmap - Get the bitmap image of a node type. 
#
#       Synopsis:       tcl3dOsgGetBitmap { nodeType }
#
#       Description:    Get the bitmap image of a node type.
#                       If the node type is not known or no bitmap is available
#                       yet, a bitmap with a question mark is returned.
#
#       See also:       
#
###############################################################################

proc tcl3dOsgGetBitmap { nodeType } {
    set bmpName [tcl3dOsgGetBitmapName $nodeType]
    set nodeImg [image create bitmap -data [$bmpName]]
    return $nodeImg
}

proc tcl3dOsgBmpNode {} {
return {
#define osgNode_width 16
#define osgNode_height 16
static char osgNode_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xe0, 0x07,
  0x10, 0x08,
  0x10, 0x08,
  0x08, 0x10,
  0x08, 0x10,
  0x08, 0x10,
  0x08, 0x10,
  0x10, 0x08,
  0x10, 0x08,
  0xe0, 0x07,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00};
}
} ; # End of proc ::poBmpData::osgNode

proc tcl3dOsgBmpUnknown {} {
return {
#define osgUnknown_width 16
#define osgUnknown_height 16
static char osgUnknown_bits[] = {
  0x80, 0x01,
  0x40, 0x02,
  0x20, 0x04,
  0x00, 0x04,
  0x00, 0x04,
  0x00, 0x02,
  0x80, 0x01,
  0x40, 0x00,
  0x20, 0x00,
  0x20, 0x00,
  0x20, 0x04,
  0x40, 0x02,
  0x80, 0x01,
  0x00, 0x00,
  0x80, 0x01,
  0x80, 0x01};
}
}

proc tcl3dOsgBmpDOFTransform {} {
return {
#define osgDOF_width 16
#define osgDOF_height 16
static char osgDOF_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x80, 0x00,
  0xc0, 0x01,
  0x80, 0x00,
  0x80, 0x00,
  0x80, 0x00,
  0x80, 0x10,
  0x80, 0x3f,
  0x40, 0x10,
  0x20, 0x00,
  0x18, 0x00,
  0x18, 0x00,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpGeode {} {
return {
#define osgGeode_width 16
#define osgGeode_height 16
static char osgGeode_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xf0, 0x3f,
  0x90, 0x24,
  0x90, 0x24,
  0x90, 0x24,
  0x90, 0x24,
  0xf0, 0x3f,
  0x90, 0x24,
  0x90, 0x24,
  0x90, 0x24,
  0xf0, 0x3f,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpGroup {} {
return {
#define osgGroup_width 16
#define osgGroup_height 16
static char osgGroup_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0xe0, 0x07,
  0x20, 0x04,
  0xe0, 0x07,
  0x80, 0x01,
  0x80, 0x01,
  0xf8, 0x1f,
  0x18, 0x18,
  0x18, 0x18,
  0x18, 0x18,
  0x7e, 0x7e,
  0x42, 0x42,
  0x7e, 0x7e,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpLOD {} {
return {
#define osgLOD_width 16
#define osgLOD_height 16
static char osgLOD_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x7e,
  0x00, 0x42,
  0x00, 0x42,
  0x7e, 0x42,
  0x42, 0x42,
  0x7e, 0x7e,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpPagedLOD {} {
return {
#define osgPagedLOD_width 16
#define osgPagedLOD_height 16
static char osgPagedLOD_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0x1e, 0x00,
  0x12, 0x00,
  0x12, 0x00,
  0x1e, 0x00,
  0x02, 0x00,
  0x02, 0x00,
  0x02, 0x7e,
  0x00, 0x42,
  0x00, 0x42,
  0x7e, 0x42,
  0x42, 0x42,
  0x7e, 0x7e,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpMatrixTransform {} {
return {
#define osgMatrixTransform_width 16
#define osgMatrixTransform_height 16
static char osgMatrixTransform_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x40, 0x08,
  0x20, 0x10,
  0x90, 0x24,
  0x90, 0x24,
  0x10, 0x20,
  0x10, 0x20,
  0x90, 0x24,
  0x90, 0x24,
  0x20, 0x10,
  0x40, 0x08,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpModularEmitter {} {
return {
#define osgModularEmitter_width 16
#define osgModularEmitter_height 16
static char osgModularEmitter_bits[] = {
  0x00, 0x00,
  0x20, 0x09,
  0x20, 0x05,
  0x50, 0x29,
  0x50, 0x28,
  0xa0, 0x14,
  0xa0, 0x12,
  0x40, 0x0b,
  0x40, 0x08,
  0x80, 0x04,
  0x80, 0x04,
  0x00, 0x03,
  0x00, 0x03,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00};
}
}

proc tcl3dOsgBmpMultiSwitch {} {
return {
#define osgSwitch_width 16
#define osgSwitch_height 16
static char osgSwitch_bits[] = {
  0x00, 0x00,
  0x00, 0x00,
  0xe0, 0x07,
  0x20, 0x04,
  0xe0, 0x07,
  0x80, 0x01,
  0x80, 0x01,
  0x90, 0x1f,
  0x10, 0x10,
  0x18, 0x18,
  0x18, 0x18,
  0x7e, 0x7e,
  0x42, 0x42,
  0x7e, 0x7e,
  0x00, 0x00,
  0x00, 0x00};
}
}
