/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ResourceBundleSupport {
    private static final Log logger = LogFactory.getLog(ResourceBundleSupport.class);
    private ResourceBundle resources;
    private HashMap cache;
    private HashSet lookupPath;
    private String resourceBase;
    private Locale locale;

    public ResourceBundleSupport(Locale locale, String baseName) {
        this(locale, ResourceBundle.getBundle(baseName, locale), baseName);
    }

    protected ResourceBundleSupport(Locale locale, ResourceBundle resourceBundle, String baseName) {
        if (locale == null) {
            throw new NullPointerException("Locale must not be null");
        }
        if (resourceBundle == null) {
            throw new NullPointerException("Resources must not be null");
        }
        if (baseName == null) {
            throw new NullPointerException("BaseName must not be null");
        }
        this.locale = locale;
        this.resources = resourceBundle;
        this.resourceBase = baseName;
        this.cache = new HashMap();
        this.lookupPath = new HashSet();
    }

    public ResourceBundleSupport(Locale locale, ResourceBundle resourceBundle) {
        this(locale, resourceBundle, resourceBundle.toString());
    }

    public ResourceBundleSupport(String baseName) {
        this(Locale.getDefault(), ResourceBundle.getBundle(baseName), baseName);
    }

    protected ResourceBundleSupport(ResourceBundle resourceBundle, String baseName) {
        this(Locale.getDefault(), resourceBundle, baseName);
    }

    public ResourceBundleSupport(ResourceBundle resourceBundle) {
        this(Locale.getDefault(), resourceBundle, resourceBundle.toString());
    }

    protected final String getResourceBase() {
        return this.resourceBase;
    }

    public synchronized String strictString(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String retval = (String)this.cache.get(key);
        if (retval != null) {
            return retval;
        }
        this.lookupPath.clear();
        return this.internalGetString(key);
    }

    protected String internalGetString(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.lookupPath.contains(key)) {
            throw new MissingResourceException("InfiniteLoop in resource lookup", this.getResourceBase(), this.lookupPath.toString());
        }
        String fromResBundle = this.resources.getString(key);
        if (fromResBundle.length() > 0 && fromResBundle.charAt(0) == '@') {
            if (fromResBundle.length() > 1 && fromResBundle.charAt(1) == '@') {
                int idx = fromResBundle.indexOf(64, 2);
                if (idx == -1) {
                    throw new MissingResourceException("Invalid format for global lookup key.", this.getResourceBase(), key);
                }
                try {
                    ResourceBundle res = ResourceBundle.getBundle(fromResBundle.substring(2, idx));
                    return res.getString(fromResBundle.substring(idx + 1));
                }
                catch (Exception e) {
                    logger.error((Object)"Error during global lookup", (Throwable)e);
                    throw new MissingResourceException("Error during global lookup", this.getResourceBase(), key);
                }
            }
            String newKey = fromResBundle.substring(1);
            this.lookupPath.add(key);
            String retval = this.internalGetString(newKey);
            this.cache.put(key, retval);
            return retval;
        }
        this.cache.put(key, fromResBundle);
        return fromResBundle;
    }

    public Icon getIcon(String key, boolean large) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        return this.createIcon(name, true, large);
    }

    public Icon getIcon(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        return this.createIcon(name, false, false);
    }

    public Integer getMnemonic(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        return this.createMnemonic(name);
    }

    public Integer getOptionalMnemonic(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        if (name != null && name.length() > 0) {
            return this.createMnemonic(name);
        }
        return null;
    }

    public KeyStroke getKeyStroke(String key) {
        String name = this.strictString(key);
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        int mask = 0;
        StringTokenizer strtok = new StringTokenizer(name);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if ("shift".equals(token)) {
                mask |= 1;
                continue;
            }
            if ("alt".equals(token)) {
                mask |= 8;
                continue;
            }
            if ("ctrl".equals(token)) {
                mask |= 2;
                continue;
            }
            if ("meta".equals(token)) {
                mask |= 4;
                continue;
            }
            if ("menu".equals(token)) {
                mask |= this.getMenuKeyMask();
                continue;
            }
            name = token;
        }
        if (mask == 0) {
            mask = this.getMenuKeyMask();
        }
        return KeyStroke.getKeyStroke(this.createMnemonic(name), mask);
    }

    public KeyStroke getOptionalKeyStroke(String key) {
        try {
            String name = this.strictString(key);
            if (StringUtils.isEmpty(name)) {
                return null;
            }
            int mask = 0;
            StringTokenizer strtok = new StringTokenizer(name);
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if ("shift".equals(token)) {
                    mask |= 1;
                    continue;
                }
                if ("alt".equals(token)) {
                    mask |= 8;
                    continue;
                }
                if ("ctrl".equals(token)) {
                    mask |= 2;
                    continue;
                }
                if ("meta".equals(token)) {
                    mask |= 4;
                    continue;
                }
                if ("menu".equals(token)) {
                    mask |= this.getMenuKeyMask();
                    continue;
                }
                name = token;
            }
            if (mask == 0) {
                mask = this.getMenuKeyMask();
            }
            return KeyStroke.getKeyStroke(this.createMnemonic(name), mask);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public KeyStroke getKeyStroke(String key, int mask) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        return KeyStroke.getKeyStroke(this.createMnemonic(name), mask);
    }

    public KeyStroke getOptionalKeyStroke(String key, int mask) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        if (name != null && name.length() > 0) {
            return KeyStroke.getKeyStroke(this.createMnemonic(name), mask);
        }
        return null;
    }

    public JMenu createMenu(String keyPrefix) {
        if (keyPrefix == null) {
            throw new NullPointerException();
        }
        JMenu retval = new JMenu();
        retval.setText(this.strictString(keyPrefix + ".name"));
        Integer mnemonic = this.getOptionalMnemonic(keyPrefix + ".mnemonic");
        if (mnemonic != null) {
            retval.setMnemonic(mnemonic);
        }
        return retval;
    }

    public URL getResourceURL(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String name = this.strictString(key);
        URL in = ObjectUtilities.getResource(name, ResourceBundleSupport.class);
        if (in == null) {
            logger.warn((Object)("Unable to find file in the class path: " + name + "; key=" + key));
        }
        return in;
    }

    private ImageIcon createIcon(String resourceName, boolean scale, boolean large) {
        URL in = ObjectUtilities.getResource(resourceName, ResourceBundleSupport.class);
        if (in == null) {
            logger.warn((Object)("Unable to find file in the class path: " + resourceName));
            return new ImageIcon(this.createTransparentImage(1, 1));
        }
        Image img = Toolkit.getDefaultToolkit().createImage(in);
        if (img == null) {
            logger.warn((Object)("Unable to instantiate the image: " + resourceName));
            return new ImageIcon(this.createTransparentImage(1, 1));
        }
        if (scale) {
            if (large) {
                return new ImageIcon(img.getScaledInstance(24, 24, 4));
            }
            return new ImageIcon(img.getScaledInstance(16, 16, 4));
        }
        return new ImageIcon(img);
    }

    private Integer createMnemonic(String keyString) {
        if (keyString == null) {
            throw new NullPointerException("Key is null.");
        }
        if (keyString.length() == 0) {
            throw new IllegalArgumentException("Key is empty.");
        }
        int character = keyString.charAt(0);
        if (keyString.startsWith("VK_")) {
            try {
                Field f = KeyEvent.class.getField(keyString);
                Integer keyCode = (Integer)f.get(null);
                character = keyCode;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Integer(character);
    }

    private int getMenuKeyMask() {
        try {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (UnsupportedOperationException he) {
            return 2;
        }
    }

    private BufferedImage createTransparentImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] data = img.getRGB(0, 0, width, height, null, 0, width);
        img.setRGB(0, 0, width, height, data, 0, width);
        return img;
    }

    public String formatMessage(String key, Object parameter) {
        return this.formatMessage(key, new Object[]{parameter});
    }

    public String formatMessage(String key, Object par1, Object par2) {
        return this.formatMessage(key, new Object[]{par1, par2});
    }

    public String formatMessage(String key, Object[] parameters) {
        MessageFormat format = new MessageFormat(this.strictString(key));
        format.setLocale(this.getLocale());
        return format.format(parameters);
    }

    public String getString(String key, Object[] parameters) {
        try {
            return this.formatMessage(key, parameters);
        }
        catch (MissingResourceException mre) {
            logger.warn((Object)"ResourceBundleSupport#getString(,,)", (Throwable)mre);
            return '!' + key + '!';
        }
    }

    public String getString(String key) {
        try {
            return this.strictString(key);
        }
        catch (MissingResourceException mre) {
            logger.warn((Object)"ResourceBundleSupport#getString(,,)", (Throwable)mre);
            return '!' + key + '!';
        }
    }

    public String getString(String key, Object par1) {
        try {
            return this.formatMessage(key, par1);
        }
        catch (MissingResourceException mre) {
            logger.warn((Object)"ResourceBundleSupport#getString(,,)", (Throwable)mre);
            return '!' + key + '!';
        }
    }

    public String getString(String key, Object par1, Object par2) {
        try {
            return this.formatMessage(key, par1, par2);
        }
        catch (MissingResourceException mre) {
            logger.warn((Object)"ResourceBundleSupport#getString(,,)", (Throwable)mre);
            return '!' + key + '!';
        }
    }

    public Locale getLocale() {
        return this.locale;
    }
}

