/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;

public class MixedGraph<N, E> {
    private Collection<N> nodes;
    private Map<N, Vertex<N>> vertexMap;
    private GraphScene<N, E> scene;
    private UniversalGraph<N, E> uGraph;
    private Collection<E> edges;

    private MixedGraph(UniversalGraph<N, E> universalGraph, GraphScene<N, E> graphScene) {
        this.uGraph = universalGraph;
        this.scene = graphScene;
        this.nodes = universalGraph.getNodes();
        this.edges = universalGraph.getEdges();
        this.vertexMap = new HashMap<N, Vertex<N>>();
    }

    public static <N, E> MixedGraph<N, E> createGraph(UniversalGraph<N, E> universalGraph, GraphScene<N, E> graphScene) {
        MixedGraph<N, E> mixedGraph = new MixedGraph<N, E>(universalGraph, graphScene);
        mixedGraph.createGraph();
        return mixedGraph;
    }

    protected void createGraph() {
        Object object;
        for (Object object2 : this.edges) {
            object = this.uGraph.getEdgeSource(object2);
            N n = this.uGraph.getEdgeTarget(object2);
            Vertex<N> vertex = this.getVertex(object);
            Vertex<N> vertex2 = this.getVertex(n);
            vertex.addUpperNeighbor(vertex2);
            vertex2.addLowerNeighbor(vertex);
            vertex2.addNeighbor(vertex);
        }
        for (Object object2 : this.nodes) {
            object = this.getVertex(object2);
        }
    }

    public Collection<Vertex<N>> getVertices() {
        return this.vertexMap.values();
    }

    private Vertex<N> getVertex(N n) {
        Vertex<N> vertex = this.vertexMap.get(n);
        if (vertex == null) {
            vertex = new Vertex<N>(n);
            this.vertexMap.put(n, vertex);
        }
        return vertex;
    }

    private void printGraph() {
        for (Vertex<N> vertex : this.getVertices()) {
            System.out.println("vertex = " + vertex);
            Collection<Vertex<?>> collection = vertex.getNeighbors();
            for (Vertex<?> vertex2 : collection) {
                System.out.println("\tneighbor = " + vertex2);
            }
        }
    }

    public static class Vertex<N> {
        private N node;
        private ArrayList<Vertex<?>> upperNeighbors;
        private ArrayList<Vertex<?>> lowerNeighbors;
        private ArrayList<Vertex<?>> neighbors;
        private Object vertexData;

        public Vertex(N n) {
            this.node = n;
            this.neighbors = new ArrayList();
        }

        public void addNeighbor(Vertex<?> vertex) {
            this.neighbors.add(vertex);
        }

        public void removeNeighbor(Vertex<?> vertex) {
            this.neighbors.remove(vertex);
        }

        public void addLowerNeighbor(Vertex<?> vertex) {
            if (!this.lowerNeighbors.contains(vertex)) {
                this.lowerNeighbors.add(vertex);
            }
        }

        public void removeLowerNeighbor(Vertex<?> vertex) {
            this.lowerNeighbors.remove(vertex);
        }

        public Collection<Vertex<?>> getLowerNeighbors() {
            return Collections.unmodifiableCollection(this.lowerNeighbors);
        }

        public void addUpperNeighbor(Vertex<?> vertex) {
            if (!this.upperNeighbors.contains(vertex)) {
                this.upperNeighbors.add(vertex);
            }
        }

        public void removeUpperNeighbor(Vertex<?> vertex) {
            this.upperNeighbors.remove(vertex);
        }

        public Collection<Vertex<?>> getUpperNeighbors() {
            return Collections.unmodifiableCollection(this.upperNeighbors);
        }

        public Collection<Vertex<?>> getNeighbors() {
            return this.neighbors;
        }

        public N getNodeDesignElement() {
            return this.node;
        }

        public int getDegree() {
            return this.neighbors.size();
        }

        public void setVertexData(Object object) {
            this.vertexData = object;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return super.toString() + " : " + this.node;
        }
    }
}

