/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.UncheckedException;

public abstract class InternalTransformers {
    public static <O, I> InternalTransformer<O, I> cast(Class<O> outputType) {
        return new CastingTransformer(outputType);
    }

    public static <T> InternalTransformer<T, T> noOpTransformer() {
        return new InternalTransformer<T, T>(){

            @Override
            public T transform(T original) {
                return original;
            }
        };
    }

    public static <T> InternalTransformer<String, T> asString() {
        return new ToStringTransformer();
    }

    public static InternalTransformer<String, String> asSafeCommandLineArgument() {
        return new CommandLineArgumentTransformer();
    }

    public static <T> InternalTransformer<Class<T>, T> type() {
        return new InternalTransformer<Class<T>, T>(){

            @Override
            public Class<T> transform(T original) {
                Class<?> aClass = original.getClass();
                return aClass;
            }
        };
    }

    public static <R> InternalTransformer<R, Object> toTransformer(final Factory<R> factory) {
        return new InternalTransformer<R, Object>(){

            @Override
            public R transform(Object original) {
                return factory.create();
            }
        };
    }

    public static InternalTransformer<URL, URI> toURL() {
        return new InternalTransformer<URL, URI>(){

            @Override
            public URL transform(URI original) {
                try {
                    return original.toURL();
                }
                catch (MalformedURLException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        };
    }

    public static <T, I> InternalTransformer<T, I> constant(final T t) {
        return new InternalTransformer<T, I>(){

            @Override
            public T transform(I original) {
                return t;
            }
        };
    }

    private static class CastingTransformer<O, I>
    implements InternalTransformer<O, I> {
        final Class<O> outputType;

        public CastingTransformer(Class<O> outputType) {
            this.outputType = outputType;
        }

        @Override
        public O transform(I input) {
            return Cast.cast(this.outputType, input);
        }
    }

    private static class ToStringTransformer<T>
    implements InternalTransformer<String, T> {
        private ToStringTransformer() {
        }

        @Override
        public String transform(T original) {
            return original == null ? null : original.toString();
        }
    }

    private static class CommandLineArgumentTransformer
    implements InternalTransformer<String, String> {
        private static final Pattern SINGLE_QUOTED = Pattern.compile("^'.*'$");
        private static final Pattern DOUBLE_QUOTED = Pattern.compile("^\".*\"$");
        private static final Pattern A_SINGLE_QUOTE = Pattern.compile("'");

        private CommandLineArgumentTransformer() {
        }

        @Override
        public String transform(String input) {
            if (SINGLE_QUOTED.matcher(input).matches() || DOUBLE_QUOTED.matcher(input).matches() || !input.contains(" ")) {
                return input;
            }
            return this.wrapWithSingleQuotes(input);
        }

        private String wrapWithSingleQuotes(String input) {
            return String.format("'%1$s'", this.escapeSingleQuotes(input));
        }

        private String escapeSingleQuotes(String input) {
            return A_SINGLE_QUOTE.matcher(input).replaceAll("\\\\'");
        }
    }
}

