/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.jstestdriver.annotations.MaxFormContentSize;
import com.google.jstestdriver.annotations.Port;
import com.google.jstestdriver.model.HandlerPathPrefix;
import java.util.Random;
import javax.servlet.Servlet;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.servlet.GzipFilter;

public class JettyModule
extends AbstractModule {
    private final int port;
    private final HandlerPathPrefix handlerPrefix;

    public JettyModule(int port, HandlerPathPrefix handlerPrefix) {
        this.port = port;
        this.handlerPrefix = handlerPrefix;
    }

    protected void configure() {
        this.bindConstant().annotatedWith(Port.class).to(this.port);
        this.bindConstant().annotatedWith(MaxFormContentSize.class).to(Integer.MAX_VALUE);
    }

    @Provides
    @Singleton
    SocketConnector provideSocketConnector(@Port Integer port) {
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        return connector;
    }

    @Provides
    @Singleton
    ServletHolder servletHolder(Servlet handlerServlet) {
        return new ServletHolder(handlerServlet);
    }

    @Provides
    @Singleton
    Server provideJettyServer(SocketConnector connector, @MaxFormContentSize Integer maxFormContentSize, ServletHolder servletHolder) {
        Server server = new Server();
        server.setGracefulShutdown(1);
        server.addConnector(connector);
        server.setSessionIdManager(new HashSessionIdManager(new Random()));
        Context context = new Context(server, "/", 1);
        context.setMaxFormContentSize(maxFormContentSize);
        context.addFilter(GzipFilter.class, this.handlerPrefix.prefixPath("/test/*"), 0);
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/cache"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/capture/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/cmd"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/favicon.ico"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/fileSet"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/forward/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/heartbeat"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/hello"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/proxy/*", "jstd"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/log"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/query/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/runner/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/slave/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/test/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/quit"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/quit/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/static/*"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/bcr"));
        context.addServlet(servletHolder, this.handlerPrefix.prefixPath("/bcr/*"));
        context.addServlet(servletHolder, "/*");
        return server;
    }
}

