/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.jstestdriver.token.Token;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class ConcreteToken
implements Token {
    private final char[] token;

    public static Token from(String token) {
        return new ConcreteToken(token.toCharArray());
    }

    public ConcreteToken(char[] token) {
        this.token = token;
    }

    public Token create(BufferedInputStream stream) {
        try {
            for (int i = 0; i < this.token.length; ++i) {
                char read = (char)stream.read();
                if (this.token[i] == read) continue;
                stream.reset();
                return null;
            }
            stream.mark(Integer.MAX_VALUE);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcreteToken other = (ConcreteToken)obj;
        return !(this.token == null ? other.token != null : !Arrays.equals(this.token, other.token));
    }

    public String toString() {
        return new String(this.token);
    }

    public void write(Writer out) {
        for (char character : this.token) {
            try {
                out.append(character);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean contains(char chr) {
        for (char character : this.token) {
            if (character != chr) continue;
            return true;
        }
        return false;
    }
}

