table altSpliceSite
"Structre to hold information about one splice site in graph."
(
string chrom;                "Reference sequence chromosome or scaffold"
uint chromStart;             "Chrom start."
uint chromEnd;               "End."
string agName;               "Name of altGraphX that edge is from. Memory not owned here."
char[2] strand;              "Strand."
uint index;                  "Index into altGraphX records."
uint type;                   "Type of splice site i.e. ggHardStart,ggHardEnd."
uint altCount;               "Number of alternative ways out of splice site."
uint[altCount] vIndexes;      "Index into altGraphX record for alt vertexes."
uint[altCount] altStarts;    "Chromosome starts of alternative outs."
uint[altCount] altTypes;     "Types of vertexes connecting to."
uint[altCount] spliceTypes;  "Types of of splice sites."
uint[altCount] support;      "Number of mRNAs supporting this edge."
uint[altCount] altBpStarts;  "Start of alternatively spliced base pairs, type independent."
uint[altCount] altBpEnds;    "End of alternatively spliced base pairs, type independent."
float[altCount] altCons;      "Average s-score of altSpilce region."
float[altCount] upStreamCons; "Average s-score 100bp to start of altSpilce."
float[altCount] downStreamCons; "Average s-score 100bp past end of altSpilce."
)
