# altSpliceSite.sql was originally generated by the autoSql program, which also 
# generated altSpliceSite.c and altSpliceSite.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Structre to hold information about one splice site in graph.
CREATE TABLE altSpliceSite (
    chrom varchar(255) not null,	# Chromosome.
    chromStart int unsigned not null,	# Chrom start.
    chromEnd int unsigned not null,	# End.
    agName varchar(255) not null,	# Name of altGraphX that edge is from. Memory not owned here.
    strand char(2) not null,	# Strand.
    index int unsigned not null,	# Index into altGraphX records.
    type int unsigned not null,	# Type of splice site i.e. ggHardStart,ggHardEnd.
    altCount int unsigned not null,	# Number of alternative ways out of splice site.
    vIndexes longblob not null,	# Index into altGraphX record for alt vertexes.
    altStarts longblob not null,	# Chromosome starts of alternative outs.
    altTypes longblob not null,	# Types of vertexes connecting to.
    spliceTypes longblob not null,	# Types of of splice sites.
    support longblob not null,	# Number of mRNAs supporting this edge.
    altBpStarts longblob not null,	# Start of alternatively spliced base pairs, type independent.
    altBpEnds longblob not null,	# End of alternatively spliced base pairs, type independent.
    altCons longblob not null,	# Average s-score of altSpilce region.
    upStreamCons longblob not null,	# Average s-score 100bp to start of altSpilce.
    downStreamCons longblob not null,	# Average s-score 100bp past end of altSpilce.
              #Indices
    PRIMARY KEY(chrom)
);
