/* cartDb.h was originally generated by the autoSql program, which also 
 * generated cartDb.c and cartDb.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CARTDB_H
#define CARTDB_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

struct cartDb
/* A simple id/contents pair for persistent storing of cart variables */
    {
    struct cartDb *next;  /* Next in singly linked list. */
    unsigned int id;	/* Cart ID */
    char *contents;	/* Contents - encoded variables */
    int reserved;	/* Reserved, currently always zero. */
    char *firstUse;	/* First time this was used */
    char *lastUse;	/* Last time this was used */
    int useCount;	/* Number of times used */
    };

void cartDbStaticLoad(char **row, struct cartDb *ret);
/* Load a row from cartDb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cartDb *cartDbLoad(char **row);
/* Load a cartDb from row fetched with select * from cartDb
 * from database.  Dispose of this with cartDbFree(). */

struct cartDb *cartDbLoadAll(char *fileName);
/* Load all cartDb from a tab-separated file.
 * Dispose of this with cartDbFreeList(). */

struct cartDb *cartDbLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all cartDb from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with cartDbFreeList(). */

struct cartDb *cartDbCommaIn(char **pS, struct cartDb *ret);
/* Create a cartDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cartDb */

void cartDbFree(struct cartDb **pEl);
/* Free a single dynamically allocated cartDb such as created
 * with cartDbLoad(). */

void cartDbFreeList(struct cartDb **pList);
/* Free a list of dynamically allocated cartDb's */

void cartDbOutput(struct cartDb *el, FILE *f, char sep, char lastSep);
/* Print out cartDb.  Separate fields with sep. Follow last field with lastSep. */

#define cartDbTabOut(el,f) cartDbOutput(el,f,'\t','\n');
/* Print out cartDb as a line in a tab-separated file. */

#define cartDbCommaOut(el,f) cartDbOutput(el,f,',',',');
/* Print out cartDb as a comma separated list including final comma. */

#endif /* CARTDB_H */

