/* stsMap.h was originally generated by the autoSql program, which also 
 * generated stsMap.c and stsMap.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef STSMAP_H
#define STSMAP_H

#include "stsMarker.h"

struct stsMap
/* STS marker and its position on golden path and various maps */
    {
    struct stsMap *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or 'unknown' */
    int chromStart;	/* Start position in chrom - negative 1 if unpositioned */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of STS marker */
    unsigned score;     /* Score of a marker = 1000/(#placements) when placed uniquely, else 1500/(#placements) when placed in multiple locations */
    unsigned identNo;	/* Identification number of STS */
    char *ctgAcc;	/* Contig accession number */
    char *otherAcc;	/* Accession number of other contigs that the marker hits */
    char *genethonChrom;	/* Chromosome (no chr) from Genethon map or 0 if none */
    float genethonPos;	/* Position on Genethon map */
    char *marshfieldChrom;	/* Chromosome (no chr) from Marshfield map or 0 if none */
    float marshfieldPos;	/* Position on Marshfield map */
    char *gm99Gb4Chrom;	/* Chromosome (no chr) from GeneMap99 map or 0 if none */
    float gm99Gb4Pos;	/* Position on gm99_bg4 map */
    char *shgcTngChrom;	/* Chromosome (no chr) from shgc_tng map or 0 if none */
    float shgcTngPos;	/* Position on shgc_tng map */
    char *shgcG3Chrom;	/* Chromosome (no chr) from Stanford G3 map or 0 if none */
    float shgcG3Pos;	/* Position on shgc_g3 map */
    char *wiYacChrom;	/* Chromosome (no chr) from Whitehead YAC map or 0 if none */
    float wiYacPos;	/* Position on wi_yac map */
    char *wiRhChrom;	/* Chromosome (no chr) from Whitehead RH map or 0 if none */
    float wiRhPos;	/* Position on wi_rh map */
    char *fishChrom;	/* Chromosome (no chr) from FISH map or 0 if none */
    char *beginBand;	/* Beginning of range of bands on FISH map */
    char *endBand;	/* End of range of bands on FISH map */
    char *lab;	/* Laboratory that placed the FISH clone */
    char *decodeChrom;	/* Chromosome (no chr) from deCODE genetic map or 0 if none */
    float decodePos;	/* Position on deCODE genetic map */
    };

void stsMapStaticLoad(char **row, struct stsMap *ret);
/* Load a row from stsMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

void stsMapStaticLoad28(char **row, struct stsMap *ret);
/* Load a row from stsMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct stsMap *stsMapLoad(char **row);
/* Load a stsMap from row fetched with select * from stsMap
 * from database.  Dispose of this with stsMapFree(). */

struct stsMap *stsMapLoad28(char **row);
/* Load a stsMap from row fetched with select * from stsMap
 * from database.  Dispose of this with stsMapFree(). */

struct stsMap *stsMapLoadAll(char *fileName);
/* Load all stsMap from a tab-separated file.
 * Dispose of this with stsMapFreeList(). */

struct stsMap *stsMapCommaIn(char **pS, struct stsMap *ret);
/* Create a stsMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stsMap */

void stsMapFree(struct stsMap **pEl);
/* Free a single dynamically allocated stsMap such as created
 * with stsMapLoad(). */

void stsMapFreeList(struct stsMap **pList);
/* Free a list of dynamically allocated stsMap's */

void stsMapOutput(struct stsMap *el, FILE *f, char sep, char lastSep);
/* Print out stsMap.  Separate fields with sep. Follow last field with lastSep. */

#define stsMapTabOut(el,f) stsMapOutput(el,f,'\t','\n');
/* Print out stsMap as a line in a tab-separated file. */

#define stsMapCommaOut(el,f) stsMapOutput(el,f,',',',');
/* Print out stsMap as a comma separated list including final comma. */

/* ------ End AutoSQL generated Code ------- */

void stsMapFromStsMarker(struct stsMarker *oldEl, struct stsMap *newEl);
/* Convert from older stsMarker format to stsMap format. */

#endif /* STSMAP_H */

