/* cdsSpec.c was originally generated by the autoSql program, which also 
 * generated cdsSpec.h and cdsSpec.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cdsSpec.h"


void cdsSpecStaticLoad(char **row, struct cdsSpec *ret)
/* Load a row from cdsSpec table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = row[0];
ret->cds = row[1];
}

struct cdsSpec *cdsSpecLoad(char **row)
/* Load a cdsSpec from row fetched with select * from cdsSpec
 * from database.  Dispose of this with cdsSpecFree(). */
{
struct cdsSpec *ret;

AllocVar(ret);
ret->id = cloneString(row[0]);
ret->cds = cloneString(row[1]);
return ret;
}

struct cdsSpec *cdsSpecLoadAll(char *fileName) 
/* Load all cdsSpec from a whitespace-separated file.
 * Dispose of this with cdsSpecFreeList(). */
{
struct cdsSpec *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = cdsSpecLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdsSpec *cdsSpecLoadAllByChar(char *fileName, char chopper) 
/* Load all cdsSpec from a chopper separated file.
 * Dispose of this with cdsSpecFreeList(). */
{
struct cdsSpec *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdsSpecLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdsSpec *cdsSpecCommaIn(char **pS, struct cdsSpec *ret)
/* Create a cdsSpec out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdsSpec */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlStringComma(&s);
ret->cds = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdsSpecFree(struct cdsSpec **pEl)
/* Free a single dynamically allocated cdsSpec such as created
 * with cdsSpecLoad(). */
{
struct cdsSpec *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->cds);
freez(pEl);
}

void cdsSpecFreeList(struct cdsSpec **pList)
/* Free a list of dynamically allocated cdsSpec's */
{
struct cdsSpec *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdsSpecFree(&el);
    }
*pList = NULL;
}

void cdsSpecOutput(struct cdsSpec *el, FILE *f, char sep, char lastSep) 
/* Print out cdsSpec.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cds);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

