/* cgapSage.c was originally generated by the autoSql program, which also 
 * generated cgapSage.h and cgapSage.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cgapSage/cgapSage.h"


struct cgapSage *cgapSageLoad(char **row)
/* Load a cgapSage from row fetched with select * from cgapSage
 * from database.  Dispose of this with cgapSageFree(). */
{
struct cgapSage *ret;

AllocVar(ret);
ret->numLibs = sqlUnsigned(row[8]);
ret->numSnps = sqlUnsigned(row[12]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
{
int sizeOne;
sqlUnsignedDynamicArray(row[9], &ret->libIds, &sizeOne);
assert(sizeOne == ret->numLibs);
}
{
int sizeOne;
sqlUnsignedDynamicArray(row[10], &ret->freqs, &sizeOne);
assert(sizeOne == ret->numLibs);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[11], &ret->tagTpms, &sizeOne);
assert(sizeOne == ret->numLibs);
}
{
int sizeOne;
sqlStringDynamicArray(row[13], &ret->snps, &sizeOne);
assert(sizeOne == ret->numSnps);
}
return ret;
}

struct cgapSage *cgapSageLoadAll(char *fileName) 
/* Load all cgapSage from a whitespace-separated file.
 * Dispose of this with cgapSageFreeList(). */
{
struct cgapSage *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = cgapSageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cgapSage *cgapSageLoadAllByChar(char *fileName, char chopper) 
/* Load all cgapSage from a chopper separated file.
 * Dispose of this with cgapSageFreeList(). */
{
struct cgapSage *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cgapSageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cgapSage *cgapSageCommaIn(char **pS, struct cgapSage *ret)
/* Create a cgapSage out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cgapSage */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->numLibs = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->libIds, ret->numLibs);
for (i=0; i<ret->numLibs; ++i)
    {
    ret->libIds[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->freqs, ret->numLibs);
for (i=0; i<ret->numLibs; ++i)
    {
    ret->freqs[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->tagTpms, ret->numLibs);
for (i=0; i<ret->numLibs; ++i)
    {
    ret->tagTpms[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->numSnps = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->snps, ret->numSnps);
for (i=0; i<ret->numSnps; ++i)
    {
    ret->snps[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void cgapSageFree(struct cgapSage **pEl)
/* Free a single dynamically allocated cgapSage such as created
 * with cgapSageLoad(). */
{
struct cgapSage *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->libIds);
freeMem(el->freqs);
freeMem(el->tagTpms);
/* All strings in snps are allocated at once, so only need to free first. */
if (el->snps != NULL)
    freeMem(el->snps[0]);
freeMem(el->snps);
freez(pEl);
}

void cgapSageFreeList(struct cgapSage **pList)
/* Free a list of dynamically allocated cgapSage's */
{
struct cgapSage *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cgapSageFree(&el);
    }
*pList = NULL;
}

void cgapSageOutput(struct cgapSage *el, FILE *f, char sep, char lastSep) 
/* Print out cgapSage.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->numLibs);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->numLibs; ++i)
    {
    fprintf(f, "%u", el->libIds[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->numLibs; ++i)
    {
    fprintf(f, "%u", el->freqs[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->numLibs; ++i)
    {
    fprintf(f, "%g", el->tagTpms[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%u", el->numSnps);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->numSnps; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->snps[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int cgapSageCmp(const void *va, const void *vb)
/* Compare based on chrom,start,name. */
{
const struct cgapSage *a = *((struct cgapSage **)va);
const struct cgapSage *b = *((struct cgapSage **)vb);
int dif;
dif = strcmp(a->chrom, b->chrom);
if (dif == 0)
    dif = a->chromStart - b->chromStart;
if (dif == 0)
    dif = strcmp(a->name, b->name);
return dif;
}
