/* tableDescriptions.c was originally generated by the autoSql program, which also 
 * generated tableDescriptions.h and tableDescriptions.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "tableDescriptions.h"


void tableDescriptionsStaticLoad(char **row, struct tableDescriptions *ret)
/* Load a row from tableDescriptions table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->tableName = row[0];
ret->autoSqlDef = row[1];
ret->gbdAnchor = row[2];
}

struct tableDescriptions *tableDescriptionsLoad(char **row)
/* Load a tableDescriptions from row fetched with select * from tableDescriptions
 * from database.  Dispose of this with tableDescriptionsFree(). */
{
struct tableDescriptions *ret;

AllocVar(ret);
ret->tableName = cloneString(row[0]);
ret->autoSqlDef = cloneString(row[1]);
ret->gbdAnchor = cloneString(row[2]);
return ret;
}

struct tableDescriptions *tableDescriptionsLoadAll(char *fileName) 
/* Load all tableDescriptions from a whitespace-separated file.
 * Dispose of this with tableDescriptionsFreeList(). */
{
struct tableDescriptions *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = tableDescriptionsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tableDescriptions *tableDescriptionsLoadAllByChar(char *fileName, char chopper) 
/* Load all tableDescriptions from a chopper separated file.
 * Dispose of this with tableDescriptionsFreeList(). */
{
struct tableDescriptions *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = tableDescriptionsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tableDescriptions *tableDescriptionsCommaIn(char **pS, struct tableDescriptions *ret)
/* Create a tableDescriptions out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tableDescriptions */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->tableName = sqlStringComma(&s);
ret->autoSqlDef = sqlStringComma(&s);
ret->gbdAnchor = sqlStringComma(&s);
*pS = s;
return ret;
}

void tableDescriptionsFree(struct tableDescriptions **pEl)
/* Free a single dynamically allocated tableDescriptions such as created
 * with tableDescriptionsLoad(). */
{
struct tableDescriptions *el;

if ((el = *pEl) == NULL) return;
freeMem(el->tableName);
freeMem(el->autoSqlDef);
freeMem(el->gbdAnchor);
freez(pEl);
}

void tableDescriptionsFreeList(struct tableDescriptions **pList)
/* Free a list of dynamically allocated tableDescriptions's */
{
struct tableDescriptions *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    tableDescriptionsFree(&el);
    }
*pList = NULL;
}

void tableDescriptionsOutput(struct tableDescriptions *el, FILE *f, char sep, char lastSep) 
/* Print out tableDescriptions.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tableName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->autoSqlDef);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gbdAnchor);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

