/* dnaMotif.h was originally generated by the autoSql program, which also 
 * generated dnaMotif.c and dnaMotif.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef DNAMOTIF_H
#define DNAMOTIF_H

#ifndef DNAUTIL_H
#include "dnautil.h"
#endif

struct dnaMotif
/* A gapless DNA motif */
{
    struct dnaMotif *next;  /* Next in singly linked list. */
    char *name; /* Motif name. */
    int columnCount;    /* Count of columns in motif. */ 
    float *aProb;       /* Probability of A's in each column. */ 
    float *cProb;       /* Probability of C's in each column. */
    float *gProb;       /* Probability of G's in each column. */
    float *tProb;       /* Probability of T's in each column. */
};

struct dnaMotif *dnaMotifCommaIn(char **pS, struct dnaMotif *ret);
/* Create a dnaMotif out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dnaMotif */

void dnaMotifFree(struct dnaMotif **pEl);
/* Free a single dynamically allocated dnaMotif such as created
 * with dnaMotifLoad(). */

void dnaMotifFreeList(struct dnaMotif **pList);
/* Free a list of dynamically allocated dnaMotif's */

void dnaMotifOutput(struct dnaMotif *el, FILE *f, char sep, char lastSep);
/* Print out dnaMotif.  Separate fields with sep. Follow last field with lastSep. */

#define dnaMotifTabOut(el,f) dnaMotifOutput(el,f,'\t','\n');
/* Print out dnaMotif as a line in a tab-separated file. */

#define dnaMotifCommaOut(el,f) dnaMotifOutput(el,f,',',',');
/* Print out dnaMotif as a comma separated list including final comma. */

float dnaMotifSequenceProb(struct dnaMotif *motif, DNA *dna);
/* Return probability of dna according to motif.  Make sure
 * motif is probabalistic (with call to dnaMotifMakeProbabalistic
 * if you're not sure) before calling this. */

char dnaMotifBestStrand(struct dnaMotif *motif, DNA *dna);
/* Figure out which strand of DNA is better for probabalistic motif. */

double dnaMotifBitScore(struct dnaMotif *motif, DNA *dna);
/* Return logBase2-odds score of dna given a probabalistic motif. */

double dnaMotifBitScoreWithMark0Bg(struct dnaMotif *motif, DNA *dna, double mark0[5]);
/* Return logBase2-odds score of dna given a probabalistic motif and using a 0-order markov model for the background. */

double dnaMotifBitScoreWithMarkovBg(struct dnaMotif *motif, DNA *dna, double mark2[5][5][5]);
/* Return logBase2-odds score of dna given a probabalistic motif using a 2nd-order markov model for the background.
   motif and markd2 must be in log2 format.
   Seq must contain an extra two bases at the front (i.e. we start scoring from dna + 2). */

void dnaMotifMakeLog2(struct dnaMotif *motif);

void dnaMotifNormalize(struct dnaMotif *motif);
/* Make all columns of motif sum to one. */

boolean dnaMotifIsScoreBased(struct dnaMotif *motif);
/* Return TRUE if dnaMotif is score-based (which we decide by
 * the presense of negative values. */

void dnaMotifScoreToProb(struct dnaMotif *motif);
/* Convert motif that is log-odds score based to motif
 * that is probability based.  This assumes that the
 * background distribution is simple: 25% for each base */

void dnaMotifMakeProbabalistic(struct dnaMotif *motif);
/* Change motif, which may be score or count based, to 
 * probabalistic one, where each column adds to 1.0 */

double dnaMotifBitsOfInfo(struct dnaMotif *motif, int pos);
/* Return bits of information at position. */

void dnaMotifPrintProb(struct dnaMotif *motif, FILE *f);
/* Print DNA motif probabilities. */

void dnaMotifToLogoPs2(struct dnaMotif *motif, double widthPerBase, double height, 
                       double minHeight, char *fileName);
/* Write logo corresponding to motif to postScript file, with extended options. minHeight
 * is the minimum height that is excluded from information content scaling.  This allows
 * something to show up in columns with very little information content.  Setting this
 * to be the same as height creates an frequency-based logo.
 */

void dnaMotifToLogoPs(struct dnaMotif *motif, double widthPerBase, double height, 
	char *fileName);
/* Write logo corresponding to motif to postScript file. */

void dnaMotifToLogoPsW(struct dnaMotif *motif, double widthPerBase, double width,
	double height, char *fileName);
/* Write logo corresponding to motif to postScript file. 
 * use the whole window width, rather than just incrementing
 * by widthPerBase */

void dnaMotifToLogoPng(
	struct dnaMotif *motif,	/* Motif to draw. */
	double widthPerBase, 	/* Width of each base. */
	double height, 		/* Max height. */
	char *gsExe, 		/* ghostscript executable, NULL for default */
	char *tempDir,          /* temp dir , NULL for default */
	char *fileName);	/* output png file name. */
/* Write logo corresponding to motif to png file. */

void dnaMotifToLogoPGM(
	struct dnaMotif *motif,	/* Motif to draw. */
	double widthPerBase, 	/* Width of each base. */
	double width, 		/* Max width. */
	double height, 		/* Max height. */
	char *gsExe, 		/* ghostscript executable, NULL for default */
	char *tempDir,          /* temp dir , NULL for default */
	char *fileName);	/* output png file name. */
/* Write logo corresponding to motif to PGM file. */

#endif /* DNAMOTIF_H */

