/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class CopyToReader
extends AbstractXMLFilter {
    private final Map<URI, URI> copyToMap = new HashMap<URI, URI>(16);
    private int chunkLevel = 0;
    private final Stack<String> processRoleStack = new Stack();

    public Map<URI, URI> getCopyToMap() {
        return this.copyToMap;
    }

    @Override
    public void setCurrentFile(URI currentFile) {
        assert (currentFile.isAbsolute());
        super.setCurrentFile(currentFile);
    }

    public void reset() {
        this.chunkLevel = 0;
        this.copyToMap.clear();
        this.processRoleStack.clear();
    }

    @Override
    public void startDocument() throws SAXException {
        this.processRoleStack.push("normal");
        this.getContentHandler().startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String processingRole = atts.getValue("processing-role");
        if (processingRole == null) {
            processingRole = this.processRoleStack.peek();
        }
        this.processRoleStack.push(processingRole);
        String classValue = atts.getValue("class");
        if (this.chunkLevel > 0) {
            ++this.chunkLevel;
        } else if (atts.getValue("chunk") != null) {
            ++this.chunkLevel;
        }
        if (Constants.MAP_TOPICREF.matches(classValue)) {
            this.parseAttribute(atts);
        }
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.processRoleStack.pop();
        if (this.chunkLevel > 0) {
            --this.chunkLevel;
        }
        this.getContentHandler().endElement(uri, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        this.processRoleStack.pop();
        this.getContentHandler().endDocument();
    }

    private void parseAttribute(Attributes atts) {
        URI source;
        URI target = URLUtils.toURI(atts.getValue("copy-to"));
        if (target == null) {
            return;
        }
        String attrScope = atts.getValue("scope");
        if ("external".equals(attrScope) || "peer".equals(attrScope) || target.toString().contains("://") || target.toString().startsWith("#")) {
            return;
        }
        URI targetAbs = URLUtils.stripFragment(target.isAbsolute() ? target : this.currentFile.resolve(target));
        assert (targetAbs.isAbsolute());
        String attrFormat = this.getFormat(atts);
        if (CopyToReader.isFormatDita(attrFormat) && (source = URLUtils.toURI(atts.getValue("href"))) != null) {
            if (source.toString().isEmpty()) {
                this.logger.warn("Copy-to task [href=\"\" copy-to=\"" + String.valueOf(targetAbs) + "\"] was ignored.");
            } else {
                URI sourceAbs = URLUtils.stripFragment(this.currentFile.resolve(source));
                assert (sourceAbs.isAbsolute());
                URI copyToSourceAbs = this.copyToMap.get(targetAbs);
                if (copyToSourceAbs != null) {
                    if (!sourceAbs.equals(copyToSourceAbs)) {
                        this.logger.warn(MessageUtils.getMessage("DOTX065W", source.toString(), targetAbs.toString()).setLocation(atts).toString());
                    }
                } else if (atts.getValue("chunk") == null || !atts.getValue("chunk").contains("to-content")) {
                    this.copyToMap.put(targetAbs, sourceAbs);
                }
            }
        }
    }

    private String getFormat(Attributes atts) {
        String attrClass = atts.getValue("class");
        if (Constants.TOPIC_IMAGE.matches(attrClass)) {
            return "image";
        }
        if (Constants.TOPIC_OBJECT.matches(attrClass)) {
            throw new IllegalArgumentException();
        }
        return atts.getValue("format");
    }

    public static boolean isFormatDita(String attrFormat) {
        if (attrFormat == null || attrFormat.equals("dita")) {
            return true;
        }
        for (String f : Configuration.ditaFormat) {
            if (!f.equals(attrFormat)) continue;
            return true;
        }
        return false;
    }
}

